/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.bamboo.build.context.BuildContextBuilder;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsState;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.v2.build.BuildCancelledDetails;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResultSummaryHelper {
    public static final String SPECS_SOURCE_ID = "specs.source.id";
    private static final String SPECS_FAILURE = "specs.failure";
    private static final String SPECS_SUCCESS = "specs.success";

    private ResultSummaryHelper() {
    }

    public static void updateCancellationDetails(@NotNull ResultsSummary resultsSummary, @Nullable BuildCancelledDetails buildCancellationDetails) {
        if (buildCancellationDetails == null) {
            return;
        }
        resultsSummary.setBuildCancelledDate(buildCancellationDetails.getCancellationDate());
        if (LifeCycleState.isWaiting((LifeCycleState)resultsSummary.getLifeCycleState()) || buildCancellationDetails.isForcedCancellation()) {
            resultsSummary.updateLifeCycleState(LifeCycleState.NOT_BUILT, BuildState.UNKNOWN);
        }
    }

    public static boolean isBambooSpecFailure(@NotNull ImmutableResultsSummary resultsSummary) {
        return Boolean.TRUE.toString().equals(resultsSummary.getCustomBuildData().getOrDefault(SPECS_FAILURE, "false"));
    }

    public static void markAsBambooSpecFailure(@NotNull BuildContextBuilder buildContextBuilder, VcsLocationBambooSpecsState bambooSpecsState) {
        Map<String, String> buildData = ResultSummaryHelper.getSpecsCustomData(bambooSpecsState, false);
        buildContextBuilder.customBuildData(buildData);
    }

    @NotNull
    public static Map<String, String> getSpecsCustomData(VcsLocationBambooSpecsState bambooSpecsState, boolean success) {
        return ImmutableMap.of((Object)(success ? SPECS_SUCCESS : SPECS_FAILURE), (Object)Boolean.TRUE.toString(), (Object)SPECS_SOURCE_ID, (Object)String.valueOf(bambooSpecsState.getId()));
    }

    public static void markAsBambooSpecSuccess(@NotNull BuildContextBuilder buildContextBuilder, VcsLocationBambooSpecsState bambooSpecsState) {
        Map<String, String> buildData = ResultSummaryHelper.getSpecsCustomData(bambooSpecsState, true);
        buildContextBuilder.customBuildData(buildData);
    }

    public static boolean isBambooSpecSuccess(@NotNull ImmutableResultsSummary resultsSummary) {
        return Boolean.TRUE.toString().equals(resultsSummary.getCustomBuildData().getOrDefault(SPECS_SUCCESS, "false"));
    }

    public static boolean isBambooSpecResult(@NotNull ImmutableResultsSummary resultsSummary) {
        return ResultSummaryHelper.isBambooSpecSuccess(resultsSummary) || ResultSummaryHelper.isBambooSpecFailure(resultsSummary);
    }

    public static List<String> getSpecsKeys() {
        return Arrays.asList(SPECS_SUCCESS, SPECS_FAILURE);
    }
}

