/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.search;

import com.atlassian.bamboo.index.AbstractDocumentHitCollector;
import com.atlassian.bamboo.index.FindLatestBuildResultHitCollector;
import com.atlassian.bamboo.index.IndexUtils;
import com.atlassian.bamboo.index.buildresult.BuildResultsSummaryDocument;
import com.atlassian.bamboo.index.buildresult.BuildResultsSummaryDocumentFactory;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.search.IndexedBuildResultsSearcher;
import com.atlassian.bamboo.resultsummary.search.LucenePermissionChecker;
import com.atlassian.bamboo.resultsummary.search.LuceneQueryBuilder;
import com.atlassian.bamboo.resultsummary.search.PermissionFilteringHitCollector;
import com.atlassian.bamboo.security.BambooCachingPermissionManagerFacade;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.utils.BambooFunctions;
import com.atlassian.bamboo.utils.BambooLogUtils;
import com.atlassian.bamboo.utils.collection.PartialList;
import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.LuceneUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.acegisecurity.acls.Permission;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteringTopFieldCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedBuildResultsSearcherImpl
implements IndexedBuildResultsSearcher {
    private static final Logger log = Logger.getLogger(IndexedBuildResultsSearcherImpl.class);
    private static final List<String> CHAIN_PLAN_TYPES = PlanType.getChainPlanTypes().stream().map(arg_0 -> BambooFunctions.getEnumName().apply(arg_0)).collect(Collectors.toList());
    private ILuceneConnection luceneConnection;
    private final Supplier<LucenePermissionChecker.PermissionChecker> permissionCheckerSupplier;
    private BuildResultsSummaryDocumentFactory buildResultsSummaryDocumentFactory;
    private PlanManager planManager;
    private CachedPlanManager cachedPlanManager;
    private static final int MAX_HITS = 10000;

    public IndexedBuildResultsSearcherImpl() {
        this.permissionCheckerSupplier = () -> new LucenePermissionChecker.PermissionChecker(){
            private final BambooCachingPermissionManagerFacade bambooCachingPermissionManagerFacade = (BambooCachingPermissionManagerFacade)ComponentAccessor.PROTOTYPE_CACHING_PERMISSION_MANAGER_FACADE.get();

            @Override
            public Boolean hasPlanPermission(BambooPermission permission, Long permissionPlanId) {
                ImmutablePlan planIdentifier = IndexedBuildResultsSearcherImpl.this.cachedPlanManager.getPlanById(permissionPlanId.longValue(), ImmutableChain.class);
                if (planIdentifier == null) {
                    return false;
                }
                boolean hasPermission = this.bambooCachingPermissionManagerFacade.hasPermission((Permission)permission, (Object)planIdentifier);
                log.debug((Object)String.format("Permission %s %s for plan with id %d", permission.getName(), hasPermission ? "granted" : "not granted", permissionPlanId));
                return hasPermission;
            }
        };
    }

    @VisibleForTesting
    public IndexedBuildResultsSearcherImpl(Supplier<LucenePermissionChecker.PermissionChecker> permissionChecker) {
        this.permissionCheckerSupplier = permissionChecker;
    }

    @Nullable
    public ResultsSummary findLatestRelevantBuildResult(@NotNull PlanIdentifier plan, @NotNull Long beforeLastCompletedTimestamp) {
        Query planKeyQuery = LuceneUtils.buildSingleFieldSingleValueTermQuery((String)"buildKey", (String)plan.getPlanKey().getKey());
        NumericRangeQuery beforeLastCompletedDate = NumericRangeQuery.newLongRange((String)"timestamp", null, (Long)beforeLastCompletedTimestamp, (boolean)true, (boolean)true);
        FindLatestBuildResultHitCollector hitCollector = new FindLatestBuildResultHitCollector(this.buildResultsSummaryDocumentFactory);
        this.search((Query)IndexUtils.buildConjunctionQuery(new Query[]{planKeyQuery, beforeLastCompletedDate, LuceneQueryBuilder.onlyFinishedBuildsQuery()}), hitCollector);
        return hitCollector.getBuildResultsSummary();
    }

    @NotNull
    public <T> List<T> findBuildResultDataByJiraIssueKey(@NotNull Set<String> issueKeys, @NotNull Function<Document, T> transformation) {
        Query issueKeyQuery = LuceneUtils.buildSingleFieldMultiValueTermQuery((String)"jiraIssueKey", issueKeys, (boolean)false);
        Query topLevelPlanQuery = LuceneUtils.buildSingleFieldMultiValueTermQuery((String)"planType", CHAIN_PLAN_TYPES, (boolean)false);
        BooleanQuery topLevelPlansForJiraQuery = IndexUtils.buildConjunctionQuery(issueKeyQuery, topLevelPlanQuery);
        return this.search((Query)topLevelPlansForJiraQuery, -1, transformation).getList();
    }

    @Nullable
    public Document findBuildResultByNumberAndKey(@NotNull PlanKey planKey, int buildNumber) {
        Query buildKeyQuery = LuceneUtils.buildSingleFieldSingleValueTermQuery((String)"buildKey", (String)planKey.getKey());
        Query buildNumberQuery = BuildResultsSummaryDocument.FIELD_BUILD_NUMBER.createQuery((Object)buildNumber);
        BooleanQuery keyAndNumberQuery = IndexUtils.buildConjunctionQuery(buildKeyQuery, buildNumberQuery);
        return (Document)Iterables.getOnlyElement((Iterable)this.search((Query)keyAndNumberQuery, 1, Functions.identity()).getList(), null);
    }

    public List<ResultsSummary> search(Map<String, String[]> params) {
        Query q = LuceneQueryBuilder.generateBrsQuery(params, this.cachedPlanManager, this.planManager);
        return this.search(q, -1).getList();
    }

    @NotNull
    public PartialList<ResultsSummary> search(@NotNull Query query, int maxResults) {
        return this.search(query, maxResults, this.buildResultsSummaryDocumentFactory::getBuildResultsSummary);
    }

    @NotNull
    public <T> PartialList<T> search(@NotNull Query query, int maxResults, Function<Document, T> documentParser) {
        return this.search(query, new SortField("completedTimestamp", SortField.Type.LONG, true), maxResults, documentParser);
    }

    @NotNull
    public <T> PartialList<T> search(final @NotNull Query query, final SortField sortField, final int maxResults, final Function<Document, T> documentParser) {
        final ArrayList results = new ArrayList();
        final AtomicInteger totalResults = new AtomicInteger();
        Stopwatch stopWatch = Stopwatch.createStarted();
        this.luceneConnection.withSearch(new ILuceneConnection.SearcherAction(){

            public void perform(IndexSearcher searcher) throws IOException {
                SortField[] sortFields = new SortField[]{sortField};
                Sort sorter = new Sort(sortFields);
                LucenePermissionChecker lucenePermissionChecker = new LucenePermissionChecker(searcher.getIndexReader(), (LucenePermissionChecker.PermissionChecker)IndexedBuildResultsSearcherImpl.this.permissionCheckerSupplier.get());
                if (maxResults > -1) {
                    TopFieldDocs resultsDocs = IndexedBuildResultsSearcherImpl.search(searcher, lucenePermissionChecker, IndexedBuildResultsSearcherImpl.onlyBuildResults(query), null, maxResults, sorter);
                    for (ScoreDoc scoreDoc : resultsDocs.scoreDocs) {
                        results.add(this.parse(searcher, scoreDoc));
                    }
                    totalResults.set(resultsDocs.totalHits);
                } else {
                    TopFieldDocs hits = searcher.search(IndexedBuildResultsSearcherImpl.onlyBuildResults(query), 10000, sorter);
                    for (ScoreDoc scoreDoc : lucenePermissionChecker.getPermitted((TopDocs)hits)) {
                        results.add(this.parse(searcher, scoreDoc));
                    }
                    totalResults.set(results.size());
                }
            }

            private T parse(IndexSearcher searcher, ScoreDoc scoreDoc) throws IOException {
                return documentParser.apply((Object)searcher.doc(scoreDoc.doc));
            }
        });
        IndexedBuildResultsSearcherImpl.logTime(stopWatch);
        return PartialList.ofKnownSize(results, (int)totalResults.get());
    }

    private static TopFieldDocs search(@NotNull IndexSearcher searcher, @NotNull LucenePermissionChecker permissionChecker, @NotNull Query query, @Nullable Filter filter, int maxResults, Sort sorter) throws IOException {
        boolean fillFields = true;
        boolean trackDocScores = false;
        boolean trackMaxScore = false;
        boolean docsScoredInOrder = false;
        FilteringTopFieldCollector collector = FilteringTopFieldCollector.create((Sort)sorter, (int)maxResults, permissionChecker.predicate(), (boolean)true, (boolean)false, (boolean)false, (boolean)false);
        searcher.search(query, filter, (Collector)collector);
        return (TopFieldDocs)collector.topDocs();
    }

    public int count(@NotNull Query query) {
        AtomicInteger totalResults = new AtomicInteger();
        Stopwatch stopWatch = Stopwatch.createStarted();
        this.luceneConnection.withSearch(searcher -> {
            TopDocs hits = searcher.search(IndexedBuildResultsSearcherImpl.onlyBuildResults(query), 10000);
            LucenePermissionChecker lucenePermissionChecker = new LucenePermissionChecker(searcher.getIndexReader(), this.permissionCheckerSupplier.get());
            totalResults.set((int)lucenePermissionChecker.getPermittedAsStream(hits).count());
        });
        IndexedBuildResultsSearcherImpl.logTime(stopWatch);
        return totalResults.get();
    }

    public void search(Query query, AbstractDocumentHitCollector collector) {
        this.luceneConnection.withSearch(searcher -> {
            collector.setSearcher(searcher);
            LucenePermissionChecker lucenePermissionChecker = new LucenePermissionChecker(searcher.getIndexReader(), this.permissionCheckerSupplier.get());
            searcher.search(IndexedBuildResultsSearcherImpl.onlyBuildResults(query), (Collector)new PermissionFilteringHitCollector(lucenePermissionChecker, collector));
        });
    }

    private static Query onlyBuildResults(Query q) {
        BooleanQuery combinedQuery = new BooleanQuery();
        combinedQuery.add(q, BooleanClause.Occur.MUST);
        combinedQuery.add((Query)new TermQuery(new Term("docType", "buildResult")), BooleanClause.Occur.MUST);
        return combinedQuery;
    }

    private static void logTime(Stopwatch stopWatch) {
        BambooLogUtils.logOperationTime((Logger)log, (Stopwatch)stopWatch, (int)1, (int)2, (int)3, (String)"Search");
    }

    public void setLuceneConnection(ILuceneConnection luceneConnection) {
        this.luceneConnection = luceneConnection;
    }

    public void setBuildResultsSummaryDocumentFactory(BuildResultsSummaryDocumentFactory buildResultsSummaryDocumentFactory) {
        this.buildResultsSummaryDocumentFactory = buildResultsSummaryDocumentFactory;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }
}

