/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.search;

import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.acegisecurity.acls.NotFoundException;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class LucenePermissionChecker {
    private static final Logger log = Logger.getLogger(LucenePermissionChecker.class);
    private final PermissionChecker permissionChecker;
    private final LoadingCache<Long, Boolean> permissionCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Long, Boolean>(){

        public Boolean load(Long permissionPlanId) {
            try {
                return LucenePermissionChecker.this.permissionChecker.hasPlanPermission(BambooPermission.READ, permissionPlanId);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof NotFoundException) {
                    log.debug((Object)("Insufficient permissions for plan with id " + permissionPlanId));
                    return false;
                }
                throw e;
            }
        }
    });
    private final IndexReader reader;
    private final BiPredicate<Integer, Integer> docPredicate = (doc, docBase) -> this.hasDocPermission(doc + docBase);

    public LucenePermissionChecker(IndexReader reader, PermissionChecker permissionChecker) {
        this.reader = reader;
        this.permissionChecker = permissionChecker;
    }

    public boolean hasPermission(ScoreDoc hit) {
        return this.hasDocPermission(hit.doc);
    }

    public boolean hasDocPermission(int docId) {
        try {
            long permissionPlanId = this.getPermissionPlanId(docId);
            return this.hasPermissionForObject(permissionPlanId);
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
            return false;
        }
    }

    private long getPermissionPlanId(int docId) throws IOException {
        Document document = this.reader.document(docId, Collections.singleton("permissionPlanId"));
        Number number = document.getField("permissionPlanId").numericValue();
        return number.longValue();
    }

    private boolean hasPermissionForObject(long permissionPlanId) {
        return permissionPlanId != 0L && this.getCachedPlanPermission(permissionPlanId);
    }

    private boolean getCachedPlanPermission(long permissionPlanId) {
        return (Boolean)this.permissionCache.getUnchecked((Object)permissionPlanId);
    }

    public Iterable<ScoreDoc> getPermitted(TopDocs hits) {
        return this.getPermittedAsStream(hits).collect(Collectors.toList());
    }

    public Stream<ScoreDoc> getPermittedAsStream(TopDocs hits) {
        return Arrays.stream(hits.scoreDocs).filter(this::hasPermission);
    }

    public BiPredicate<Integer, Integer> predicate() {
        return this.docPredicate;
    }

    public static interface PermissionChecker {
        public Boolean hasPlanPermission(BambooPermission var1, Long var2);
    }
}

