/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.search;

import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.index.IndexUtils;
import com.atlassian.bamboo.index.buildresult.BuildResultsSummaryDocument;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.NumberUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;

public class LuceneQueryBuilder {
    private static final Logger log = Logger.getLogger(LuceneQueryBuilder.class);
    public static final String SEARCH_LAST_7_DAYS = "LAST_7_DAYS";
    public static final String SEARCH_LAST_30_DAYS = "LAST_30_DAYS";
    public static final String SEARCH_LAST_90_DAYS = "LAST_90_DAYS";
    public static final String SEARCH_LAST_25_BUILDS = "LAST_25_BUILDS";
    public static final String SEARCH_RANGE = "RANGE";
    public static final String SEARCH_RANGE_DATE_FROM = "dateFrom";
    public static final String SEARCH_RANGE_DATE_TO = "dateTo";
    public static final String PARAM_BUILD_IDS = "buildIds";
    public static final String PARAM_PLAN_KEYS = "buildKeys";
    private static final String AGENT_IDS = "agentIds";
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final String PARAM_DATE_FILTER = "dateFilter";
    public static final String INCLUDE_INCOMPLETE_BUILDS = "includeIncompleteBuilds";

    private LuceneQueryBuilder() {
    }

    public static Query generateBrsQuery(Map<String, String[]> parameters, CachedPlanManager cachedPlanManager, PlanManager planManager) {
        Iterator<Object> rangeQ;
        String[] filters;
        log.debug((Object)"Creating build result search query for Lucene index");
        ArrayList<Object> queries = new ArrayList<Object>();
        BooleanQuery buildsQuery = new BooleanQuery();
        BooleanQuery agentsQuery = new BooleanQuery();
        ArrayList<Object> agentIds = new ArrayList<Object>();
        Term docTypeTerm = new Term("docType", "buildResult");
        queries.add(new TermQuery(docTypeTerm));
        if (!parameters.containsKey(INCLUDE_INCOMPLETE_BUILDS)) {
            log.debug((Object)"Excluding incomplete results");
            queries.add(LuceneQueryBuilder.onlyFinishedBuildsQuery());
        }
        if (parameters.containsKey(AGENT_IDS)) {
            agentIds.addAll(Arrays.asList((Object[])parameters.get(AGENT_IDS)));
            log.debug((Object)String.format("Only selecting results built by agents: %s", agentIds));
        }
        Date dateFrom = null;
        Date dateTo = null;
        if (parameters.containsKey(PARAM_DATE_FILTER) && (filters = parameters.get(PARAM_DATE_FILTER)) != null && filters.length > 0) {
            String string = filters[0];
            if (SEARCH_LAST_7_DAYS.equals(string)) {
                dateFrom = LuceneQueryBuilder.getDateAgo(7);
            } else if (SEARCH_LAST_30_DAYS.equals(string)) {
                dateFrom = LuceneQueryBuilder.getDateAgo(30);
            } else if (SEARCH_LAST_90_DAYS.equals(string)) {
                dateFrom = LuceneQueryBuilder.getDateAgo(90);
            } else if (SEARCH_LAST_25_BUILDS.equals(string)) {
                for (ImmutablePlan plan : LuceneQueryBuilder.getPlans(parameters, cachedPlanManager, planManager)) {
                    buildsQuery.add(LuceneQueryBuilder.getLastBuildsQuery(plan, 25), BooleanClause.Occur.SHOULD);
                }
            } else if (SEARCH_RANGE.equals(string)) {
                if (parameters.containsKey(SEARCH_RANGE_DATE_FROM)) {
                    dateFrom = LuceneQueryBuilder.getDate(parameters, SEARCH_RANGE_DATE_FROM);
                }
                if (parameters.containsKey(SEARCH_RANGE_DATE_TO)) {
                    dateTo = LuceneQueryBuilder.getDate(parameters, SEARCH_RANGE_DATE_TO);
                }
            }
        }
        if (dateFrom != null || dateTo != null) {
            log.debug((Object)String.format("Only selecting results in date range: %s - %s", dateFrom, dateTo));
            rangeQ = NumericRangeQuery.newLongRange((String)"timestamp", (Long)(dateFrom != null ? Long.valueOf(dateFrom.getTime()) : null), (Long)(dateTo != null ? Long.valueOf(dateTo.getTime()) : null), (boolean)true, (boolean)true);
            queries.add(rangeQ);
        }
        if (buildsQuery.clauses().isEmpty()) {
            rangeQ = LuceneQueryBuilder.getPlanIds(parameters, cachedPlanManager).iterator();
            while (rangeQ.hasNext()) {
                long l = (Long)rangeQ.next();
                buildsQuery.add(LuceneQueryBuilder.numericQuery("buildId", l), BooleanClause.Occur.SHOULD);
            }
        }
        for (String string : agentIds) {
            agentsQuery.add(BuildResultsSummaryDocument.FIELD_BUILD_AGENT_ID.createQuery((Object)NumberUtils.stringToLong((String)string)), BooleanClause.Occur.SHOULD);
        }
        if (!agentsQuery.clauses().isEmpty()) {
            queries.add(agentsQuery);
        }
        if (buildsQuery.clauses().isEmpty() && agentsQuery.clauses().isEmpty()) {
            BooleanQuery matchNothing = new BooleanQuery();
            queries.add(matchNothing);
            log.debug((Object)"No particular builds and agents selected, returning empty list");
        } else if (!buildsQuery.clauses().isEmpty()) {
            queries.add(buildsQuery);
        }
        return IndexUtils.buildConjunctionQuery(queries);
    }

    @NotNull
    public static Query onlyFinishedBuildsQuery() {
        return new TermQuery(new Term("lifeCycleState", LifeCycleState.FINISHED.getValue()));
    }

    private static Iterable<Long> getPlanIds(Map<String, String[]> parameters, CachedPlanManager cachedPlanManager) {
        HashSet<Long> planIds = new HashSet<Long>();
        Iterable<Long> planIdsFromParams = LuceneQueryBuilder.getPlanIdsFromParams(parameters);
        String[] planKeysFromParams = LuceneQueryBuilder.getNonNull(parameters.get(PARAM_PLAN_KEYS));
        log.debug((Object)String.format("Only selecting results for plans with IDs: %s, and with keys: %s", planIdsFromParams, Arrays.asList(planKeysFromParams)));
        Iterables.addAll(planIds, planIdsFromParams);
        for (String planKey : planKeysFromParams) {
            ImmutablePlan plan = cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)planKey));
            Preconditions.checkArgument((plan != null ? 1 : 0) != 0, (Object)("Plan [" + planKey + "] not found"));
            assert (plan != null);
            planIds.add(plan.getId());
        }
        return planIds;
    }

    private static Iterable<ImmutablePlan> getPlans(Map<String, String[]> parameters, CachedPlanManager cachedPlanManager, PlanManager planManager) {
        Plan plan;
        ArrayList<ImmutablePlan> plans = new ArrayList<ImmutablePlan>();
        for (Long planId : LuceneQueryBuilder.getPlanIdsFromParams(parameters)) {
            plan = planManager.getPlanById(planId.longValue());
            Preconditions.checkNotNull((Object)plan, (Object)("Unable to find plan " + planId));
            plans.add((ImmutablePlan)plan);
        }
        for (PlanKey planKey : LuceneQueryBuilder.getPlanKeysFromParams(parameters)) {
            plan = cachedPlanManager.getPlanByKey(planKey);
            Preconditions.checkNotNull((Object)plan, (Object)("Unable to find plan " + planKey));
            plans.add((ImmutablePlan)plan);
        }
        return plans;
    }

    private static Iterable<Long> getPlanIdsFromParams(Map<String, String[]> parameters) {
        ArrayList<Long> planIds = new ArrayList<Long>();
        String[] planIdsFromParams = parameters.get(PARAM_BUILD_IDS);
        for (String planIdFromParams : LuceneQueryBuilder.getNonNull(planIdsFromParams)) {
            planIds.add(Long.valueOf(planIdFromParams));
        }
        return planIds;
    }

    private static String[] getNonNull(String[] array) {
        return (String[])MoreObjects.firstNonNull((Object)array, (Object)EMPTY_ARRAY);
    }

    private static Iterable<PlanKey> getPlanKeysFromParams(Map<String, String[]> parameters) {
        ArrayList<PlanKey> planKeys = new ArrayList<PlanKey>();
        String[] planKeysFromParams = parameters.get(PARAM_PLAN_KEYS);
        for (String planKey : LuceneQueryBuilder.getNonNull(planKeysFromParams)) {
            planKeys.add(PlanKeys.getPlanKey((String)planKey));
        }
        return planKeys;
    }

    private static Date getDateAgo(int days) {
        Date date = new LocalDate().minusDays(days).toDate();
        return DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.DAY);
    }

    private static Query getLastBuildsQuery(ImmutablePlan plan, int buildCount) {
        int lastBuildNumber = plan.getLastBuildNumber();
        int firstBuildNumber = lastBuildNumber - buildCount + 1;
        log.debug((Object)String.format("Only selecting build results between #%d - #%d for plan %s/%d", firstBuildNumber, lastBuildNumber, plan.getKey(), plan.getId()));
        return IndexUtils.buildConjunctionQuery(new Query[]{LuceneQueryBuilder.numericQuery("buildId", plan.getId()), NumericRangeQuery.newIntRange((String)BuildResultsSummaryDocument.FIELD_BUILD_NUMBER.getFieldId(), (Integer)firstBuildNumber, (Integer)lastBuildNumber, (boolean)true, (boolean)true)});
    }

    @Nullable
    private static Date getDate(Map<String, String[]> parameters, String paramName) {
        String dateParam;
        String[] dates = parameters.get(paramName);
        if (dates.length > 0 && StringUtils.isNotEmpty((CharSequence)(dateParam = dates[0]))) {
            try {
                Date date = new SimpleDateFormat("dd/MM/yyyy").parse(dateParam);
                return DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.DAY);
            }
            catch (ParseException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    public static Term term(String fld, long value) {
        BytesRef ref = new BytesRef();
        NumericUtils.longToPrefixCoded((long)value, (int)0, (BytesRef)ref);
        return new Term(fld, ref);
    }

    public static Term term(String fld, String value) {
        return new Term(fld, value);
    }

    public static NumericRangeQuery<Integer> numericQuery(String fld, Integer value) {
        return NumericRangeQuery.newIntRange((String)fld, (Integer)value, (Integer)value, (boolean)true, (boolean)true);
    }

    public static NumericRangeQuery<Long> numericQuery(String fld, Long value) {
        return NumericRangeQuery.newLongRange((String)fld, (Long)value, (Long)value, (boolean)true, (boolean)true);
    }
}

