/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.search;

import com.atlassian.bamboo.index.AbstractDocumentHitCollector;
import com.atlassian.bamboo.resultsummary.search.LucenePermissionChecker;
import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

public class PermissionFilteringHitCollector
extends Collector {
    private final LucenePermissionChecker permissionChecker;
    private final AbstractDocumentHitCollector collector;

    public PermissionFilteringHitCollector(LucenePermissionChecker permissionChecker, AbstractDocumentHitCollector collector) {
        this.permissionChecker = permissionChecker;
        this.collector = collector;
    }

    public void collect(int doc) {
        if (this.permissionChecker.hasDocPermission(doc)) {
            this.collector.collect(doc);
        }
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.collector.setScorer(scorer);
    }

    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.collector.setNextReader(context);
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.collector.acceptsDocsOutOfOrder();
    }
}

