/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.FilteredTestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestClassResult;
import com.atlassian.bamboo.resultsummary.tests.TestQuarantineManager;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class FilteredTestResultsAbstract
implements FilteredTestResults<TestClassResult> {
    private static final Logger log = Logger.getLogger(FilteredTestResultsAbstract.class);
    protected final BuildResultsSummary resultsSummary;
    private Multimap<TestClassResult, TestCaseResult> newFailedTestsClassMap;
    private Multimap<TestClassResult, TestCaseResult> existingFailedTestsClassMap;
    private Multimap<TestClassResult, TestCaseResult> fixedTestsClassMap;
    private Multimap<TestClassResult, TestCaseResult> allFailedTestsClassMap;
    private Multimap<TestClassResult, TestCaseResult> quarantinedTestsClassMap;
    private Multimap<TestClassResult, TestCaseResult> skippedTestsClassMap;
    private List<TestCaseResult> failedTestList;
    private List<TestCaseResult> skippedTestList;
    private TestsManager testsManager;
    private TestQuarantineManager testQuarantineManager;

    protected FilteredTestResultsAbstract(BuildResultsSummary resultsSummary) {
        this.resultsSummary = resultsSummary;
    }

    @NotNull
    protected abstract List<TestCaseResult> getBrokenTestList();

    @NotNull
    protected abstract List<TestCaseResult> getFailingTestList();

    @NotNull
    protected abstract List<TestCaseResult> getFixedTestList();

    @NotNull
    public Multimap<TestClassResult, TestCaseResult> getNewFailedTests() {
        if (this.newFailedTestsClassMap == null) {
            this.newFailedTestsClassMap = Multimaps.unmodifiableSetMultimap((SetMultimap)this.getTestsManager().getTestOrderedMap(this.getBrokenTestList()));
        }
        return this.newFailedTestsClassMap;
    }

    @NotNull
    public Multimap<TestClassResult, TestCaseResult> getExistingFailedTests() {
        if (this.existingFailedTestsClassMap == null) {
            this.existingFailedTestsClassMap = Multimaps.unmodifiableSetMultimap((SetMultimap)this.getTestsManager().getTestOrderedMap(this.getFailingTestList()));
        }
        return this.existingFailedTestsClassMap;
    }

    @NotNull
    public Multimap<TestClassResult, TestCaseResult> getFixedTests() {
        if (this.fixedTestsClassMap == null) {
            this.fixedTestsClassMap = Multimaps.unmodifiableSetMultimap((SetMultimap)this.getTestsManager().getTestOrderedMap(this.getFixedTestList()));
        }
        return this.fixedTestsClassMap;
    }

    @NotNull
    public Multimap<TestClassResult, TestCaseResult> getAllFailedTests() {
        if (this.allFailedTestsClassMap == null) {
            this.allFailedTestsClassMap = Multimaps.unmodifiableSetMultimap((SetMultimap)this.getTestsManager().getTestOrderedMap(this.getAllFailedTestList()));
        }
        return this.allFailedTestsClassMap;
    }

    @NotNull
    public List<TestCaseResult> getAllFailedTestList() {
        if (this.failedTestList == null) {
            this.failedTestList = this.getTestsManager().getTestsForBuildResultByState(this.resultsSummary, TestState.FAILED);
        }
        return this.failedTestList;
    }

    @NotNull
    public List<TestCaseResult> getSkippedTestList() {
        if (this.skippedTestList == null) {
            this.skippedTestList = this.getTestsManager().getTestsForBuildResultByState(this.resultsSummary, TestState.SKIPPED);
        }
        return this.skippedTestList;
    }

    @NotNull
    public Multimap<TestClassResult, TestCaseResult> getQuarantinedTests() {
        if (this.quarantinedTestsClassMap == null) {
            this.quarantinedTestsClassMap = Multimaps.unmodifiableSetMultimap((SetMultimap)this.getTestsManager().getTestOrderedMap(this.getTestQuarantineManager().getQuarantinedTestsListForBuildResult(this.resultsSummary)));
        }
        return this.quarantinedTestsClassMap;
    }

    @NotNull
    public Multimap<TestClassResult, TestCaseResult> getSkippedTests() {
        if (this.skippedTestsClassMap == null) {
            this.skippedTestsClassMap = Multimaps.unmodifiableSetMultimap((SetMultimap)this.getTestsManager().getTestOrderedMap(this.getSkippedTestList()));
        }
        return this.skippedTestsClassMap;
    }

    public TestsManager getTestsManager() {
        if (this.testsManager == null) {
            this.testsManager = (TestsManager)ContainerManager.getComponent((String)"testsManager");
        }
        return this.testsManager;
    }

    public TestQuarantineManager getTestQuarantineManager() {
        if (this.testQuarantineManager == null) {
            this.testQuarantineManager = (TestQuarantineManager)ContainerManager.getComponent((String)"testQuarantineManager");
        }
        return this.testQuarantineManager;
    }
}

