/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.resultsummary.tests.DeleteOrphanedTestCaseProvider;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.utils.db.SqlQueryProvider;
import com.google.common.base.Stopwatch;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class RemoveOrphanedTestCaseJob
implements Job {
    private static final Logger log = Logger.getLogger(RemoveOrphanedTestCaseJob.class);
    static final String TABLE_NAME = "ORPHANED_TESTS_CLEANUP_JOB";
    private static final String CLEANUP_TABLE_QUERY = "DELETE FROM ORPHANED_TESTS_CLEANUP_JOB";
    static final int MAX_LIMIT = 1000000;
    private static final String FILL_TABLE_QUERY = "INSERT INTO ORPHANED_TESTS_CLEANUP_JOB SELECT b.BUILD_ID AS build_id, min(BUILD_NUMBER) AS min_build_number FROM BUILDRESULTSUMMARY brs, BUILD b WHERE b.BUILD_TYPE = 'CHAIN' AND b.FULL_KEY = brs.BUILD_KEY GROUP BY b.BUILD_ID";
    @Inject
    private DbmsBean dbmsBean;
    @Inject
    private HibernateTemplate hibernateTemplate;
    private final SqlQueryProvider deleteTestCase = new DeleteOrphanedTestCaseProvider();
    private static final AtomicBoolean inProgress = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        log.info((Object)"Start job");
        if (!inProgress.compareAndSet(false, true)) {
            log.warn((Object)"Job is still in progress");
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.hibernateTemplate.execute(session -> {
                this.removeTestCases(session);
                return null;
            });
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            inProgress.set(false);
        }
        log.info((Object)("Removal of orphaned test cases took " + stopwatch));
    }

    private void removeTestCases(Session session) {
        session.doWork(connection -> {
            this.removeAllRecordsFromTemporaryTable(connection);
            this.fillTemporaryTable(connection);
            this.removeTestCases(connection);
            this.removeAllRecordsFromTemporaryTable(connection);
        });
    }

    private void removeTestCases(Connection connection) throws SQLException {
        boolean requiresAnotherCycle;
        do {
            try (Statement statement = connection.createStatement();){
                String query = this.dbmsBean.getQuery(this.deleteTestCase);
                log.debug((Object)query);
                int removedRecords = statement.executeUpdate(query);
                boolean bl = requiresAnotherCycle = removedRecords > 0;
                if (requiresAnotherCycle) {
                    log.info((Object)("Removed " + removedRecords + " orphaned test cases"));
                }
                connection.commit();
            }
        } while (requiresAnotherCycle);
    }

    private void fillTemporaryTable(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            int insertedRecordsCount = statement.executeUpdate(FILL_TABLE_QUERY);
            log.debug((Object)("Inserted " + insertedRecordsCount + " records to " + TABLE_NAME));
        }
        connection.commit();
    }

    private void removeAllRecordsFromTemporaryTable(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate(CLEANUP_TABLE_QUERY);
        }
        connection.commit();
    }
}

