/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.resultsummary.tests.RemoveOrphanedTestCaseJob;
import com.atlassian.bamboo.schedule.BambooScheduler;
import com.atlassian.bamboo.utils.SystemProperty;
import org.apache.log4j.Logger;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class RemoveOrphanedTestCaseScheduler
implements BambooScheduler {
    private static final Logger log = Logger.getLogger(RemoveOrphanedTestCaseScheduler.class);
    private static final String REMOVE_ORPHANED_TEST_CASE_JOB = "removeOrphanedTestCaseJob";
    private static final String REMOVE_ORPHANED_TEST_CASE_GROUP = "removeOrphanedTestCaseGroup";
    private static final JobKey JOB_KEY = new JobKey("removeOrphanedTestCaseJob", "removeOrphanedTestCaseGroup");
    private static final String REMOVE_ORPHANED_TEST_CASE_TRIGGER = "removeOrphanedTestCaseTrigger";
    private static final TriggerKey TRIGGER_KEY = new TriggerKey("removeOrphanedTestCaseTrigger", "removeOrphanedTestCaseGroup");
    private static final String DEFAULT_CRON_EXPRESSION = "0 0 0 10,25 * ?";
    private final Scheduler quartzScheduler;

    public RemoveOrphanedTestCaseScheduler(Scheduler quartzScheduler) {
        this.quartzScheduler = quartzScheduler;
    }

    public void initialiseSchedule() {
        this.unschedule();
        this.schedule();
    }

    private void unschedule() {
        try {
            this.quartzScheduler.unscheduleJob(TRIGGER_KEY);
        }
        catch (Exception e) {
            log.warn((Object)"Unable to unschedule removeOrphanedTestCaseJob", (Throwable)e);
        }
    }

    private void schedule() {
        try {
            JobDetail jobDetail = JobBuilder.newJob(RemoveOrphanedTestCaseJob.class).withIdentity(JOB_KEY).build();
            String cronExpressionStr = SystemProperty.ORPHANED_TEST_CASE_CRON_SCHEDULE.getValue(DEFAULT_CRON_EXPRESSION);
            CronExpression cronExpression = new CronExpression(cronExpressionStr);
            CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(TRIGGER_KEY).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)cronExpression)).forJob(JOB_KEY).build();
            this.quartzScheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
            log.info((Object)("Used '" + cronExpressionStr + "' to schedule RemoveOrphanedTestCaseJob. Next trigger time " + cronTrigger.getNextFireTime()));
        }
        catch (Exception e) {
            log.error((Object)"Unable to schedule removeOrphanedTestCaseJob", (Throwable)e);
        }
    }
}

