/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.QuarantineStatistics;
import com.atlassian.bamboo.resultsummary.tests.QuarantineStatisticsImpl;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestClass;
import com.atlassian.bamboo.util.BambooStringUtils;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="TEST_CASE")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class TestCaseImpl
extends BambooEntityObject
implements TestCase {
    private static final Logger log = Logger.getLogger(TestCaseImpl.class);
    private static final int MAX_LEN = 4000;
    private String name;
    private TestClass testClass;
    private QuarantineStatistics quarantineStatistics;
    private String linkedJiraIssueKey;
    private int numberOfSuccessRuns = 0;
    private int numberOfFailedRuns = 0;
    private int numberOfSkippedRuns = 0;
    private long averageDuration = 0L;
    private int firstRanBuildNumber = -1;
    private int lastRanBuildNumber = -1;

    public TestCaseImpl() {
        this(null, null);
    }

    public TestCaseImpl(String name) {
        this(name, null);
    }

    public TestCaseImpl(String name, TestClass testClass) {
        this.name = BambooStringUtils.truncateAndAddEllipsisToLengthInBytes((String)name, (int)4000);
        this.testClass = testClass;
        this.quarantineStatistics = null;
    }

    public String getMethodName() {
        return TestResults.methodNameToDescription((String)this.name);
    }

    public double getSuccessPercentage() {
        if (this.getTotalTestRuns() > 0) {
            double percentage = (double)this.numberOfSuccessRuns / (double)this.getTotalTestRuns() * 100.0;
            return Math.floor(percentage);
        }
        return 0.0;
    }

    public int getTotalTestRuns() {
        return this.numberOfFailedRuns + this.numberOfSuccessRuns;
    }

    public String getName() {
        return this.name;
    }

    protected void setNameAndTruncate(String name) {
        this.name = BambooStringUtils.truncateAndAddEllipsisToLengthInBytes((String)name, (int)4000);
    }

    protected void setName(String name) {
        this.name = name;
    }

    public TestClass getTestClass() {
        return this.testClass;
    }

    public void setTestClass(TestClass testClass) {
        this.testClass = testClass;
    }

    public int getNumberOfSuccessRuns() {
        return this.numberOfSuccessRuns;
    }

    public void setNumberOfSuccessRuns(int numberOfSuccessRuns) {
        this.numberOfSuccessRuns = numberOfSuccessRuns;
    }

    public int getNumberOfFailedRuns() {
        return this.numberOfFailedRuns;
    }

    public void setNumberOfFailedRuns(int numberOfFailedRuns) {
        this.numberOfFailedRuns = numberOfFailedRuns;
    }

    public int getNumberOfSkippedRuns() {
        return this.numberOfSkippedRuns;
    }

    public void setNumberOfSkippedRuns(int numberOfSkippedRuns) {
        this.numberOfSkippedRuns = numberOfSkippedRuns;
    }

    public long getAverageDuration() {
        return this.averageDuration;
    }

    public long getAverageDurationInSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.averageDuration);
    }

    public void setAverageDuration(long averageDuration) {
        this.averageDuration = averageDuration;
    }

    public int getFirstRanBuildNumber() {
        return this.firstRanBuildNumber;
    }

    public void setFirstRanBuildNumber(int firstRanBuildNumber) {
        this.firstRanBuildNumber = firstRanBuildNumber;
    }

    public int getLastRanBuildNumber() {
        return this.lastRanBuildNumber;
    }

    public void setLastRanBuildNumber(int lastRanBuildNumber) {
        this.lastRanBuildNumber = lastRanBuildNumber;
    }

    public boolean isQuarantined() {
        return this.quarantineStatistics != null;
    }

    @Deprecated
    public void setQuarantineStatistics(@NotNull String quarantineUser, @NotNull Date quarantineDate) {
        this.setQuarantineStatistics(quarantineUser, quarantineDate, null);
    }

    public void setQuarantineStatistics(@NotNull String quarantineUser, @NotNull Date quarantineDate, @Nullable Date quarantineExpiryDate) {
        this.quarantineStatistics = new QuarantineStatisticsImpl(quarantineDate, quarantineUser, quarantineExpiryDate);
    }

    public void setQuarantineStatistics(@Nullable QuarantineStatistics quarantineStatistics) {
        this.quarantineStatistics = quarantineStatistics;
    }

    @Nullable
    public QuarantineStatistics getQuarantineStatistics() {
        return this.quarantineStatistics;
    }

    public String getLinkedJiraIssueKey() {
        return this.linkedJiraIssueKey;
    }

    public void setLinkedJiraIssueKey(@Nullable String issueKey) {
        this.linkedJiraIssueKey = issueKey;
    }

    @NotNull
    public TestCase copyTestCase() {
        TestCaseImpl testCase = new TestCaseImpl();
        testCase.setName(this.name);
        testCase.setAverageDuration(this.averageDuration);
        testCase.setNumberOfFailedRuns(this.numberOfFailedRuns);
        testCase.setNumberOfSuccessRuns(this.numberOfSuccessRuns);
        testCase.setLastRanBuildNumber(this.lastRanBuildNumber);
        testCase.setFirstRanBuildNumber(this.firstRanBuildNumber);
        return testCase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TestCaseImpl testCase = (TestCaseImpl)((Object)o);
        return Objects.equals(this.getName(), testCase.getName()) && Objects.equals(this.getTestClass(), testCase.getTestClass());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getTestClass());
    }

    public int compareTo(TestCase testCase) {
        return new CompareToBuilder().append((Object)this.testClass, (Object)testCase.getTestClass()).append((Object)this.name, (Object)testCase.getName(), String.CASE_INSENSITIVE_ORDER).toComparison();
    }
}

