/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.collections.message.FinalArrayList;
import com.atlassian.bamboo.hibernate.HibernateBambooEntityObject;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseImpl;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultErrorImpl;
import com.atlassian.bamboo.resultsummary.tests.TestClassResult;
import com.atlassian.bamboo.resultsummary.tests.TestClassResultImpl;
import com.atlassian.bamboo.resultsummary.tests.TestDeltaState;
import com.atlassian.bamboo.resultsummary.tests.TestQuarantineHelper;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.bamboo.security.classlist.WhitelistAssumeRuntimeType;
import com.atlassian.bamboo.security.classlist.WhitelistAssumeRuntimeTypes;
import com.atlassian.bamboo.utils.DurationUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.log4j.Logger;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@BatchSize(size=20)
@Table(name="TEST_CASE_RESULT", indexes={@Index(columnList="TEST_STATE", name="testCaseRes_state_idx"), @Index(columnList="DELTA_STATE", name="testCaseRes_deltaState_idx")})
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
@AttributeOverride(name="id", column=@Column(name="TEST_CASE_RESULT_ID"))
public class TestCaseResultImpl
extends HibernateBambooEntityObject
implements TestCaseResult {
    private static final Logger log = Logger.getLogger(TestCaseResultImpl.class);
    @ManyToOne(targetEntity=TestCaseImpl.class)
    @JoinColumn(name="TEST_CASE_ID")
    private TestCase testCase;
    @ManyToOne(targetEntity=TestClassResultImpl.class)
    @JoinColumn(name="TEST_CLASS_RESULT_ID")
    private TestClassResult testClassResult;
    @Column(name="TEST_STATE")
    @Enumerated(value=EnumType.STRING)
    private TestState state;
    @Column(name="DELTA_STATE")
    @Enumerated(value=EnumType.STRING)
    private TestDeltaState deltaState;
    @Column(name="FAILING_SINCE")
    private int failingSince = -1;
    @Column(name="DURATION")
    private long duration;
    @Column(name="QUARANTINED")
    private boolean quarantined;
    @WhitelistAssumeRuntimeTypes(value={@WhitelistAssumeRuntimeType(value=FinalArrayList.class), @WhitelistAssumeRuntimeType(value=TestCaseResultErrorImpl.class)})
    @OneToMany(mappedBy="testCaseResult", cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=TestCaseResultErrorImpl.class)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private List<TestCaseResultError> testErrors;
    @Transient
    private String cachedPrettyDuration;

    public TestCaseResultImpl() {
    }

    public TestCaseResultImpl(TestCase testCase, long duration, TestState state) {
        this.testCase = testCase;
        this.quarantined = false;
        this.duration = duration;
        this.state = state;
    }

    public TestCaseResultImpl(TestCase testCase, long duration, TestState state, @Nullable List<TestCaseResultError> testCaseResultErrors) {
        this(testCase, duration, state);
        this.setErrors((List<TestCaseResultError>)FinalArrayList.nullOrCopy(testCaseResultErrors));
    }

    @Deprecated
    public TestCaseResultImpl(TestCase testCase, long duration, TestState state, @Nullable List<TestCaseResultError> testCaseResultErrors, List<String> quarantinedTests) {
        this(testCase, duration, state, testCaseResultErrors, new HashSet<String>(quarantinedTests));
    }

    public TestCaseResultImpl(TestCase testCase, long duration, TestState state, @Nullable List<TestCaseResultError> testCaseResultErrors, Set<String> quarantinedTests) {
        this(testCase, duration, state);
        this.setErrors((List<TestCaseResultError>)FinalArrayList.nullOrCopy(testCaseResultErrors));
        this.setQuarantined(TestQuarantineHelper.contains(quarantinedTests, (TestCase)testCase));
    }

    @Nullable
    public String getName() {
        if (this.testCase != null) {
            return this.testCase.getName();
        }
        return null;
    }

    @Nullable
    public String getMethodName() {
        if (this.testCase != null) {
            return this.testCase.getMethodName();
        }
        return null;
    }

    public String getPrettyDuration() {
        if (this.cachedPrettyDuration == null) {
            this.cachedPrettyDuration = DurationUtils.getPrettyPrint((long)this.getDuration(), (boolean)false);
        }
        return this.cachedPrettyDuration;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public void setTestCase(TestCase testCase) {
        this.testCase = testCase;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public TestClassResult getTestClassResult() {
        return this.testClassResult;
    }

    public void setTestClassResult(TestClassResult testClassResult) {
        this.testClassResult = testClassResult;
    }

    @NotNull
    public List<TestCaseResultError> getErrors() {
        if (this.testErrors == null) {
            this.testErrors = new FinalArrayList();
        }
        return this.testErrors;
    }

    private void setErrors(@Nullable List<TestCaseResultError> testErrors) {
        if (testErrors != null) {
            for (TestCaseResultError error : testErrors) {
                error.setTestCaseResult((TestCaseResult)this);
            }
        }
        this.testErrors = testErrors;
    }

    public TestState getState() {
        return this.state;
    }

    public void setState(TestState state) {
        this.state = state;
    }

    public TestDeltaState getDeltaState() {
        return this.deltaState;
    }

    public void setDeltaState(TestDeltaState testDeltaState) {
        this.deltaState = testDeltaState;
    }

    public int getFailingSince() {
        return this.failingSince;
    }

    public void setFailingSince(int buildNumber) {
        this.failingSince = buildNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TestCaseResultImpl that = (TestCaseResultImpl)((Object)o);
        return Objects.equals(this.testCase, that.testCase) && Objects.equals(this.testClassResult, that.testClassResult);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.testCase, this.testClassResult);
    }

    public int compareTo(TestCaseResult testCaseResult) {
        return new CompareToBuilder().append((Object)this.testClassResult, (Object)testCaseResult.getTestClassResult()).append((Object)this.testCase, (Object)testCaseResult.getTestCase()).toComparison();
    }

    public boolean isQuarantined() {
        return this.quarantined;
    }

    public void setQuarantined(boolean quarantined) {
        this.quarantined = quarantined;
    }
}

