/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultStatisticsProvider;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TestCaseResultStatisticsProviderImpl
implements TestCaseResultStatisticsProvider {
    private static final Logger log = Logger.getLogger(TestCaseResultStatisticsProviderImpl.class);
    private final TestCaseResult testCaseResult;
    private final BuildResultsSummary buildResultsSummary;

    public TestCaseResultStatisticsProviderImpl(TestCaseResult testCaseResult, BuildResultsSummary buildResultsSummary) {
        this.testCaseResult = testCaseResult;
        this.buildResultsSummary = buildResultsSummary;
    }

    public BuildState getBuildState() {
        if (TestState.FAILED == this.testCaseResult.getState()) {
            return BuildState.FAILED;
        }
        if (TestState.SUCCESS == this.testCaseResult.getState()) {
            return BuildState.SUCCESS;
        }
        return BuildState.UNKNOWN;
    }

    public int getBuildNumber() {
        return this.buildResultsSummary.getBuildNumber();
    }

    public Date getBuildDate() {
        return this.buildResultsSummary.getBuildDate();
    }

    @NotNull
    public Date getStatDate() {
        return this.buildResultsSummary.getStatDate();
    }

    public long getDuration() {
        return this.testCaseResult.getDuration();
    }

    public long getProcessingDuration() {
        return this.testCaseResult.getDuration();
    }

    public String getClassName() {
        return this.testCaseResult.getTestClassResult().getShortName();
    }

    public String getName() {
        return this.testCaseResult.getName();
    }

    public TestCaseResult getTestCaseResult() {
        return this.testCaseResult;
    }

    public BuildResultsSummary getBuildResultsSummary() {
        return this.buildResultsSummary;
    }
}

