/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.build.statistics.FailurePeriod;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultStatisticsProvider;
import com.atlassian.bamboo.resultsummary.tests.TestCaseSummary;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.bamboo.util.NumberUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestCaseSummaryImpl
implements TestCaseSummary {
    private static final Logger log = Logger.getLogger(TestCaseSummaryImpl.class);
    private long avgElapsedTimeForFailures = 0L;
    private float avgElapsedBuildsForFailures = 0.0f;
    private List<FailurePeriod> failurePeriods;
    private TestCaseResult lastTestCaseResult;
    private BuildResultsSummary lastRanBuild;
    private BuildResultsSummary failingSinceBuild;
    private BuildResultsSummary succeedingSinceBuild;
    private final List<BuildResultsSummary> filteredBuildResults;
    private final TestCase testCase;
    private final PlanKey planKey;
    private final ResultsSummaryManager resultsSummaryManager;
    private final TestsManager testsManager;

    public TestCaseSummaryImpl(@NotNull TestCase testCase, @NotNull PlanKey planKey, @Nullable List<BuildResultsSummary> filteredBuildResults, TestsManager testsManager, ResultsSummaryManager resultsSummaryManager) {
        this.testCase = testCase;
        this.planKey = planKey;
        this.resultsSummaryManager = resultsSummaryManager;
        this.testsManager = testsManager;
        this.filteredBuildResults = filteredBuildResults;
    }

    @Nullable
    public TestCaseResult getLastTestCaseResult() {
        if (this.lastTestCaseResult == null) {
            long lastBuildNum = this.testCase.getLastRanBuildNumber();
            this.lastTestCaseResult = this.testsManager.getTestCaseResults(this.testCase, lastBuildNum).stream().findFirst().orElse(null);
        }
        return this.lastTestCaseResult;
    }

    @Nullable
    public BuildResultsSummary getLastRanBuild() {
        int lastBuildNum;
        if (this.lastRanBuild == null && (lastBuildNum = this.testCase.getLastRanBuildNumber()) != -1) {
            this.lastRanBuild = (BuildResultsSummary)this.resultsSummaryManager.getResultsSummary(PlanKeys.getPlanResultKey((PlanKey)this.planKey, (int)lastBuildNum), BuildResultsSummary.class);
        }
        return this.lastRanBuild;
    }

    public BuildResultsSummary getFailingSinceBuild() {
        int failingSinceBuildNumber;
        TestCaseResult lastTestCaseResult;
        if (this.failingSinceBuild == null && (lastTestCaseResult = this.getLastTestCaseResult()) != null && (failingSinceBuildNumber = lastTestCaseResult.getFailingSince()) != -1) {
            this.failingSinceBuild = (BuildResultsSummary)this.resultsSummaryManager.getResultsSummary(PlanKeys.getPlanResultKey((PlanKey)this.planKey, (int)failingSinceBuildNumber), BuildResultsSummary.class);
        }
        return this.failingSinceBuild;
    }

    @Nullable
    public String getFailingSinceBuildKey() {
        int failingSinceBuildNumber;
        TestCaseResult lastTestCaseResult = this.getLastTestCaseResult();
        if (lastTestCaseResult != null && (failingSinceBuildNumber = lastTestCaseResult.getFailingSince()) != -1) {
            return this.planKey.getKey() + "-" + failingSinceBuildNumber;
        }
        return null;
    }

    public int getCountFailingSince() {
        TestCaseResult lastTestCaseResult = this.getLastTestCaseResult();
        if (lastTestCaseResult != null) {
            int failingSinceBuildNumber = lastTestCaseResult.getFailingSince();
            int lastBuildNumber = this.testCase.getLastRanBuildNumber();
            if (failingSinceBuildNumber != -1 && lastBuildNumber != -1) {
                return lastBuildNumber - failingSinceBuildNumber;
            }
        }
        return 0;
    }

    @Nullable
    public BuildResultsSummary getSucceedingSinceBuild() {
        if (this.succeedingSinceBuild == null) {
            this.succeedingSinceBuild = this.testsManager.getSucceedingSinceBuildResultSummary(this.testCase);
        }
        return this.succeedingSinceBuild;
    }

    @NotNull
    public List<FailurePeriod> getFailurePeriods() {
        if (this.failurePeriods == null) {
            this.initFailurePeriods();
        }
        return this.failurePeriods;
    }

    public long getAverageElapsedTime() {
        if (this.failurePeriods == null) {
            this.initFailurePeriods();
        }
        return this.avgElapsedTimeForFailures;
    }

    public float getAverageElapsedBuilds() {
        if (this.failurePeriods == null) {
            this.initFailurePeriods();
        }
        return this.avgElapsedBuildsForFailures;
    }

    public PlanKey getPlanKey() {
        return this.planKey;
    }

    private void initFailurePeriods() {
        List results = this.filteredBuildResults == null ? this.testsManager.getResultStatistics(this.testCase) : (this.filteredBuildResults.isEmpty() ? Collections.emptyList() : this.testsManager.getResultStatistics(this.testCase, this.filteredBuildResults));
        this.failurePeriods = new ArrayList<FailurePeriod>();
        FailurePeriod openFailurePeriod = null;
        for (TestCaseResultStatisticsProvider result : results) {
            if (TestState.SUCCESS == result.getTestCaseResult().getState() && openFailurePeriod != null) {
                openFailurePeriod.setFixingBuild((ResultsSummary)result.getBuildResultsSummary());
                openFailurePeriod = null;
                continue;
            }
            if (TestState.FAILED != result.getTestCaseResult().getState()) continue;
            if (openFailurePeriod == null) {
                openFailurePeriod = new FailurePeriod(this.planKey, this.testCase.getLastRanBuildNumber());
                this.failurePeriods.add(openFailurePeriod);
            }
            openFailurePeriod.addFailingBuild((ResultsSummary)result.getBuildResultsSummary());
        }
        long totalElapsedTimeForFailures = 0L;
        int totalElapsedBuildsForFailures = 0;
        if (!this.failurePeriods.isEmpty()) {
            for (FailurePeriod failurePeriod : this.failurePeriods) {
                totalElapsedTimeForFailures += failurePeriod.getElapsedTime();
                totalElapsedBuildsForFailures += failurePeriod.getElapsedBuilds();
            }
            this.avgElapsedTimeForFailures = totalElapsedTimeForFailures / (long)this.failurePeriods.size();
            float l = (float)totalElapsedBuildsForFailures / (float)this.failurePeriods.size();
            this.avgElapsedBuildsForFailures = NumberUtils.round((float)l, (int)2);
        }
    }
}

