/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.collections.message.FinalHashSet;
import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseImpl;
import com.atlassian.bamboo.resultsummary.tests.TestClass;
import com.atlassian.bamboo.security.classlist.WhitelistAssumeRuntimeType;
import com.atlassian.bamboo.security.classlist.WhitelistAssumeRuntimeTypes;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="TEST_CLASS")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class TestClassImpl
extends BambooEntityObject
implements TestClass {
    private static final Logger log = Logger.getLogger(TestClassImpl.class);
    private String name;
    private long masterJobId = -1L;
    @WhitelistAssumeRuntimeTypes(value={@WhitelistAssumeRuntimeType(value=FinalHashSet.class), @WhitelistAssumeRuntimeType(value=TestCaseImpl.class)})
    private Set<TestCase> testCases = new FinalHashSet();
    private transient Plan plan;

    public TestClassImpl() {
    }

    public TestClassImpl(String name, Plan plan, long masterJobId) {
        this.name = name;
        this.plan = plan;
        this.masterJobId = masterJobId;
    }

    public String getShortName() {
        if (StringUtils.contains((CharSequence)this.getName(), (CharSequence)".")) {
            return StringUtils.substringAfterLast((String)this.getName(), (String)".");
        }
        return this.getName();
    }

    public void addTest(@NotNull TestCase testCase) {
        testCase.setTestClass((TestClass)this);
        this.testCases.add(testCase);
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @NotNull
    public List<TestCase> getTestCases() {
        return ImmutableList.copyOf(this.testCases);
    }

    private void setTestCases(@NotNull List<TestCase> testCases) {
        this.testCases = new FinalHashSet(testCases);
    }

    public Plan getPlan() {
        return this.plan;
    }

    protected void setPlan(Plan plan) {
        this.plan = plan;
    }

    public long getMasterJobId() {
        return this.masterJobId;
    }

    public void setMasterJobId(long masterJobId) {
        this.masterJobId = masterJobId;
    }

    @NotNull
    public TestClass copyTestClass(@NotNull Plan plan) {
        TestClassImpl newTestClass = new TestClassImpl();
        newTestClass.setName(this.name);
        newTestClass.setPlan(plan);
        newTestClass.setMasterJobId(this.masterJobId);
        for (TestCase testCase : this.getTestCases()) {
            newTestClass.addTest(testCase.copyTestCase());
        }
        return newTestClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TestClassImpl testClass = (TestClassImpl)((Object)o);
        return Objects.equals(this.getName(), testClass.getName()) && Objects.equals(this.getMasterJobId(), testClass.getMasterJobId()) && Objects.equals(this.getPlan(), testClass.getPlan());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getMasterJobId(), this.getPlan());
    }

    public int compareTo(TestClass testClass) {
        return new CompareToBuilder().append((Object)this.plan, (Object)testClass.getPlan()).append(this.masterJobId, testClass.getMasterJobId()).append((Object)this.name, (Object)testClass.getName(), String.CASE_INSENSITIVE_ORDER).toComparison();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("plan", (Object)this.plan.getPlanKey()).add("masterJobId", this.masterJobId).add("name", (Object)this.name).toString();
    }
}

