/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.collections.message.FinalHashSet;
import com.atlassian.bamboo.hibernate.HibernateBambooEntityObject;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultImpl;
import com.atlassian.bamboo.resultsummary.tests.TestClass;
import com.atlassian.bamboo.resultsummary.tests.TestClassImpl;
import com.atlassian.bamboo.resultsummary.tests.TestClassResult;
import com.atlassian.bamboo.security.classlist.WhitelistAssumeRuntimeType;
import com.atlassian.bamboo.security.classlist.WhitelistAssumeRuntimeTypes;
import com.google.common.collect.ImmutableList;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@BatchSize(size=20)
@Table(name="TEST_CLASS_RESULT")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
@AttributeOverride(name="id", column=@Column(name="TEST_CLASS_RESULT_ID"))
public class TestClassResultImpl
extends HibernateBambooEntityObject
implements TestClassResult {
    @ManyToOne(targetEntity=BuildResultsSummaryImpl.class)
    @JoinColumn(name="BUILDRESULTSUMMARY_ID")
    @XStreamOmitField
    private BuildResultsSummary buildResultsSummary;
    @ManyToOne(targetEntity=TestClassImpl.class)
    @JoinColumn(name="TEST_CLASS_ID")
    private TestClass testClass;
    @WhitelistAssumeRuntimeTypes(value={@WhitelistAssumeRuntimeType(value=FinalHashSet.class), @WhitelistAssumeRuntimeType(value=TestCaseResultImpl.class)})
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="testClassResult", orphanRemoval=true, targetEntity=TestCaseResultImpl.class)
    @OnDelete(action=OnDeleteAction.CASCADE)
    @Access(value=AccessType.FIELD)
    private Set<TestCaseResult> testCaseResults = new FinalHashSet();
    @Column(name="DURATION")
    private long duration = 0L;
    @Column(name="FAILED_COUNT")
    private int failedTestCount = 0;
    @Column(name="SUCCESS_COUNT")
    private int successfulTestCount = 0;
    @Transient
    private int skippedTestCount = 0;

    public TestClassResultImpl() {
    }

    public TestClassResultImpl(TestClass testClass, BuildResultsSummary summary) {
        this.testClass = testClass;
        this.buildResultsSummary = summary;
    }

    @Nullable
    public String getName() {
        if (this.testClass != null) {
            return this.testClass.getName();
        }
        return null;
    }

    @Nullable
    public String getShortName() {
        if (this.testClass != null) {
            return this.testClass.getShortName();
        }
        return null;
    }

    public void incrementSuccessfulTestCount() {
        ++this.successfulTestCount;
    }

    public void incrementFailedTestCount() {
        ++this.failedTestCount;
    }

    public TestClass getTestClass() {
        return this.testClass;
    }

    protected void setTestClass(TestClass testClass) {
        this.testClass = testClass;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    @NotNull
    public List<TestCaseResult> getTestCaseResults() {
        if (this.testCaseResults == null) {
            this.testCaseResults = new FinalHashSet();
        }
        return ImmutableList.copyOf(this.testCaseResults);
    }

    @NotNull
    public Set<TestCaseResult> getTestCaseResultsSet() {
        if (this.testCaseResults == null) {
            this.testCaseResults = new FinalHashSet();
        }
        return this.testCaseResults;
    }

    public void addTestCase(TestCaseResult testCaseResult) {
        testCaseResult.setTestClassResult((TestClassResult)this);
        this.testCaseResults.add(testCaseResult);
    }

    public int getFailedTestCount() {
        return this.failedTestCount;
    }

    public void setFailedTestCount(int failedTestCount) {
        this.failedTestCount = failedTestCount;
    }

    public int getSuccessfulTestCount() {
        return this.successfulTestCount;
    }

    public void setSuccessfulTestCount(int successfulTestCount) {
        this.successfulTestCount = successfulTestCount;
    }

    public void incrementSkippedTestCount() {
        ++this.skippedTestCount;
    }

    public int getSkippedTestCount() {
        return this.skippedTestCount;
    }

    public void setSkippedTestCount(int skippedTestCount) {
        this.skippedTestCount = skippedTestCount;
    }

    public BuildResultsSummary getBuildResultsSummary() {
        return this.buildResultsSummary;
    }

    public void setBuildResultsSummary(BuildResultsSummary buildResultsSummary) {
        this.buildResultsSummary = buildResultsSummary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TestClassResultImpl that = (TestClassResultImpl)((Object)o);
        return Objects.equals(this.buildResultsSummary, that.buildResultsSummary) && Objects.equals(this.testClass, that.testClass);
    }

    public int hashCode() {
        return Objects.hash(this.buildResultsSummary, this.testClass);
    }

    public int compareTo(TestClassResult testClassResult) {
        return new CompareToBuilder().append((Object)this.buildResultsSummary, (Object)testClassResult.getBuildResultsSummary()).append((Object)this.testClass, (Object)testClassResult.getTestClass()).toComparison();
    }
}

