/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseImpl;
import com.atlassian.bamboo.resultsummary.tests.TestClass;
import com.atlassian.bamboo.resultsummary.tests.TestClassIdentifier;
import com.atlassian.bamboo.resultsummary.tests.TestClassImpl;
import com.atlassian.bamboo.resultsummary.tests.TestClassResult;
import com.atlassian.bamboo.resultsummary.tests.TestClassResultImpl;
import com.atlassian.bamboo.resultsummary.tests.TestsDao;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;

class TestManagerHelpers {
    private static final Logger log = Logger.getLogger(TestManagerHelpers.class);
    private static final long MAX_PENDING_TEST_CASE_EVICTIONS = SystemProperty.MAX_PENDING_TEST_CASE_EVICTIONS.getTypedValue();
    private final TestClassesHandler testClassesHandler;
    private final TestClassResultHandler testClassResultHandler;
    private final SessionFactory sessionFactory;
    private final Queue<TestClass> pendingEvictions = Lists.newLinkedList();
    private long pendingTestCaseEvictionsCnt;

    TestManagerHelpers(TestsManager testsManager, SessionFactory sessionFactory, TestsDao testsDao, Chain plan, long masterJobId, int buildWithAllTests) {
        this(testsManager, sessionFactory, testsDao, plan, masterJobId, Collections.emptyList(), buildWithAllTests);
    }

    TestManagerHelpers(TestsManager testsManager, SessionFactory sessionFactory, TestsDao testsDao, Chain plan, long masterJobId, List<TestClassResult> testClassResults, int buildNumberWithAllTests) {
        this.sessionFactory = sessionFactory;
        this.testClassesHandler = new TestClassesHandler(testsManager, testsDao, plan, masterJobId, buildNumberWithAllTests);
        this.testClassResultHandler = new TestClassResultHandler(testClassResults);
    }

    public TestClass getTestClass(TestResults testResult) {
        return this.testClassesHandler.getTestClass(testResult);
    }

    public TestClassResult getTestClassResult(TestClass testClass, BuildResultsSummary summary) {
        return this.testClassResultHandler.getTestClassResult(testClass, summary);
    }

    public TestCase getTestCase(TestClass testClass, TestResults testResult) {
        return this.testClassesHandler.getTestCase(testClass, testResult);
    }

    public Collection<TestClassResult> getAllTestClassResults() {
        return this.testClassResultHandler.getAllTestClassResults();
    }

    public void flushAndEvict(@NotNull TestClass testClass) {
        this.pendingEvictions.add(testClass);
        this.pendingTestCaseEvictionsCnt += (long)this.testClassesHandler.getTestCases(testClass).size();
        if (this.pendingTestCaseEvictionsCnt >= MAX_PENDING_TEST_CASE_EVICTIONS) {
            log.debug((Object)"Flushing test data into the database...");
            this.flushAndEvictAll();
        }
    }

    public void flushAndEvictAll() {
        TestClass testClass;
        Session session = this.sessionFactory.getCurrentSession();
        session.flush();
        while ((testClass = this.pendingEvictions.poll()) != null) {
            this.testClassesHandler.evict(session, testClass);
            this.testClassResultHandler.evict(session, testClass);
            session.evict((Object)testClass);
        }
        this.pendingEvictions.clear();
        this.pendingTestCaseEvictionsCnt = 0L;
    }

    private static class TestClassResultHandler {
        private final Map<String, TestClassResult> testClassResultsCache = new HashMap<String, TestClassResult>();

        TestClassResultHandler(Iterable<TestClassResult> testClassResults) {
            for (TestClassResult tcr : testClassResults) {
                this.testClassResultsCache.put(tcr.getTestClass().getName(), tcr);
            }
        }

        public TestClassResult getTestClassResult(TestClass testClass, BuildResultsSummary summary) {
            String className = testClass.getName();
            TestClassResult testClassResult = this.testClassResultsCache.get(className);
            if (testClassResult == null) {
                testClassResult = new TestClassResultImpl(testClass, summary);
                this.testClassResultsCache.put(className, testClassResult);
            }
            return testClassResult;
        }

        public Collection<TestClassResult> getAllTestClassResults() {
            return this.testClassResultsCache.values();
        }

        public void evict(Session session, TestClass testClass) {
            TestClassResult testClassResult = this.testClassResultsCache.get(testClass.getName());
            if (testClassResult == null) {
                return;
            }
            testClassResult.getTestCaseResultsSet().forEach(arg_0 -> ((Session)session).evict(arg_0));
            session.evict((Object)testClassResult);
        }
    }

    private static class TestClassesHandler {
        private final TestsManager testManager;
        private final TestsDao testsDao;
        private final Chain plan;
        private final long masterJobId;
        private final Map<TestClassIdentifier, Map<String, TestCase>> testCases = new HashMap<TestClassIdentifier, Map<String, TestCase>>();
        private final Map<String, TestClass> testClasses;
        private Multimap<TestClass, TestCase> testCasesMultimap;

        TestClassesHandler(TestsManager testManager, TestsDao testsDao, Chain plan, long masterJobId, int buildNumberWithAllTests) {
            this.testManager = testManager;
            this.testsDao = testsDao;
            this.plan = plan;
            this.masterJobId = masterJobId;
            this.testClasses = this.getTestClassesAlreadyKnownForPlan(plan, masterJobId, buildNumberWithAllTests);
        }

        @NotNull
        private Map<String, TestClass> getTestClassesAlreadyKnownForPlan(Chain plan, long masterJobId, int buildWithAllTests) {
            log.debug((Object)"Loading test cases from database.");
            HashMap<String, TestClass> classMap = new HashMap<String, TestClass>();
            this.testCasesMultimap = this.testsDao.getTestClassesMapForPlan((Plan)plan, masterJobId, buildWithAllTests);
            for (TestClass testClass : this.testCasesMultimap.keySet()) {
                classMap.put(testClass.getName(), testClass);
            }
            return classMap;
        }

        @NotNull
        TestClass getTestClass(@NotNull TestResults testResult) {
            String className = testResult.getClassName();
            TestClass testClass = this.testClasses.get(className);
            if (testClass == null) {
                testClass = new TestClassImpl(className, (Plan)this.plan, this.masterJobId);
                this.testManager.saveTestClass(testClass);
                this.testClasses.put(className, testClass);
            }
            return testClass;
        }

        @NotNull
        TestCase getTestCase(@NotNull TestClass testClass, @NotNull TestResults testResult) {
            TestCase testCase;
            String testName = testResult.getActualMethodName();
            Map<String, TestCase> testCasesForClass = this.testCases.get(new TestClassIdentifier(testClass));
            if (testCasesForClass == null) {
                testCasesForClass = new HashMap<String, TestCase>();
                for (TestCase testCase2 : this.testCasesMultimap.get((Object)testClass)) {
                    testCasesForClass.put(testCase2.getName(), testCase2);
                }
                this.testCases.put(new TestClassIdentifier(testClass), testCasesForClass);
            }
            if ((testCase = testCasesForClass.get(testName)) == null) {
                for (TestCase testCaseFromLazyFetch : testClass.getTestCases()) {
                    testCasesForClass.putIfAbsent(testCaseFromLazyFetch.getName(), testCaseFromLazyFetch);
                }
            }
            if ((testCase = testCasesForClass.get(testName)) == null) {
                testCase = new TestCaseImpl(testName, testClass);
                testCasesForClass.put(testCase.getName(), testCase);
            }
            return testCase;
        }

        Map<String, TestCase> getTestCases(TestClass testClass) {
            return this.testCases.get(new TestClassIdentifier(testClass));
        }

        public void evict(Session session, TestClass testClass) {
            this.testClasses.remove(testClass.getName());
            this.testCasesMultimap.get((Object)testClass).forEach(arg_0 -> ((Session)session).evict(arg_0));
            this.testCases.remove(new TestClassIdentifier(testClass));
            this.testCasesMultimap.removeAll((Object)testClass);
        }
    }
}

