/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseDao;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultDao;
import com.atlassian.bamboo.resultsummary.tests.TestQuarantineManager;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.bamboo.utils.collections.AlwaysInvalidatingCacheDecorator;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestQuarantineManagerImpl
implements TestQuarantineManager {
    private static final Logger log = Logger.getLogger(TestQuarantineManagerImpl.class);
    private final TestCaseDao testCaseDao;
    private final TestCaseResultDao testCaseResultDao;
    private final TestsManager testsManager;
    private final CachedPlanManager cachedPlanManager;
    private final CacheLoader<PlanKey, Integer> loader = new CacheLoader<PlanKey, Integer>(){

        @NotNull
        public Integer load(PlanKey planKey) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fetching quarantined tests number for " + planKey + " from db"));
            }
            long loadStart = System.currentTimeMillis();
            ImmutableChain chain = (ImmutableChain)TestQuarantineManagerImpl.this.cachedPlanManager.getPlanByKeyIfOfType(planKey, ImmutableChain.class);
            if (chain != null) {
                int quarantinedTestsNumber = TestQuarantineManagerImpl.this.testCaseDao.countCurrentlyQuarantinedTests(chain);
                long elapsed = System.currentTimeMillis() - loadStart;
                log.debug((Object)("Quarantined tests number for " + chain.getPlanKey() + " loaded in " + elapsed + "ms"));
                return quarantinedTestsNumber;
            }
            return 0;
        }
    };
    private final RemovalListener<PlanKey, Integer> removalListener = new RemovalListener<PlanKey, Integer>(){

        public void onRemoval(RemovalNotification<PlanKey, Integer> notification) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Removing element %s from quarantined tests cache", notification.getKey()));
            }
        }
    };
    private final CacheBuilder<PlanKey, Integer> cacheBuilder = CacheBuilder.newBuilder().softValues().removalListener(this.removalListener);
    private final LoadingCache<PlanKey, Integer> quarantinedTestsNumberMap = AlwaysInvalidatingCacheDecorator.wrap((LoadingCache)this.cacheBuilder.build(this.loader));

    public TestQuarantineManagerImpl(TestCaseDao testCaseDao, TestCaseResultDao testCaseResultDao, TestsManager testsManager, CachedPlanManager cachedPlanManager) {
        this.testCaseDao = testCaseDao;
        this.testCaseResultDao = testCaseResultDao;
        this.testsManager = testsManager;
        this.cachedPlanManager = cachedPlanManager;
    }

    public void quarantineTest(long testId, @NotNull User user, @NotNull Date date) {
        this.quarantineTest(testId, user, date, null);
    }

    public void quarantineTest(long testId, @NotNull User user, @NotNull Date date, @Nullable Date expiryDate) {
        TestCase testCase = this.testsManager.getTestCaseById(testId);
        Preconditions.checkArgument((testCase != null ? 1 : 0) != 0, (Object)"Test case not found");
        Preconditions.checkState((!testCase.isQuarantined() ? 1 : 0) != 0, (Object)"Test case already quarantined");
        this.invalidateQuarantinedTestsCache(testCase);
        testCase.setQuarantineStatistics(user.getName(), date, expiryDate);
        this.testsManager.saveTestCase(testCase);
    }

    public void unleashTest(long testId) {
        TestCase testCase = this.testsManager.getTestCaseById(testId);
        Preconditions.checkArgument((testCase != null ? 1 : 0) != 0, (Object)"Test case not found");
        this.unleashTest(testCase);
    }

    private void invalidateQuarantinedTestsCache(TestCase testCase) {
        PlanKey providedKey = testCase.getTestClass().getPlan().getPlanKey();
        PlanKey planKey = PlanKeys.getChainKeyIfJobKey((PlanKey)providedKey);
        if (planKey != null) {
            this.quarantinedTestsNumberMap.invalidate((Object)planKey);
        } else {
            this.quarantinedTestsNumberMap.invalidate((Object)providedKey);
        }
    }

    @NotNull
    public List<TestCase> getCurrentlyQuarantinedTests(@NotNull ImmutableChain chain) {
        return this.testCaseDao.getQuarantinedTestCasesForChain(chain);
    }

    public int countCurrentlyQuarantinedTests(ImmutableChain chain) {
        try {
            return (Integer)this.quarantinedTestsNumberMap.getUnchecked((Object)chain.getPlanKey());
        }
        catch (Exception ex) {
            log.warn((Object)("Unable to get quarantined tests number for: " + chain.getPlanKey()));
            return 0;
        }
    }

    @Nullable
    public List<TestCaseResult> getQuarantinedTestsListForChainResult(@NotNull ChainResultsSummary chainResultsSummary) {
        return this.testCaseResultDao.getQuarantinedTestCasesForChainResult(chainResultsSummary);
    }

    @NotNull
    public List<TestCaseResult> getQuarantinedTestsListForBuildResult(@NotNull BuildResultsSummary buildResultsSummary) {
        return this.testCaseResultDao.getQuarantinedTestCasesForBuildResult(buildResultsSummary);
    }

    @NotNull
    public List<TestCase> getCurrentlyQuarantinedTests(@NotNull ImmutableJob job) {
        return this.testCaseDao.getQuarantinedTestCasesForJob(job);
    }

    public void unleashTestsWithExpiredQuarantine() {
        List testCaseList = this.testCaseDao.getAllTestCasesWithExpiredQuarantine();
        for (TestCase testCase : testCaseList) {
            this.unleashTest(testCase);
        }
    }

    private void unleashTest(@NotNull TestCase testCase) {
        Preconditions.checkState((boolean)testCase.isQuarantined(), (Object)"Test case already unleashed");
        this.invalidateQuarantinedTestsCache(testCase);
        testCase.setQuarantineStatistics(null);
        this.testsManager.saveTestCase(testCase);
    }
}

