/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.resultsummary.tests.MutableTestResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummary;
import com.google.common.base.MoreObjects;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TestResultsSummaryImpl
implements MutableTestResultsSummary {
    private static final Logger log = Logger.getLogger(TestResultsSummaryImpl.class);
    private int successfulTestCaseCount = 0;
    private int failedTestCaseCount = 0;
    private int totalTestCaseCount = 0;
    private int brokenTestCaseCount = 0;
    private int existingFailedTestCount = 0;
    private int fixedTestCaseCount = 0;
    private int quarantinedTestCaseCount = 0;
    private int skippedTestCaseCount = 0;
    private long totalTestDuration = 0L;

    public TestResultsSummaryImpl() {
    }

    public TestResultsSummaryImpl(int successfulTestCaseCount, int failedTestCaseCount, int totalTestCaseCount, int brokenTestCaseCount, int existingFailedTestCount, int fixedTestCaseCount, int quarantinedTestCaseCount, int skippedTestCaseCount) {
        this.successfulTestCaseCount = successfulTestCaseCount;
        this.failedTestCaseCount = failedTestCaseCount;
        this.totalTestCaseCount = totalTestCaseCount;
        this.brokenTestCaseCount = brokenTestCaseCount;
        this.existingFailedTestCount = existingFailedTestCount;
        this.fixedTestCaseCount = fixedTestCaseCount;
        this.quarantinedTestCaseCount = quarantinedTestCaseCount;
        this.skippedTestCaseCount = skippedTestCaseCount;
    }

    @NotNull
    public String getTestSummaryDescription() {
        if (this.totalTestCaseCount == 0) {
            return "No tests found";
        }
        if (this.failedTestCaseCount != 0) {
            return String.format("%d of %d failed", this.failedTestCaseCount, this.totalTestCaseCount);
        }
        return String.format("%d passed", this.successfulTestCaseCount);
    }

    public boolean hasFailedTestResults() {
        return this.failedTestCaseCount > 0;
    }

    public boolean hasQuarantinedTestResults() {
        return this.quarantinedTestCaseCount > 0;
    }

    public boolean hasIgnoredTestResults() {
        return this.hasQuarantinedTestResults() || this.hasSkippedTestResults();
    }

    public boolean hasSuccessfulTestResults() {
        return this.successfulTestCaseCount > 0;
    }

    public void incrementSuccessCount() {
        ++this.successfulTestCaseCount;
    }

    public void incrementFailedCount() {
        ++this.failedTestCaseCount;
    }

    public void incrementSkippedCount() {
        ++this.skippedTestCaseCount;
    }

    public void incrementTotalCount() {
        ++this.totalTestCaseCount;
    }

    public void incrementNewFailureCount() {
        ++this.brokenTestCaseCount;
    }

    public void incrementExistingFailureCount() {
        ++this.existingFailedTestCount;
    }

    public void incrementFixedCount() {
        ++this.fixedTestCaseCount;
    }

    public void incrementQuarantinedCount() {
        ++this.quarantinedTestCaseCount;
    }

    public void addToTotalDuration(long addition) {
        this.totalTestDuration += addition;
    }

    public int getSuccessfulTestCaseCount() {
        return this.successfulTestCaseCount;
    }

    public void setSuccessfulTestCaseCount(int successfulTestCaseCount) {
        this.successfulTestCaseCount = successfulTestCaseCount;
    }

    public int getFailedTestCaseCount() {
        return this.failedTestCaseCount;
    }

    public void setFailedTestCaseCount(int failedTestCaseCount) {
        this.failedTestCaseCount = failedTestCaseCount;
    }

    public int getTotalTestCaseCount() {
        return this.totalTestCaseCount;
    }

    public void setTotalTestCaseCount(int totalTestCaseCount) {
        this.totalTestCaseCount = totalTestCaseCount;
    }

    public int getNewFailedTestCaseCount() {
        return this.brokenTestCaseCount;
    }

    public void setNewFailedTestCaseCount(int brokenTestCaseCount) {
        this.brokenTestCaseCount = brokenTestCaseCount;
    }

    public int getExistingFailedTestCount() {
        return this.existingFailedTestCount;
    }

    public void setExistingFailedTestCount(int existingFailedTestCount) {
        this.existingFailedTestCount = existingFailedTestCount;
    }

    public int getFixedTestCaseCount() {
        return this.fixedTestCaseCount;
    }

    public void setFixedTestCaseCount(int fixedTestCaseCount) {
        this.fixedTestCaseCount = fixedTestCaseCount;
    }

    public int getQuarantinedTestCaseCount() {
        return this.quarantinedTestCaseCount;
    }

    public int getSkippedTestCaseCount() {
        return this.skippedTestCaseCount;
    }

    public int getIgnoredTestCaseCount() {
        return this.quarantinedTestCaseCount + this.skippedTestCaseCount;
    }

    public boolean hasSkippedTestResults() {
        return this.skippedTestCaseCount > 0;
    }

    public void setSkippedTestCaseCount(int skippedTestCaseCount) {
        this.skippedTestCaseCount = skippedTestCaseCount;
    }

    public void setQuarantinedTestCaseCount(int quarantinedTestCaseCount) {
        this.quarantinedTestCaseCount = quarantinedTestCaseCount;
    }

    public long getTotalTestDuration() {
        return this.totalTestDuration;
    }

    public void setTotalTestDuration(long totalTestDuration) {
        this.totalTestDuration = totalTestDuration;
    }

    public void addCountsFrom(@NotNull TestResultsSummary testResultsSummary) {
        this.setExistingFailedTestCount(this.getExistingFailedTestCount() + testResultsSummary.getExistingFailedTestCount());
        this.setFailedTestCaseCount(this.getFailedTestCaseCount() + testResultsSummary.getFailedTestCaseCount());
        this.setFixedTestCaseCount(this.getFixedTestCaseCount() + testResultsSummary.getFixedTestCaseCount());
        this.setNewFailedTestCaseCount(this.getNewFailedTestCaseCount() + testResultsSummary.getNewFailedTestCaseCount());
        this.setSuccessfulTestCaseCount(this.getSuccessfulTestCaseCount() + testResultsSummary.getSuccessfulTestCaseCount());
        this.setTotalTestCaseCount(this.getTotalTestCaseCount() + testResultsSummary.getTotalTestCaseCount());
        this.setTotalTestDuration(this.getTotalTestDuration() + testResultsSummary.getTotalTestDuration());
        this.setQuarantinedTestCaseCount(this.getQuarantinedTestCaseCount() + testResultsSummary.getQuarantinedTestCaseCount());
        this.setSkippedTestCaseCount(this.getSkippedTestCaseCount() + testResultsSummary.getSkippedTestCaseCount());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("successfulTestCaseCount", this.successfulTestCaseCount).add("failedTestCaseCount", this.failedTestCaseCount).add("totalTestCaseCount", this.totalTestCaseCount).add("brokenTestCaseCount", this.brokenTestCaseCount).add("existingFailedTestCount", this.existingFailedTestCount).add("fixedTestCaseCount", this.fixedTestCaseCount).add("quarantinedTestCaseCount", this.quarantinedTestCaseCount).add("skippedTestCaseCount", this.skippedTestCaseCount).add("totalTestDuration", this.totalTestDuration).toString();
    }
}

