/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilter;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.AbstractResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.tests.FilteredTestResults;
import com.atlassian.bamboo.resultsummary.tests.MutableTestResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseDao;
import com.atlassian.bamboo.resultsummary.tests.TestCaseIdentifier;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultDao;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultImpl;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultStatisticsProvider;
import com.atlassian.bamboo.resultsummary.tests.TestClass;
import com.atlassian.bamboo.resultsummary.tests.TestClassResult;
import com.atlassian.bamboo.resultsummary.tests.TestDeltaState;
import com.atlassian.bamboo.resultsummary.tests.TestManagerHelpers;
import com.atlassian.bamboo.resultsummary.tests.TestQuarantineHelper;
import com.atlassian.bamboo.resultsummary.tests.TestResultsDao;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.bamboo.resultsummary.tests.TestsDao;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestsManagerImpl
implements TestsManager {
    private static final Logger log = Logger.getLogger(TestsManagerImpl.class);
    private final TestCaseDao testCaseDao;
    private final TestCaseResultDao testCaseResultDao;
    private final TestResultsDao testResultsDao;
    private final TestsDao testsDao;
    private final PlanManager planManager;
    private final ResultsSummaryManager resultsSummaryManager;
    @Inject
    @VisibleForTesting
    SessionFactory sessionFactory;

    public TestsManagerImpl(TestCaseDao testCaseDao, TestCaseResultDao testCaseResultDao, TestResultsDao testResultsDao, TestsDao testsDao, PlanManager planManager, ResultsSummaryManager resultsSummaryManager) {
        this.testCaseDao = testCaseDao;
        this.testCaseResultDao = testCaseResultDao;
        this.testResultsDao = testResultsDao;
        this.testsDao = testsDao;
        this.planManager = planManager;
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void saveTestClass(TestClass testClass) {
        this.testsDao.save((BambooObject)testClass);
    }

    public void saveTestCase(TestCase testCase) {
        this.testCaseDao.save((BambooObject)testCase);
    }

    public TestCaseResult getTestCaseResultById(long testCaseId) {
        return this.testCaseResultDao.findById(testCaseId);
    }

    public TestClassResult getTestClassResultById(long testClassResultId) {
        return this.testResultsDao.findById(testClassResultId);
    }

    @Nullable
    public TestClass getTestClassById(long testClassId) {
        return this.testsDao.findById(testClassId);
    }

    @Nullable
    public TestCase getTestCaseById(long testCaseId) {
        return this.testCaseDao.findById(testCaseId);
    }

    @NotNull
    public List<TestCaseResult> getTestsForBuildResultByState(BuildResultsSummary summary, TestState state) {
        return this.testCaseResultDao.getTestsForBuildResultByState((ResultsSummary)summary, state, -1, -1);
    }

    @NotNull
    public List<TestCaseResult> getTestsForBuildResultByState(BuildResultsSummary summary, TestState state, int firstResult, int maxCount) {
        return this.testCaseResultDao.getTestsForBuildResultByState((ResultsSummary)summary, state, firstResult, maxCount);
    }

    @NotNull
    public List<TestCaseResult> getTestsForBuildResultByDeltaState(BuildResultsSummary summary, TestDeltaState deltaState, int firstResult, int maxCount) {
        return this.testCaseResultDao.getTestsForBuildResultByDeltaState((ResultsSummary)summary, deltaState, firstResult, maxCount);
    }

    public List<TestCaseResult> getTestsForChainResultByDeltaState(ChainResultsSummary summary, TestDeltaState deltaState, int firstResult, int maxCount) {
        return this.getTestsForChainResultByDeltaStates(summary, new TestDeltaState[]{deltaState}, firstResult, maxCount);
    }

    @NotNull
    public List<TestCaseResult> getTestsForChainResultByDeltaStates(@NotNull ChainResultsSummary summary, @NotNull TestDeltaState[] deltaStates, int firstResult, int maxCount) {
        return this.testCaseResultDao.getTestsForChainResultByDeltaStates(summary, deltaStates, firstResult, maxCount);
    }

    @NotNull
    public List<TestCaseResult> getTestsForChainResultByState(@NotNull ChainResultsSummary summary, @NotNull TestState testState, int firstResult, int maxCount) {
        return this.testCaseResultDao.getTestsForChainResultByState(summary, testState, firstResult, maxCount);
    }

    @NotNull
    public List<TestCaseResultStatisticsProvider> getResultStatistics(@NotNull TestCase testCase) {
        return this.testCaseResultDao.getResultStatisticsForTestCase(testCase);
    }

    @NotNull
    public List<TestCaseResultStatisticsProvider> getResultStatistics(@NotNull TestCase testCase, @NotNull List<BuildResultsSummary> buildResults) {
        return this.testCaseResultDao.getResultStatisticsForTestCaseAndBuilds(testCase, buildResults);
    }

    @NotNull
    public List<Pair<TestCaseResult, Integer>> getLastNFailingResults(@NotNull TestCase testCase, int number) {
        return this.testCaseResultDao.getLastNFailingResultsForTestCase(testCase, number);
    }

    @NotNull
    public List<Pair<TestCaseResult, Integer>> getLastNFailingResults(@NotNull TestCase testCase, @NotNull List<BuildResultsSummary> buildResults, int number) {
        return this.testCaseResultDao.getLastNFailingResultsForTestCaseAndBuildResults(testCase, buildResults, number);
    }

    @NotNull
    public List<TestCase> getLongestRunningTestCases(@NotNull ImmutablePlan plan) {
        return this.testCaseDao.getLongestRunningTestCasesForPlan(plan);
    }

    @NotNull
    public List<Pair<TestCase, Long>> getMostFailingTestCases(@NotNull ImmutablePlan plan) {
        return this.convertIdsToTestCases(this.testCaseDao.getMostFailingTestCasesForPlan(plan));
    }

    @NotNull
    public List<Pair<TestCase, Long>> getMostFailingTestCases(@NotNull List<BuildResultsSummary> buildResults) {
        return this.convertIdsToTestCases(this.testCaseDao.getMostFailingTestCasesForBuildResults(buildResults));
    }

    @NotNull
    public List<Pair<TestCase, Float>> getLongestToFixTestCases(@NotNull ImmutablePlan plan) {
        return this.convertIdsToTestCases(this.testCaseDao.getLongestToFixTestCasesForPlan(plan));
    }

    public List<Pair<TestCase, Long>> getTopBrokenTests(@NotNull PlanKey planKey, BuildResultsFilter filter) {
        return this.convertIdsToTestCases(this.testCaseDao.getTopBrokenTests(planKey, filter));
    }

    @NotNull
    public List<Pair<TestCase, Float>> getLongestToFixTestCases(@NotNull List<BuildResultsSummary> buildResults) {
        return this.convertIdsToTestCases(this.testCaseDao.getLongestToFixTestCasesForBuildResults(buildResults));
    }

    @NotNull
    public List<TestCaseResult> getTestCaseResults(TestCase testCase, long buildNumber) {
        return this.testCaseResultDao.getTestCaseResults(testCase, buildNumber);
    }

    @Nullable
    public BuildResultsSummary getSucceedingSinceBuildResultSummary(TestCase testCase) {
        return this.testCaseResultDao.getSucceedingSinceBuildResultSummary(testCase);
    }

    public int removeResultsByPlan(@NotNull Plan plan) {
        return this.removeResultsByPlan(plan.getPlanKey());
    }

    public int removeResultsByPlan(@NotNull PlanKey planKey) {
        int result = this.testResultsDao.removeTestClassResultsByPlan(planKey);
        if (result > 0) {
            log.info((Object)String.format("TestsManagerImpl.removeResultsByPlan removed %d objects", result));
        }
        return result;
    }

    @NotNull
    private <T> List<Pair<TestCase, T>> convertIdsToTestCases(@NotNull List<Pair<Long, T>> ids) {
        ArrayList<Pair<TestCase, T>> testCases = new ArrayList<Pair<TestCase, T>>();
        for (Pair<Long, T> pair : ids) {
            TestCase testCase = this.getTestCaseById((Long)pair.first);
            if (testCase == null) continue;
            testCases.add(Pair.make((Object)testCase, (Object)pair.second));
        }
        return testCases;
    }

    @NotNull
    public TreeMultimap<TestClassResult, TestCaseResult> getTestOrderedMap(@NotNull List<TestCaseResult> tests) {
        TreeMultimap testsMap = TreeMultimap.create(Comparators.getNameProviderOrdering(), Comparators.getNameProviderOrdering());
        for (TestCaseResult testCaseResult : tests) {
            testsMap.put((Object)testCaseResult.getTestClassResult(), (Object)testCaseResult);
        }
        return testsMap;
    }

    public void copyTestResultsToBuildResultsSummary(@NotNull BuildResultsSummary summary, @NotNull BuildResults buildResults, @NotNull BuildContext buildContext) {
        Pair<Chain, Long> testClassOwner = this.getTestClassOwner(buildContext);
        if (testClassOwner == null) {
            log.error((Object)("Failed to copy test results to build summary, could not retrieve Plan " + buildContext.getTypedPlanKey()));
            return;
        }
        CurrentBuildResult currentBuildResult = buildContext.getBuildResult();
        List<TestResults> allTests = Stream.of(currentBuildResult.getFailedTestResults(), currentBuildResult.getSuccessfulTestResults(), currentBuildResult.getSkippedTestResults()).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        this.copyTestResultsToBuildResultsSummary((Chain)testClassOwner.getFirst(), (Long)testClassOwner.getSecond(), summary, allTests);
        if (currentBuildResult.getSuccessfulTestResults() != null) {
            buildResults.setSuccessfulTestResults(new ArrayList(currentBuildResult.getSuccessfulTestResults()));
        }
    }

    private Pair<Chain, Long> getTestClassOwner(@NotNull PlanKey planKey) {
        PlanKey chainKey = PlanKeys.getChainKeyFromJobKey((PlanKey)planKey);
        Chain chain = (Chain)this.planManager.getPlanByKey(chainKey, Chain.class);
        Preconditions.checkState((chain != null ? 1 : 0) != 0, (Object)"Chain cannot be null in repopulateTestResultsInBuildResultsSummary");
        Chain jobSource = chain.hasMaster() && chain.getAllJobs().isEmpty() ? chain.getMaster() : chain;
        Optional<Long> masterJobId = jobSource.getAllJobs().stream().filter(job -> job.getBuildKey().equals(planKey.getPartialKey())).findFirst().map(PlanIdentifier::getId);
        return masterJobId.map(id -> Pair.make((Object)chain, (Object)id)).orElse(null);
    }

    private Pair<Chain, Long> getTestClassOwner(@NotNull BuildContext buildContext) {
        PlanKey planKey = buildContext.getTypedPlanKey();
        PlanKey chainKey = PlanKeys.getChainKeyFromJobKey((PlanKey)planKey);
        Chain chain = (Chain)this.planManager.getPlanByKey(chainKey, Chain.class);
        if (chain == null) {
            return null;
        }
        return Pair.make((Object)chain, (Object)buildContext.getEntityId());
    }

    @NotNull
    public List<TestClassResult> getTestClassResults(@NotNull PlanResultKey planResultKey) {
        Preconditions.checkArgument((boolean)PlanKeys.isJobKey((PlanKey)planResultKey.getPlanKey()), (Object)"Only job result keys are supported");
        return this.testResultsDao.getTestClassResults(planResultKey);
    }

    private void copyTestResultsToBuildResultsSummary(@NotNull Chain plan, @NotNull long masterJobId, @NotNull BuildResultsSummary summary, @NotNull List<TestResults> testResults) {
        if (testResults.isEmpty()) {
            return;
        }
        Stopwatch stopWatch = Stopwatch.createStarted();
        ResultsSummary previousResultsSummary = this.getPreviousResultsSummaryWithTestResults(summary);
        int previousSuccessfulResultsSummary = this.getPreviousSuccessfulBuild(summary);
        Map<TestCaseIdentifier, TestCaseResult> previousFailuresAndSkipped = this.getFailuresAndSkipped(previousResultsSummary);
        Set quarantinedTests = TestQuarantineHelper.getQuarantinedTests((Map)summary.getCustomBuildData());
        TestManagerHelpers testManagerCaches = this.newTestManagerHelpers(plan, masterJobId, previousSuccessfulResultsSummary);
        TestResultsSummaryImpl testResultsSummary = new TestResultsSummaryImpl();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got existing test cases for " + summary.getPlanResultKey().getKey() + ", time elapsed: " + stopWatch));
            log.debug((Object)"Writing test cases to database...");
        }
        Iterator orderedTestResults = TestsManagerImpl.orderedValid(testResults).iterator();
        TestClass prevTestClass = null;
        int testClassCount = 0;
        int testCaseCount = 0;
        while (orderedTestResults.hasNext()) {
            TestResults testResult = (TestResults)orderedTestResults.next();
            if (prevTestClass == null) {
                prevTestClass = testManagerCaches.getTestClass(testResult);
            }
            ++testCaseCount;
            if (!testResult.getClassName().equals(prevTestClass.getName())) {
                testManagerCaches.flushAndEvict(prevTestClass);
                log.debug((Object)("Processed test classes: " + ++testClassCount));
                prevTestClass = testManagerCaches.getTestClass(testResult);
            }
            TestClassResult testClassResult = testManagerCaches.getTestClassResult(prevTestClass, summary);
            TestCase testCase = testManagerCaches.getTestCase(prevTestClass, testResult);
            TestCaseResultImpl testCaseResult = new TestCaseResultImpl(testCase, testResult.getDurationMs(), testResult.getState(), this.getErrors(testResult), quarantinedTests);
            this.updateTestCaseResultDeltaInformation(summary, testCaseResult, previousFailuresAndSkipped);
            this.updateSummaryInformation(testCaseResult, testClassResult, testResultsSummary, summary);
            if (this.shouldStoreInDatabase(testCaseResult)) {
                testClassResult.addTestCase((TestCaseResult)testCaseResult);
            }
            this.saveTestCase(testCase);
            testResult.setTestCaseId(testCase.getId());
        }
        testManagerCaches.flushAndEvictAll();
        log.info((Object)("Test migration to BuildResultsSummary complete for " + summary.getPlanResultKey().getKey() + ", " + testClassCount + " test classes, " + testCaseCount + " test cases, time elapsed: " + stopWatch));
        List nonEmptyTestClassResults = testManagerCaches.getAllTestClassResults().stream().filter(BambooPredicates::hasTestCases).collect(Collectors.toList());
        summary.resetTestClassResults(nonEmptyTestClassResults);
        summary.setTestResultsSummary((TestResultsSummary)testResultsSummary);
    }

    @VisibleForTesting
    @NotNull
    TestManagerHelpers newTestManagerHelpers(@NotNull Chain plan, long masterJobId, int buildWithAllTests) {
        return new TestManagerHelpers(this, this.sessionFactory, this.testsDao, plan, masterJobId, buildWithAllTests);
    }

    public void repopulateTestResultsInBuildResultsSummary(@NotNull Plan plan, @NotNull BuildResultsSummary summary, @NotNull List<TestResults> unorderedSuccessfulTests) {
        this.repopulateTestResultsInBuildResultsSummary(summary, unorderedSuccessfulTests);
    }

    public void repopulateTestResultsInBuildResultsSummary(@NotNull BuildResultsSummary summary, @NotNull List<TestResults> unorderedSuccessfulTests) {
        if (summary.getTestResultsSummary().getTotalTestCaseCount() <= 0) {
            return;
        }
        Pair<Chain, Long> testClassOwner = this.getTestClassOwner(summary.getPlanKey());
        if (testClassOwner.getSecond() == null) {
            log.info((Object)"Associated job no longer exists. Skip updates of test results");
            return;
        }
        ResultsSummary previousResultsSummary = this.getPreviousResultsSummaryWithTestResults(summary);
        Map<TestCaseIdentifier, TestCaseResult> previousFailuresAndSkipped = this.getFailuresAndSkipped(previousResultsSummary);
        Set quarantinedTests = TestQuarantineHelper.getQuarantinedTests((Map)summary.getCustomBuildData());
        List<TestClassResult> testClassResults = ((AbstractResultsSummary)summary).getTestClassResults();
        int previousBuildWithAllTests = this.getPreviousSuccessfulBuild(summary);
        TestManagerHelpers testManagerCaches = new TestManagerHelpers(this, this.sessionFactory, this.testsDao, (Chain)testClassOwner.getFirst(), (Long)testClassOwner.getSecond(), testClassResults, previousBuildWithAllTests);
        AtomicInteger fixedTestsCount = new AtomicInteger();
        TestsManagerImpl.orderedValid(unorderedSuccessfulTests).forEach(testResult -> {
            TestClass testClass = testManagerCaches.getTestClass((TestResults)testResult);
            TestClassResult testClassResult = testManagerCaches.getTestClassResult(testClass, summary);
            TestCase testCase = testManagerCaches.getTestCase(testClass, (TestResults)testResult);
            TestCaseResultImpl result = new TestCaseResultImpl(testCase, testResult.getDurationMs(), testResult.getState(), this.getErrors((TestResults)testResult), quarantinedTests);
            result.setTestClassResult(testClassResult);
            this.updateTestCaseResultDeltaInformation(summary, result, previousFailuresAndSkipped);
            if (this.shouldStoreInDatabase(result)) {
                if (!testClassResult.getTestCaseResultsSet().contains((Object)result)) {
                    testClassResult.addTestCase((TestCaseResult)result);
                }
                if (result.getDeltaState() == TestDeltaState.FIXED) {
                    fixedTestsCount.incrementAndGet();
                }
            } else {
                testClassResult.getTestCaseResultsSet().remove((Object)result);
            }
            this.saveTestCase(testCase);
            testResult.setTestCaseId(testCase.getId());
        });
        int newFailedTestsCount = 0;
        int existingFailingTestsCount = 0;
        FilteredTestResults testResults = summary.getFilteredTestResults();
        if (testResults != null) {
            for (TestCaseResult testCaseResult : testResults.getAllFailedTestList()) {
                this.updateTestCaseResultDeltaInformation(summary, testCaseResult, previousFailuresAndSkipped);
                if (TestDeltaState.BROKEN == testCaseResult.getDeltaState()) {
                    ++newFailedTestsCount;
                    continue;
                }
                if (TestDeltaState.FAILING != testCaseResult.getDeltaState()) continue;
                ++existingFailingTestsCount;
            }
        }
        TestResultsSummaryImpl testSummaryImpl = (TestResultsSummaryImpl)summary.getTestResultsSummary();
        int prevFixedTests = testSummaryImpl.getFixedTestCaseCount();
        int prevExistingFailedTests = testSummaryImpl.getExistingFailedTestCount();
        int prevNewFailedTests = testSummaryImpl.getNewFailedTestCaseCount();
        testSummaryImpl.setFixedTestCaseCount(fixedTestsCount.get());
        testSummaryImpl.setExistingFailedTestCount(existingFailingTestsCount);
        testSummaryImpl.setNewFailedTestCaseCount(newFailedTestsCount);
        String prevResultKey = previousResultsSummary != null ? previousResultsSummary.getPlanResultKey().toString() : "NOTHING";
        log.info((Object)("Test delta update for " + summary.getPlanResultKey() + " (against " + prevResultKey + ") complete; new:" + prevNewFailedTests + "->" + newFailedTestsCount + ", existing:" + prevExistingFailedTests + "->" + existingFailingTestsCount + " fixed:" + prevFixedTests + "->" + fixedTestsCount));
        List interestingTestClassResults = testManagerCaches.getAllTestClassResults().stream().filter(BambooPredicates::hasTestCases).collect(Collectors.toList());
        summary.resetTestClassResults(interestingTestClassResults);
    }

    private boolean shouldStoreInDatabase(@NotNull TestCaseResult testCaseResult) {
        return testCaseResult.isQuarantined() || testCaseResult.getDeltaState() != TestDeltaState.PASSING && testCaseResult.getDeltaState() != TestDeltaState.NONE;
    }

    private static Stream<TestResults> orderedValid(List<TestResults> testResults) {
        Comparator byClassName = (o1, o2) -> ObjectUtils.compare((Comparable)((Object)o1.getClassName()), (Comparable)((Object)o2.getClassName()));
        Predicate<TestResults> hasValidName = result -> StringUtils.isNotBlank((CharSequence)result.getActualMethodName());
        return testResults.stream().filter(hasValidName).sorted(byClassName);
    }

    private List<TestCaseResultError> getErrors(TestResults test) {
        if (!test.hasErrors()) {
            return Collections.emptyList();
        }
        List errors = test.getErrors();
        for (TestCaseResultError error : errors) {
            if (error.getId() != 0L) continue;
            error.setId(-1L);
        }
        return errors;
    }

    void updateTestCaseResultDeltaInformation(@NotNull BuildResultsSummary summary, @NotNull TestCaseResult testResult, @NotNull Map<TestCaseIdentifier, TestCaseResult> previousFailuresAndSkipped) {
        int failingSince;
        TestDeltaState deltaState;
        boolean isPreviousResultFailing;
        TestCaseResult previousResult = previousFailuresAndSkipped.get(new TestCaseIdentifier(testResult.getTestCase()));
        boolean bl = isPreviousResultFailing = previousResult != null && previousResult.getFailingSince() > 0;
        if (TestState.SUCCESS == testResult.getState()) {
            deltaState = isPreviousResultFailing ? TestDeltaState.FIXED : TestDeltaState.PASSING;
            failingSince = isPreviousResultFailing ? previousResult.getFailingSince() : -1;
        } else if (TestState.FAILED == testResult.getState()) {
            deltaState = isPreviousResultFailing ? TestDeltaState.FAILING : TestDeltaState.BROKEN;
            failingSince = isPreviousResultFailing ? previousResult.getFailingSince() : summary.getBuildNumber();
        } else {
            deltaState = TestDeltaState.SKIPPED;
            failingSince = isPreviousResultFailing ? previousResult.getFailingSince() : -1;
        }
        testResult.setDeltaState(deltaState);
        testResult.setFailingSince(failingSince);
    }

    @VisibleForTesting
    void updateSummaryInformation(@NotNull TestCaseResult result, @NotNull TestClassResult testClassResult, @NotNull MutableTestResultsSummary testResultsSummary, @NotNull BuildResultsSummary buildResultsSummary) {
        TestCase testCase = result.getTestCase();
        testClassResult.setDuration(testClassResult.getDuration() + result.getDuration());
        testResultsSummary.addToTotalDuration(result.getDuration());
        if (!buildResultsSummary.isOnceOff()) {
            long currentAverage = testCase.getAverageDuration();
            int currentRunCount = testCase.getTotalTestRuns();
            long newAverage = (currentAverage * (long)currentRunCount + result.getDuration()) / (long)(currentRunCount + 1);
            testCase.setAverageDuration(newAverage);
            if (testCase.getFirstRanBuildNumber() == -1) {
                testCase.setFirstRanBuildNumber(buildResultsSummary.getBuildNumber());
            }
            if (testCase.getLastRanBuildNumber() < buildResultsSummary.getBuildNumber()) {
                testCase.setLastRanBuildNumber(buildResultsSummary.getBuildNumber());
            }
        }
        testResultsSummary.incrementTotalCount();
        if (result.isQuarantined()) {
            testResultsSummary.incrementQuarantinedCount();
        } else {
            if (result.getState() != null) {
                switch (result.getState()) {
                    case SUCCESS: {
                        testResultsSummary.incrementSuccessCount();
                        if (buildResultsSummary.isOnceOff()) break;
                        testClassResult.incrementSuccessfulTestCount();
                        testCase.setNumberOfSuccessRuns(testCase.getNumberOfSuccessRuns() + 1);
                        break;
                    }
                    case FAILED: {
                        testResultsSummary.incrementFailedCount();
                        if (buildResultsSummary.isOnceOff()) break;
                        testClassResult.incrementFailedTestCount();
                        testCase.setNumberOfFailedRuns(testCase.getNumberOfFailedRuns() + 1);
                        break;
                    }
                    case SKIPPED: {
                        testResultsSummary.incrementSkippedCount();
                        if (buildResultsSummary.isOnceOff()) break;
                        testClassResult.incrementSkippedTestCount();
                        testCase.setNumberOfSkippedRuns(testCase.getNumberOfSkippedRuns() + 1);
                        break;
                    }
                    default: {
                        log.info((Object)("Test case result " + result.getName() + " is in state " + result.getState()));
                    }
                }
            }
            if (result.getDeltaState() != null) {
                switch (result.getDeltaState()) {
                    case BROKEN: {
                        testResultsSummary.incrementNewFailureCount();
                        break;
                    }
                    case FIXED: {
                        testResultsSummary.incrementFixedCount();
                        break;
                    }
                    case FAILING: {
                        testResultsSummary.incrementExistingFailureCount();
                    }
                }
            }
        }
    }

    @NotNull
    private Map<TestCaseIdentifier, TestCaseResult> getFailuresAndSkipped(@Nullable ResultsSummary resultsSummary) {
        HashMap<TestCaseIdentifier, TestCaseResult> previousResults = new HashMap<TestCaseIdentifier, TestCaseResult>();
        if (resultsSummary == null) {
            return previousResults;
        }
        BuildResultsSummary previousBuildResultsSummary = (BuildResultsSummary)Narrow.to((Object)resultsSummary, BuildResultsSummary.class);
        if (previousBuildResultsSummary == null) {
            return previousResults;
        }
        FilteredTestResults testResults = previousBuildResultsSummary.getFilteredTestResults();
        if (testResults != null) {
            Iterable failedAndSkippedIterable = Iterables.concat((Iterable)testResults.getSkippedTestList(), (Iterable)testResults.getAllFailedTestList());
            for (TestCaseResult testCaseResult : failedAndSkippedIterable) {
                previousResults.put(new TestCaseIdentifier(testCaseResult.getTestCase()), testCaseResult);
            }
        }
        return previousResults;
    }

    @Nullable
    private ResultsSummary getPreviousResultsSummaryWithTestResults(BuildResultsSummary buildResultsSummary) {
        if (buildResultsSummary.isOnceOff()) {
            return null;
        }
        return this.resultsSummaryManager.findLastBuildResultBeforeWithTests(buildResultsSummary.getPlanResultKey(), BuildResultsSummary.class, false);
    }

    private int getPreviousSuccessfulBuild(BuildResultsSummary buildResultsSummary) {
        if (buildResultsSummary.isOnceOff()) {
            return -1;
        }
        ResultsSummary lastSuccessfulBuildResultBefore = this.resultsSummaryManager.findLastSuccessfulBuildResultBefore(buildResultsSummary.getPlanResultKey(), false);
        if (lastSuccessfulBuildResultBefore == null) {
            return -1;
        }
        return lastSuccessfulBuildResultBefore.getBuildNumber();
    }
}

