/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.variables;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.AbstractResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.variables.ResultsSummaryVariableAccessor;
import com.atlassian.bamboo.utils.XsrfUtils;
import com.atlassian.bamboo.variable.StageVariableContextImpl;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableContextImpl;
import com.atlassian.bamboo.variable.VariableContextSnapshot;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableDefinitionContextImpl;
import com.atlassian.bamboo.variable.VariableDefinitionIdentifier;
import com.atlassian.bamboo.variable.VariableSubstitutionContext;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.bamboo.variable.VariableUtils;
import com.atlassian.bamboo.variable.baseline.VariableBaselineItem;
import com.atlassian.bamboo.variable.baseline.VariableContextBaseline;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineDao;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResultsSummaryVariableAccessorImpl
implements ResultsSummaryVariableAccessor {
    private static final Logger log = Logger.getLogger(ResultsSummaryVariableAccessorImpl.class);
    private static final int VALID_FORMAT_VERSION_FOR_VARIABLES = 5706;
    private final ResultsSummaryManager resultsSummaryManager;
    private final VariableContextBaselineDao variableContextBaselineDao;

    public ResultsSummaryVariableAccessorImpl(ResultsSummaryManager resultsSummaryManager, VariableContextBaselineDao variableContextBaselineDao) {
        this.resultsSummaryManager = resultsSummaryManager;
        this.variableContextBaselineDao = variableContextBaselineDao;
    }

    private boolean isVariableDataUpToDate(ChainResultsSummary chainResultsSummary) {
        return chainResultsSummary.getFormatVersion() >= 5706;
    }

    @Nullable
    private ChainResultsSummary getValidChainResultSummaryByKey(@NotNull PlanResultKey chainResultKey) {
        ChainResultsSummary chainResultsSummary = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(chainResultKey, ChainResultsSummary.class);
        if (!(chainResultsSummary == null || this.isVariableDataUpToDate(chainResultsSummary) || XsrfUtils.areMutativeGetsForbiddenByConfig() && !XsrfUtils.noRequestOrRequestCanMutateState())) {
            this.upgradeVariableData(chainResultsSummary);
        }
        return chainResultsSummary;
    }

    public void upgradeVariableDataIfNeeded(@NotNull PlanResultKey chainResultKey) {
        ChainResultsSummary chainResultsSummary = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(chainResultKey, ChainResultsSummary.class);
        if (chainResultsSummary != null && !this.isVariableDataUpToDate(chainResultsSummary)) {
            this.upgradeVariableData(chainResultsSummary);
        }
    }

    private Map<String, VariableContextSnapshot> getChainVariableContextLogsUniqueKeys(@NotNull ChainResultsSummary chainResultsSummary) {
        HashMap<String, VariableContextSnapshot> variableContextSnapshots = new HashMap<String, VariableContextSnapshot>();
        for (VariableContextSnapshot variableContextSnapshot : chainResultsSummary.getVariableContextLogs()) {
            VariableContextSnapshot alreadyInMap = (VariableContextSnapshot)variableContextSnapshots.get(variableContextSnapshot.getKey());
            if (alreadyInMap != null && alreadyInMap.getId() <= variableContextSnapshot.getId()) continue;
            variableContextSnapshots.put(variableContextSnapshot.getKey(), variableContextSnapshot);
        }
        return variableContextSnapshots;
    }

    private VariableContextBaseline getVariableContextBaselineForResult(@NotNull ChainResultsSummary chainResultsSummary) {
        Long variableContextBaselineId = chainResultsSummary.getVariableContextBaselineId();
        if (variableContextBaselineId != null) {
            return this.variableContextBaselineDao.getVariableContextBaseline(variableContextBaselineId.longValue());
        }
        return null;
    }

    private void upgradeVariableData(@NotNull ChainResultsSummary chainResultsSummary) {
        VariableContextBaseline newVariableContextBaseline = null;
        for (ChainStageResult chainStageResult : chainResultsSummary.getStageResults()) {
            BuildResultsSummary brs = (BuildResultsSummary)Iterables.getFirst((Iterable)chainStageResult.getBuildResults(), null);
            if (brs == null) continue;
            newVariableContextBaseline = this.variableContextBaselineDao.resolveVariableContextBaseline((VariableContext)new VariableContextImpl(VariableUtils.identifiersToContextMap(brs.getVariableContextLogs())));
            break;
        }
        Map<String, VariableContextSnapshot> variableContextSnapshots = this.getChainVariableContextLogsUniqueKeys(chainResultsSummary);
        HashMap<String, Object> knownVariables = new HashMap<String, Object>();
        if (newVariableContextBaseline != null) {
            for (VariableBaselineItem variableBaselineItem : newVariableContextBaseline.getVariables()) {
                variableContextSnapshots.remove(variableBaselineItem.getKey());
                knownVariables.put(variableBaselineItem.getKey(), variableBaselineItem);
            }
        }
        chainResultsSummary.getVariableContextLogs().clear();
        chainResultsSummary.getVariableContextLogs().addAll(variableContextSnapshots.values());
        knownVariables.putAll(variableContextSnapshots);
        for (ChainStageResult chainStageResult : chainResultsSummary.getStageResults()) {
            for (BuildResultsSummary brs : chainStageResult.getBuildResults()) {
                for (VariableContextSnapshot vdc : brs.getVariableContextLogs()) {
                    if (knownVariables.containsKey(vdc.getKey()) && Objects.equals(vdc.getValue(), ((VariableDefinitionIdentifier)knownVariables.get(vdc.getKey())).getValue())) continue;
                    chainStageResult.getManualVariables().add(new StageVariableContextImpl(vdc.getKey(), vdc.getValue(), VariableType.MANUAL, chainStageResult));
                    knownVariables.put(vdc.getKey(), vdc);
                }
                for (VariableSubstitutionContext vsc : brs.getManuallyOverriddenVariables()) {
                    if (knownVariables.containsKey(vsc.getKey()) && Objects.equals(vsc.getValue(), ((VariableDefinitionIdentifier)knownVariables.get(vsc.getKey())).getValue())) continue;
                    chainStageResult.getManualVariables().add(new StageVariableContextImpl(vsc.getKey(), vsc.getValue(), VariableType.MANUAL, chainStageResult));
                    knownVariables.put(vsc.getKey(), vsc);
                }
            }
        }
        ArrayList<Object> manualVariablesUnaccountedFor = new ArrayList<Object>();
        VariableContextBaseline existingBaseline = this.getVariableContextBaselineForResult(chainResultsSummary);
        if (existingBaseline != null) {
            for (Object vbi : existingBaseline.getVariables()) {
                if (knownVariables.containsKey(vbi.getKey())) continue;
                manualVariablesUnaccountedFor.add(vbi);
            }
        }
        if (!manualVariablesUnaccountedFor.isEmpty()) {
            Object vbi;
            ChainStageResult stageToAddTo = null;
            vbi = chainResultsSummary.getStageResults().iterator();
            while (vbi.hasNext()) {
                ChainStageResult chainStageResult;
                stageToAddTo = chainStageResult = (ChainStageResult)vbi.next();
                if (!chainStageResult.isRestartable() && !chainResultsSummary.isContinuable()) continue;
                break;
            }
            if (stageToAddTo != null) {
                for (VariableBaselineItem variableBaselineItem : manualVariablesUnaccountedFor) {
                    stageToAddTo.getManualVariables().add(new StageVariableContextImpl(variableBaselineItem.getKey(), variableBaselineItem.getValue(), VariableType.MANUAL, stageToAddTo));
                }
            } else {
                log.debug((Object)"Can't find stageToAdd");
            }
        }
        ((AbstractResultsSummary)chainResultsSummary).setVariableContextBaseline(newVariableContextBaseline);
        chainResultsSummary.updateFormatVersion();
        for (ChainStageResult chainStageResult : chainResultsSummary.getStageResults()) {
            for (BuildResultsSummary brs : chainStageResult.getBuildResults()) {
                ((AbstractResultsSummary)brs).setVariableContextBaseline(newVariableContextBaseline);
                brs.getVariableContextLogs().clear();
                brs.getSubstitutedVariables().clear();
                brs.updateFormatVersion();
                this.resultsSummaryManager.saveResultSummary((ResultsSummary)brs);
            }
        }
        this.resultsSummaryManager.saveResultSummary((ResultsSummary)chainResultsSummary);
    }

    private Map<String, VariableDefinitionContext> legacyInitialVariablesState(ChainResultsSummary chainResultsSummary) {
        HashMap<String, VariableDefinitionContext> variables = new HashMap<String, VariableDefinitionContext>();
        for (ChainStageResult chainStageResult : chainResultsSummary.getStageResults()) {
            BuildResultsSummary brs = (BuildResultsSummary)Iterables.getFirst((Iterable)chainStageResult.getBuildResults(), null);
            if (brs == null) continue;
            variables.putAll(VariableUtils.identifiersToContextMap(brs.getVariableContextLogs()));
            break;
        }
        return variables;
    }

    private Map<String, VariableDefinitionContext> legacyCurrentVariablesState(ChainResultsSummary chainResultsSummary) {
        Map<String, VariableDefinitionContext> variables = this.legacyInitialVariablesState(chainResultsSummary);
        for (ChainStageResult chainStageResult : chainResultsSummary.getStageResults()) {
            for (BuildResultsSummary brs : chainStageResult.getBuildResults()) {
                for (VariableContextSnapshot vdc : brs.getVariableContextLogs()) {
                    if (variables.containsKey(vdc.getKey()) && Objects.equals(vdc.getValue(), variables.get(vdc.getKey()).getValue())) continue;
                    variables.put(vdc.getKey(), new VariableDefinitionContextImpl(vdc.getKey(), vdc.getValue(), VariableType.MANUAL));
                }
                for (VariableSubstitutionContext vsc : brs.getManuallyOverriddenVariables()) {
                    if (variables.containsKey(vsc.getKey()) && Objects.equals(vsc.getValue(), variables.get(vsc.getKey()).getValue())) continue;
                    variables.put(vsc.getKey(), new VariableDefinitionContextImpl(vsc.getKey(), vsc.getValue(), VariableType.MANUAL));
                }
            }
        }
        VariableContextBaseline existingBaseline = this.getVariableContextBaselineForResult(chainResultsSummary);
        if (existingBaseline != null) {
            for (VariableBaselineItem vbi : existingBaseline.getVariables()) {
                if (variables.containsKey(vbi.getKey())) continue;
                variables.put(vbi.getKey(), new VariableDefinitionContextImpl(vbi.getKey(), vbi.getValue(), VariableType.MANUAL));
            }
        }
        return variables;
    }

    @NotNull
    private Map<String, VariableDefinitionContext> calculateInitialVariablesState(@NotNull ChainResultsSummary chainResultsSummary) {
        HashMap<String, VariableDefinitionContext> definitions = new HashMap<String, VariableDefinitionContext>();
        if (!this.isVariableDataUpToDate(chainResultsSummary)) {
            return this.legacyInitialVariablesState(chainResultsSummary);
        }
        VariableContextBaseline variableContextBaseline = this.getVariableContextBaselineForResult(chainResultsSummary);
        if (variableContextBaseline != null) {
            definitions.putAll(VariableUtils.identifiersToContextMap((Iterable<? extends VariableDefinitionIdentifier>)variableContextBaseline.getVariables()));
        }
        definitions.putAll(VariableUtils.identifiersToContextMap(chainResultsSummary.getVariableContextLogs()));
        return definitions;
    }

    @NotNull
    public Map<String, VariableDefinitionContext> calculateInitialVariablesState(@NotNull PlanResultKey chainResultKey) {
        ChainResultsSummary chainResultsSummary = this.getValidChainResultSummaryByKey(chainResultKey);
        if (chainResultsSummary == null) {
            return new HashMap<String, VariableDefinitionContext>();
        }
        return this.calculateInitialVariablesState(chainResultsSummary);
    }

    @NotNull
    public List<VariableDefinitionContext> getManualVariables(@NotNull ChainResultsSummary chainResultsSummary) {
        Map<String, VariableDefinitionContext> initialState = this.calculateInitialVariablesState(chainResultsSummary);
        return initialState.values().stream().filter(arg_0 -> ((Predicate)VariableType.MANUAL.isTypeEqual()).apply(arg_0)).collect(Collectors.toList());
    }

    @NotNull
    public Map<String, VariableDefinitionContext> calculateCurrentVariablesState(@NotNull PlanResultKey chainResultKey) {
        HashMap<String, VariableDefinitionContext> definitions = new HashMap<String, VariableDefinitionContext>();
        ChainResultsSummary chainResultsSummary = this.getValidChainResultSummaryByKey(chainResultKey);
        if (chainResultsSummary == null) {
            return definitions;
        }
        if (!this.isVariableDataUpToDate(chainResultsSummary)) {
            return this.legacyCurrentVariablesState(chainResultsSummary);
        }
        VariableContextBaseline variableContextBaseline = this.getVariableContextBaselineForResult(chainResultsSummary);
        if (variableContextBaseline != null) {
            definitions.putAll(VariableUtils.identifiersToContextMap((Iterable<? extends VariableDefinitionIdentifier>)variableContextBaseline.getVariables()));
        }
        definitions.putAll(VariableUtils.identifiersToContextMap(chainResultsSummary.getVariableContextLogs()));
        for (ChainStageResult chainStageResult : chainResultsSummary.getStageResults()) {
            definitions.putAll(VariableUtils.identifiersToContextMap(chainStageResult.getManualVariables()));
            if (chainStageResult.isRestartable() || chainStageResult.isRunnable()) break;
            for (BuildResultsSummary buildResultsSummary : chainStageResult.getBuildResults()) {
                if (!buildResultsSummary.isSuccessful()) continue;
                definitions.putAll(VariableUtils.identifiersToContextMap(buildResultsSummary.getResultVariables()));
            }
        }
        return definitions;
    }

    @Nullable
    public VariableContextBaseline safeGetVariableContextBaseline(@NotNull PlanResultKey chainResultKey) {
        ChainResultsSummary chainResultsSummary = this.getValidChainResultSummaryByKey(chainResultKey);
        if (chainResultsSummary == null) {
            return null;
        }
        if (!this.isVariableDataUpToDate(chainResultsSummary)) {
            throw new UnsupportedOperationException("can't get variable baseline from data created by version: " + chainResultsSummary.getFormatVersion());
        }
        return this.getVariableContextBaselineForResult(chainResultsSummary);
    }

    @NotNull
    public List<VariableDefinitionContext> getVariableStateForJobResult(BuildResultsSummary resultsSummary) {
        PlanResultKey chainResultKey = PlanKeys.getChainResultKey((PlanResultKey)resultsSummary.getPlanResultKey());
        ChainResultsSummary chainResultsSummary = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(chainResultKey, ChainResultsSummary.class);
        if (chainResultsSummary == null) {
            return new ArrayList<VariableDefinitionContext>();
        }
        if (!this.isVariableDataUpToDate(chainResultsSummary)) {
            return resultsSummary.getSubstitutedVariables().stream().map(v -> new VariableDefinitionContextImpl(v.getKey(), v.getValue(), v.getVariableType())).collect(Collectors.toList());
        }
        HashMap<String, VariableDefinitionContext> definitions = new HashMap<String, VariableDefinitionContext>();
        VariableContextBaseline variableContextBaseline = this.getVariableContextBaselineForResult(chainResultsSummary);
        if (variableContextBaseline != null) {
            definitions.putAll(VariableUtils.identifiersToContextMap((Iterable<? extends VariableDefinitionIdentifier>)variableContextBaseline.getVariables()));
        }
        definitions.putAll(VariableUtils.identifiersToContextMap(chainResultsSummary.getVariableContextLogs()));
        for (ChainStageResult chainStageResult : chainResultsSummary.getStageResults()) {
            definitions.putAll(VariableUtils.identifiersToContextMap(chainStageResult.getManualVariables()));
            if (chainStageResult.getBuildResults().contains(resultsSummary)) break;
            for (BuildResultsSummary buildResultsSummary : chainStageResult.getBuildResults()) {
                if (!buildResultsSummary.isSuccessful()) continue;
                definitions.putAll(VariableUtils.identifiersToContextMap(buildResultsSummary.getResultVariables()));
            }
        }
        definitions.putAll(VariableUtils.identifiersToContextMap(resultsSummary.getResultVariables()));
        return definitions.values().stream().map(v -> new VariableDefinitionContextImpl(v.getKey(), v.getValue(), v.getVariableType())).collect(Collectors.toList());
    }
}

