/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.vcs;

import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="REPOSITORY_CHANGESET")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class RepositoryChangesetImpl
extends BambooEntityObject
implements RepositoryChangeset {
    private static final Logger log = Logger.getLogger(RepositoryChangesetImpl.class);
    private RepositoryDataEntity repositoryData;
    private ResultsSummary resultsSummary;
    private String changesetId;
    private long skippedCommitsCount;
    private Set<Commit> commits;
    private int position;
    private boolean buildTrigger;

    public RepositoryChangesetImpl() {
    }

    public RepositoryChangesetImpl(@NotNull RepositoryDataEntity repositoryData, @NotNull ResultsSummary resultsSummary, @Nullable String changesetId, long skippedCommitsCount, int position, boolean buildTrigger) {
        this.repositoryData = repositoryData;
        this.resultsSummary = resultsSummary;
        this.changesetId = changesetId;
        this.skippedCommitsCount = skippedCommitsCount;
        this.commits = new HashSet<Commit>();
        this.position = position;
        this.buildTrigger = buildTrigger;
    }

    @NotNull
    public RepositoryDataEntity getRepositoryData() {
        return this.repositoryData;
    }

    @NotNull
    public ResultsSummary getResultsSummary() {
        return this.resultsSummary;
    }

    @Nullable
    public String getChangesetId() {
        return this.changesetId;
    }

    public long getSkippedCommitsCount() {
        return this.skippedCommitsCount;
    }

    @NotNull
    public Set<Commit> getCommits() {
        return this.commits;
    }

    public void setChangesetId(@Nullable String changesetId) {
        this.changesetId = changesetId;
    }

    public void setSkippedCommitsCount(long skippedCommitsCount) {
        this.skippedCommitsCount = skippedCommitsCount;
    }

    public void setCommits(@NotNull Set<Commit> commits) {
        this.commits = commits;
    }

    public void setRepositoryData(@NotNull RepositoryDataEntity repositoryData) {
        this.repositoryData = repositoryData;
    }

    public void setResultsSummary(@NotNull ResultsSummary resultsSummary) {
        this.resultsSummary = resultsSummary;
    }

    public boolean isBuildTrigger() {
        return this.buildTrigger;
    }

    public void setBuildTrigger(boolean buildTrigger) {
        this.buildTrigger = buildTrigger;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }
}

