/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.warning;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.results.warning.BuildWarningSummary;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummary;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummaryDao;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummaryImpl;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummaryManager;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class BuildResultWarningSummaryManagerImpl
implements BuildResultWarningSummaryManager {
    private final BuildResultWarningSummaryDao warningSummaryDao;

    public BuildResultWarningSummaryManagerImpl(BuildResultWarningSummaryDao warningSummaryDao) {
        this.warningSummaryDao = warningSummaryDao;
    }

    public void createBuildWarningSummary(ResultsSummary resultsSummary, long repositoryId, long highPriorityCount, long normalPriorityCount, long lowPriorityCount) {
        BuildResultWarningSummaryImpl warning = new BuildResultWarningSummaryImpl((ImmutableResultsSummary)resultsSummary, repositoryId, highPriorityCount, normalPriorityCount, lowPriorityCount);
        this.warningSummaryDao.save((BambooObject)warning);
    }

    @NotNull
    public Collection<BuildWarningSummary> findByResultSummary(long resultSummaryId) {
        return this.warningSummaryDao.findByResult(resultSummaryId).stream().map(this::convertToWarningSummary).collect(Collectors.toList());
    }

    @NotNull
    private BuildWarningSummary convertToWarningSummary(@NotNull BuildResultWarningSummary warning) {
        return new BuildWarningSummary(warning.getRepositoryId(), warning.getHighPriorityCount(), warning.getNormalPriorityCount(), warning.getLowPriorityCount());
    }
}

