/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.schedule;

import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import io.atlassian.util.concurrent.Lazy;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AtlassianSchedulerServiceImpl
implements SchedulerService {
    private final Supplier<SchedulerService> schedulerServiceSupplier = Lazy.supplier(() -> (SchedulerService)ComponentAccessor.newOsgiServiceProxy(SchedulerService.class).get());

    private SchedulerService getSchedulerService() {
        return this.schedulerServiceSupplier.get();
    }

    public void registerJobRunner(@NotNull JobRunnerKey jobRunnerKey, @NotNull JobRunner jobRunner) {
        this.getSchedulerService().registerJobRunner(jobRunnerKey, jobRunner);
    }

    public void unregisterJobRunner(@NotNull JobRunnerKey jobRunnerKey) {
        this.getSchedulerService().unregisterJobRunner(jobRunnerKey);
    }

    @NotNull
    public Set<JobRunnerKey> getRegisteredJobRunnerKeys() {
        return this.getSchedulerService().getRegisteredJobRunnerKeys();
    }

    @NotNull
    public Set<JobRunnerKey> getJobRunnerKeysForAllScheduledJobs() {
        return this.getSchedulerService().getJobRunnerKeysForAllScheduledJobs();
    }

    public void scheduleJob(@NotNull JobId jobId, @NotNull JobConfig jobConfig) throws SchedulerServiceException {
        this.getSchedulerService().scheduleJob(jobId, jobConfig);
    }

    @NotNull
    public JobId scheduleJobWithGeneratedId(@NotNull JobConfig jobConfig) throws SchedulerServiceException {
        return this.getSchedulerService().scheduleJobWithGeneratedId(jobConfig);
    }

    public void unscheduleJob(@NotNull JobId jobId) {
        this.getSchedulerService().unscheduleJob(jobId);
    }

    @Nullable
    public Date calculateNextRunTime(@NotNull Schedule schedule) throws SchedulerServiceException {
        return this.getSchedulerService().calculateNextRunTime(schedule);
    }

    @Nullable
    public JobDetails getJobDetails(@NotNull JobId jobId) {
        return this.getSchedulerService().getJobDetails(jobId);
    }

    @NotNull
    public List<JobDetails> getJobsByJobRunnerKey(@NotNull JobRunnerKey jobRunnerKey) {
        return this.getSchedulerService().getJobsByJobRunnerKey(jobRunnerKey);
    }
}

