/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.schedule;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.TriggerableInternalKeyImpl;
import com.atlassian.bamboo.plan.branch.ImmutableChainPropagatingFacade;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.schedule.PlanScheduler;
import com.atlassian.bamboo.schedule.PlanSchedulerCallback;
import com.atlassian.bamboo.schedule.TriggerableSchedulerCallback;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.trigger.TriggerActivatorHelper;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.util.Narrow;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DefaultPlanScheduler
implements PlanScheduler {
    private static final Logger log = Logger.getLogger(DefaultPlanScheduler.class);
    private final Function<String, ManagedLock> lockManager = ManagedLocks.weakManagedLockFactory();
    private final TriggerTypeManager triggerTypeManager;

    public DefaultPlanScheduler(TriggerTypeManager triggerTypeManager) {
        this.triggerTypeManager = triggerTypeManager;
    }

    public void removeTasksScheduledForTriggerable(@NotNull Triggerable triggerable) {
        this.lockManager.apply(new TriggerableInternalKeyImpl(triggerable).getKey()).withLock(() -> TriggerActivatorHelper.deactivateTriggers(this.triggerTypeManager, triggerable, log));
    }

    public void removeTasksScheduledForPlan(@NotNull ImmutablePlan plan) {
        if (plan instanceof Triggerable) {
            this.removeTasksScheduledForTriggerable((Triggerable)plan);
        }
    }

    public void scheduleTasksForTriggerable(@NotNull Triggerable triggerable) {
        boolean markedForDeletion;
        boolean bl = markedForDeletion = triggerable instanceof ImmutableChain && ((ImmutableChain)triggerable).isMarkedForDeletion();
        if (triggerable.isSuspended() || markedForDeletion) {
            return;
        }
        this.lockManager.apply(new TriggerableInternalKeyImpl(triggerable).getKey()).withLock(() -> TriggerActivatorHelper.activateTriggers(this.triggerTypeManager, triggerable, log));
    }

    public void scheduleTasksForPlan(@NotNull ImmutablePlan plan) {
        if (plan instanceof Triggerable) {
            this.scheduleTasksForTriggerable((Triggerable)plan);
        }
    }

    public void removeTasksScheduledForPlanAndBranches(@NotNull ImmutablePlan plan) {
        ImmutableChain chain = (ImmutableChain)Narrow.downTo((Object)plan, ImmutableChain.class);
        if (chain != null) {
            CachedPlanManager cachedPlanManager = (CachedPlanManager)ComponentAccessor.CACHED_PLAN_MANAGER.get();
            this.lockManager.apply(new TriggerableInternalKeyImpl((Triggerable)chain).getKey()).withLock(() -> new ImmutableChainPropagatingFacade(cachedPlanManager, chain).removeSchedulingJobs(this));
        }
    }

    public void scheduleTasksForPlanAndBranches(@NotNull ImmutablePlan plan) {
        final ImmutableChain chain = (ImmutableChain)Narrow.downTo((Object)plan, ImmutableChain.class);
        if (chain != null) {
            this.lockManager.apply(new TriggerableInternalKeyImpl((Triggerable)chain).getKey()).withLock(new Runnable(){

                @Override
                public void run() {
                    new ImmutableChainPropagatingFacade((CachedPlanManager)ComponentAccessor.CACHED_PLAN_MANAGER.get(), chain).createSchedulingJobs(DefaultPlanScheduler.this);
                }
            });
        }
    }

    public void executeWithoutPlanSchedules(final @NotNull PlanSchedulerCallback planSchedulerCallback) {
        final Plan plan = planSchedulerCallback.getPlan();
        if (plan instanceof Triggerable) {
            this.lockManager.apply(new TriggerableInternalKeyImpl((Triggerable)plan).getKey()).withLock(new Runnable(){

                @Override
                public void run() {
                    DefaultPlanScheduler.this.removeTasksScheduledForPlanAndBranches((ImmutablePlan)plan);
                    try {
                        planSchedulerCallback.run();
                    }
                    finally {
                        DefaultPlanScheduler.this.scheduleTasksForPlanAndBranches((ImmutablePlan)plan);
                    }
                }
            });
        } else {
            planSchedulerCallback.run();
        }
    }

    public void executeWithoutSchedules(final @NotNull TriggerableSchedulerCallback callback) {
        final Triggerable triggerable = callback.getTriggerable();
        if (triggerable instanceof Plan) {
            this.executeWithoutPlanSchedules(new PlanSchedulerCallback((Plan)triggerable){

                protected void run(Plan plan) {
                    callback.run();
                }
            });
        } else {
            this.lockManager.apply(new TriggerableInternalKeyImpl(triggerable).getKey()).withLock(new Runnable(){

                @Override
                public void run() {
                    DefaultPlanScheduler.this.removeTasksScheduledForTriggerable(triggerable);
                    try {
                        callback.run();
                    }
                    finally {
                        DefaultPlanScheduler.this.scheduleTasksForTriggerable(triggerable);
                    }
                }
            });
        }
    }

    public void removeAllScheduledJobs(@NotNull Triggerable triggerable) {
        if (triggerable instanceof Plan) {
            this.removeTasksScheduledForPlanAndBranches((ImmutablePlan)((Plan)triggerable));
        } else {
            this.removeTasksScheduledForTriggerable(triggerable);
        }
    }

    public void scheduleTriggeringJobs(@NotNull Triggerable triggerable) {
        if (triggerable instanceof Plan) {
            this.scheduleTasksForPlanAndBranches((ImmutablePlan)((Plan)triggerable));
        } else {
            this.scheduleTasksForTriggerable(triggerable);
        }
    }
}

