/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.event.TrustedKeyRemovedEvent;
import com.atlassian.bamboo.event.TrustedKeySavedEvent;
import com.atlassian.bamboo.security.TrustedKey;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.config.HomeLocator;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTrustedKeyHelper
implements TrustedKeyHelper {
    private static final Logger log = Logger.getLogger(AbstractTrustedKeyHelper.class);
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final HomeLocator homeLocator;
    private final EventPublisher eventPublisher;
    protected ResettableLazyReference<File> fileSupplier = new ResettableLazyReference<File>(){

        protected File create() throws Exception {
            Collection trustedKeys = AbstractTrustedKeyHelper.this.getTrustedKeys();
            List keys = trustedKeys.stream().filter(TrustedKey::isApproved).map(TrustedKeyHelper.KNOWN_HOSTS_FUNCTION).collect(Collectors.toList());
            Path file = Paths.get(AbstractTrustedKeyHelper.this.homeLocator.getHomePath(), "temp", "trusted.hosts");
            if (!file.getParent().toFile().exists()) {
                BambooFileUtils.createDirectoryIfNotExists(file.getParent().toFile());
            }
            Files.write(file, keys, StandardCharsets.UTF_8, new OpenOption[0]);
            return file.toFile();
        }
    };

    public AbstractTrustedKeyHelper(AdministrationConfigurationAccessor administrationConfigurationAccessor, HomeLocator homeLocator, EventPublisher eventPublisher) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.homeLocator = homeLocator;
        this.eventPublisher = eventPublisher;
    }

    @PostConstruct
    private void registerListener() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    private void unregisterListener() {
        this.eventPublisher.unregister((Object)this);
    }

    public boolean isCustomAcceptedSshHostKeysEnabled() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().isManageAcceptedSshHostKeys();
    }

    @NotNull
    public File getCustomAcceptedSshHostKeysFile() {
        return (File)this.fileSupplier.get();
    }

    @EventListener
    public void onTrustedKeyRemoved(TrustedKeyRemovedEvent event) {
        log.debug((Object)"Trusted key was removed, refresh list");
        this.fileSupplier.reset();
    }

    @EventListener
    public void onTrustedKeySaved(TrustedKeySavedEvent event) {
        log.debug((Object)"Trusted key was updated, refresh list");
        this.fileSupplier.reset();
    }
}

