/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.accesstoken.AccessToken;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessTokenContextHolder {
    private static ThreadLocal<AccessTokenContext> authTokenContextThreadLocal = new ThreadLocal();

    public static void setContext(@Nullable AccessTokenContext authTokenContext) {
        authTokenContextThreadLocal.set(authTokenContext);
    }

    @Nullable
    public static AccessTokenContext getContext() {
        return authTokenContextThreadLocal.get();
    }

    @NotNull
    public static Optional<AccessToken> getAccessToken() {
        return Optional.ofNullable(authTokenContextThreadLocal.get()).map(tx -> {
            Preconditions.checkState((tx.getAccessToken() != null ? 1 : 0) != 0, (Object)"Access token is null");
            return tx.getAccessToken();
        });
    }

    public static void clearContext() {
        authTokenContextThreadLocal.remove();
    }

    public static class AccessTokenContext {
        private final AccessToken accessToken;

        public AccessTokenContext(@NotNull AccessToken accessToken) {
            this.accessToken = accessToken;
        }

        @NotNull
        public AccessToken getAccessToken() {
            return this.accessToken;
        }
    }
}

