/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.security.BambooCachingPermissionManagerFacade;
import com.atlassian.bamboo.security.BambooPermissionManagerImpl;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.CachingSidRetrievalStrategy;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.util.BambooIterables;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.stream.Collector;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAclService;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.objectidentity.ObjectIdentityRetrievalStrategy;
import org.acegisecurity.acls.sid.SidRetrievalStrategy;
import org.jetbrains.annotations.NotNull;

public class BambooCachingPermissionManagerFacadeImpl
implements BambooCachingPermissionManagerFacade {
    private final BambooCachingPermissionManager cachingPermissionManager = new BambooCachingPermissionManager();
    private final CachedPlanManager cachedPlanManager;

    public BambooCachingPermissionManagerFacadeImpl(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public boolean hasPlanPermission(BambooPermission permission, long planId) {
        ImmutablePlan planIdentifier = this.cachedPlanManager.getPlanById(planId, ImmutableChain.class);
        Preconditions.checkNotNull((Object)planIdentifier, (Object)("Unknown plan id " + planId));
        return this.hasPermission((Permission)permission, planIdentifier);
    }

    public boolean hasPlanPermission(BambooPermission permission, PlanKey planKey) {
        ImmutablePlan planIdentifier = this.cachedPlanManager.getPlanByKey(planKey, ImmutableChain.class);
        Preconditions.checkNotNull((Object)planIdentifier, (Object)("Unknown plan " + planKey));
        return this.hasPermission((Permission)permission, planIdentifier);
    }

    public boolean hasPermission(Permission permission, @NotNull Object plan) {
        return this.cachingPermissionManager.hasPermission(permission, plan, null);
    }

    public void primeAclCache(@NotNull Iterable<?> objects) {
        this.cachingPermissionManager.primeAclCache(objects);
    }

    public <T, A, R extends Iterable<?>> Collector<T, A, R> aclCachePrimerCollector(Collector<T, A, R> collector) {
        return Collector.of(collector.supplier(), collector.accumulator(), collector.combiner(), collector.finisher().andThen(result -> {
            this.primeAclCache((Iterable<?>)result);
            return result;
        }), collector.characteristics().toArray(new Collector.Characteristics[0]));
    }

    public void setSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
        this.cachingPermissionManager.setSidRetrievalStrategy(sidRetrievalStrategy);
    }

    public void setAclService(MutableAclService aclService) {
        this.cachingPermissionManager.setAclService(aclService);
    }

    public void setObjectIdentityRetrievalStrategy(ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy) {
        this.cachingPermissionManager.setObjectIdentityRetrievalStrategy(objectIdentityRetrievalStrategy);
    }

    public void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.cachingPermissionManager.setBambooUserManager(bambooUserManager);
    }

    public void setOverrideAuthorities(GrantedAuthority[] overrideAuthorities) {
        this.cachingPermissionManager.setOverrideAuthorities(overrideAuthorities);
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachingPermissionManager.setCachedPlanManager(cachedPlanManager);
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.cachingPermissionManager.setProjectManager(projectManager);
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.cachingPermissionManager.setAdministrationConfigurationAccessor(administrationConfigurationAccessor);
    }

    private class BambooCachingPermissionManager
    extends BambooPermissionManagerImpl {
        private final LoadingCache<ObjectIdentity, Acl> aclCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<ObjectIdentity, Acl>(){

            public Acl load(@NotNull ObjectIdentity objectIdentity) {
                return BambooCachingPermissionManager.super.readAclById(objectIdentity);
            }
        });

        private BambooCachingPermissionManager() {
        }

        @Override
        protected Acl readAclById(ObjectIdentity identity) {
            return (Acl)this.aclCache.getUnchecked((Object)identity);
        }

        public void primeAclCache(@NotNull Iterable<?> objects) {
            ObjectIdentity[] identities = (ObjectIdentity[])BambooIterables.stream(objects).map(BambooCachingPermissionManagerFacadeImpl.this.cachingPermissionManager::createObjectIdentity).toArray(ObjectIdentity[]::new);
            Map objectIdentity2acl = this.aclService.readAclsById(identities);
            this.aclCache.putAll(objectIdentity2acl);
        }

        @Override
        public void setSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
            super.setSidRetrievalStrategy(new CachingSidRetrievalStrategy(sidRetrievalStrategy));
        }
    }
}

