/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.accesstoken.AccessToken;
import com.atlassian.bamboo.accesstoken.AccessTokenPermission;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.project.ProjectPlanPermissions;
import com.atlassian.bamboo.security.AccessTokenContextHolder;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.security.acegi.BambooAcegiSecurityUtils;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.GroupPrincipalSid;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.user.Authority;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAclService;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.objectidentity.ObjectIdentityRetrievalStrategy;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.acls.sid.SidRetrievalStrategy;
import org.acegisecurity.adapters.PrincipalAcegiUserToken;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.userdetails.UserDetails;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooPermissionManagerImpl
implements BambooPermissionManager {
    private static final BambooLogger log = BambooLogger.getLogger(BambooPermissionManagerImpl.class);
    protected MutableAclService aclService;
    private SidRetrievalStrategy sidRetrievalStrategy;
    private ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy;
    private CachedPlanManager cachedPlanManager;
    private ProjectManager projectManager;
    private GrantedAuthority[] overrideAuthorities = new GrantedAuthority[0];
    @Inject
    private BambooUserManager bambooUserManager;
    @Inject
    private FeatureManager featureManager;
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;

    public boolean hasPermission(@NotNull Permission permission, @NotNull Object object, @Nullable Authentication authentication) {
        boolean result;
        ObjectIdentity identity;
        HibernateObjectIdentityImpl hibernateObjectIdentity;
        String permissionName = (permission instanceof BambooPermission ? ((BambooPermission)permission).getName() : permission).toString();
        log.trace("Checking permission %s for object %s", new Object[]{permissionName, object});
        if (authentication == null) {
            authentication = SecurityContextHolder.getContext().getAuthentication();
        }
        if (authentication == null) {
            log.debug("Authentication not found, permission %s is not granted for object %s", new Object[]{permissionName, object});
            return false;
        }
        if (this.isPermissionSuppressedByTokenAuthorisation(permission)) {
            log.debug("Permission %s is not granted as authentication method (token %s) does not allow it", new Object[]{permissionName, this.getTokenNameFromContext()});
            return false;
        }
        Object principal = authentication.getPrincipal();
        log.trace("Identified principal %s (type: %s)", new Object[]{principal.toString(), principal.getClass()});
        if (this.isOverrideAuthority(authentication)) {
            log.debug("Authority overridden, permission %s granted for object %s", new Object[]{permissionName, object});
            return true;
        }
        if (BambooAcegiSecurityUtils.hasAuthority(authentication, Authority.RESTRICTED_ADMIN) && (BambooPermission.isGlobalPermissionGrantedForRestrictedAdmin((Permission)permission) || !(object instanceof GlobalApplicationSecureObject))) {
            log.debug("User is an admin, permission %s granted for object %s", new Object[]{permissionName, object});
            return true;
        }
        if (object instanceof PlanIdentifier) {
            ProjectIdentifier projectIdentifier = ((PlanIdentifier)object).getProject();
            if (!this.hasPermission((Permission)BambooPermission.READ, projectIdentifier, authentication)) {
                return false;
            }
            if (this.hasPermission(permission, new ProjectPlanPermissions(projectIdentifier), authentication)) {
                return true;
            }
        }
        if ((hibernateObjectIdentity = (HibernateObjectIdentityImpl)Narrow.to((Object)(identity = this.createObjectIdentity(object)), HibernateObjectIdentityImpl.class)) != null) {
            log.trace("Checking permission %s for hibernate identity: %s", new Object[]{permissionName, identity});
            result = this.hasPermission(permission, hibernateObjectIdentity, authentication);
        } else {
            log.trace("Checking permission %s for identity: %s", new Object[]{permissionName, identity});
            result = this.hasPermission(permission, identity, authentication);
        }
        log.debug("Permissions %s %s on identity %s", new Object[]{permissionName, result ? "granted" : "not granted", identity});
        return result;
    }

    private String getTokenNameFromContext() {
        return AccessTokenContextHolder.getContext().getAccessToken().getName();
    }

    @VisibleForTesting
    protected boolean isPermissionSuppressedByTokenAuthorisation(@NotNull Permission permission) {
        Optional<AccessToken> accessTokenOptional = AccessTokenContextHolder.getAccessToken();
        if (!accessTokenOptional.isPresent()) {
            return false;
        }
        AccessToken token = accessTokenOptional.get();
        Set permissions = token.getPermissions();
        int permissionMask = 0;
        permissionMask = permissions.contains(AccessTokenPermission.USER) ? -1 : (permissions.contains(AccessTokenPermission.TRIGGER) ? this.getBuildPermissionMask() : BambooPermission.READ.getMask());
        return (permission.getMask() & permissionMask) != permission.getMask();
    }

    private int getBuildPermissionMask() {
        return BambooPermission.READ.getMask() | BambooPermission.BUILD.getMask() | BambooPermission.SOX_COMPLIANCE.getMask();
    }

    public Predicate<Object> hasPermission(@NotNull BambooPermission permission, @Nullable Authentication authentication) {
        return object -> object != null && this.hasPermission((Permission)permission, object, authentication);
    }

    public boolean hasPermissionForAuthority(@NotNull Permission permission, @NotNull Object object, @NotNull GrantedAuthority authority) {
        Acl acl = this.getAcl(object);
        GrantedAuthoritySid grantedAuthoritySid = new GrantedAuthoritySid(authority);
        try {
            return acl.isGranted(new Permission[]{permission}, new Sid[]{grantedAuthoritySid}, false);
        }
        catch (NotFoundException nfe) {
            return false;
        }
    }

    public Acl getAcl(@NotNull Object object) {
        ObjectIdentity identity = this.createObjectIdentity(object);
        return this.readAclById(identity);
    }

    protected Acl readAclById(ObjectIdentity identity) {
        return this.aclService.readAclById(identity);
    }

    public boolean hasPermission(@NotNull String username, @NotNull Permission permission, @NotNull Object object) {
        BambooUser userDetails = this.bambooUserManager.loadUserByUsername(username);
        return userDetails != null && this.hasPermission((UserDetails)userDetails, permission, object);
    }

    private boolean hasPermission(@NotNull UserDetails userDetails, @NotNull Permission permission, @NotNull Object object) {
        PrincipalAcegiUserToken auth = new PrincipalAcegiUserToken("USER_TOKEN_KEY", userDetails.getUsername(), userDetails.getPassword(), userDetails.getAuthorities(), (Object)userDetails);
        return this.hasPermission(permission, object, (Authentication)auth);
    }

    public boolean hasPlanPermission(@NotNull Permission permission, @NotNull PlanKey planKey) {
        ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(planKey);
        return plan != null && this.hasPermission(permission, plan, null);
    }

    public boolean hasPlanPermission(@NotNull Permission permission, @NotNull ImmutablePlan plan) {
        return this.hasPermission(permission, plan, null);
    }

    public boolean hasProjectPermission(@NotNull Permission permission, @NotNull String projectKey) {
        return Optional.ofNullable(this.projectManager.getProjectByKey(projectKey)).map(project -> this.hasProjectPermission(permission, (Project)project)).orElse(false);
    }

    public boolean hasProjectPermission(@NotNull Permission permission, @NotNull Project project) {
        return this.hasPermission(permission, project, null);
    }

    public boolean canCreatePlanInProject(@NotNull String projectKey) {
        return Optional.ofNullable(this.projectManager.getProjectByKey(projectKey)).map(this::canCreatePlanInProject).orElse(false);
    }

    public boolean canCreatePlanInProject(@NotNull Project project) {
        return this.hasGlobalPermission((Permission)BambooPermission.CREATE) || this.hasProjectPermission((Permission)BambooPermission.CREATE, project);
    }

    public boolean canCreateProject() {
        return this.hasGlobalPermission((Permission)BambooPermission.CREATE);
    }

    public boolean canCreatePlan() {
        return this.hasGlobalPermission((Permission)BambooPermission.CREATE) || this.projectManager.getAllProjects().stream().anyMatch(project -> this.hasProjectPermission((Permission)BambooPermission.CREATE, (Project)project));
    }

    public boolean canCreateDeploymentProject() {
        return this.hasGlobalPermission((Permission)BambooPermission.CREATE) || this.featureManager.isCreateDeploymentGrantedByProjects() && this.canCreatePlan();
    }

    public boolean hasGlobalPermission(@NotNull Permission permission) {
        return this.hasPermission(permission, GlobalApplicationSecureObject.INSTANCE, null);
    }

    public Collection<Permission> getPermissionsForPlan(@NotNull PlanKey planKey) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(planKey);
        if (plan != null) {
            for (Permission permission : BambooPermission.getPlanPermissionsList()) {
                if (!this.hasPermission(permission, plan, null)) continue;
                permissions.add(permission);
            }
        }
        return permissions;
    }

    public boolean hasProjectEditPermission(@Nullable Project project) {
        return project != null ? this.hasPermission((Permission)BambooPermission.ADMINISTRATION, project, null) : false;
    }

    public boolean isEnableSignup() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().isEnableSignup();
    }

    @NotNull
    public Collection<String> getAdminGroups() {
        return this.getGroupsWithPermission(BambooPermission.ADMINISTRATION);
    }

    @NotNull
    public Collection<String> getRestrictedAdminGroups() {
        return this.getGroupsWithPermission(BambooPermission.RESTRICTEDADMINISTRATION);
    }

    @NotNull
    public Collection<String> getUsePermissionGroups() {
        return this.getGroupsWithPermission(BambooPermission.READ);
    }

    @NotNull
    public String getDefaultUsersGroup() {
        return "bamboo-user";
    }

    @NotNull
    public Collection<String> getGroupsWithPermission(BambooPermission permission) {
        ArrayList<String> groups = new ArrayList<String>();
        Acl acl = this.readAclById(new HibernateObjectIdentityImpl(GlobalApplicationSecureObject.INSTANCE));
        for (AccessControlEntry entry : acl.getEntries()) {
            if (!entry.getPermission().equals(permission) || !(entry.getSid() instanceof GroupPrincipalSid)) continue;
            GroupPrincipalSid sid = (GroupPrincipalSid)entry.getSid();
            groups.add(sid.getPrincipal());
        }
        return groups;
    }

    @NotNull
    public Collection<String> getAdminUsers() {
        return this.getUsersWithPermission(BambooPermission.ADMINISTRATION);
    }

    @NotNull
    public Collection<String> getRestrictedAdminUsers() {
        return this.getUsersWithPermission(BambooPermission.RESTRICTEDADMINISTRATION);
    }

    @NotNull
    public Collection<String> getUsePermissionUsers() {
        return this.getUsersWithPermission(BambooPermission.READ);
    }

    @NotNull
    public Collection<String> getUsersWithPermission(BambooPermission permission) {
        ArrayList<String> users = new ArrayList<String>();
        Acl acl = this.readAclById(new HibernateObjectIdentityImpl(GlobalApplicationSecureObject.INSTANCE));
        for (AccessControlEntry entry : acl.getEntries()) {
            if (!entry.getPermission().equals(permission) || !(entry.getSid() instanceof PrincipalSid)) continue;
            PrincipalSid sid = (PrincipalSid)entry.getSid();
            users.add(sid.getPrincipal());
        }
        return users;
    }

    public boolean isAdmin(String username) {
        BambooUser userDetails = this.bambooUserManager.loadUserByUsername(username);
        if (userDetails != null) {
            return this.hasPermission((UserDetails)userDetails, (Permission)BambooPermission.ADMINISTRATION, (Object)GlobalApplicationSecureObject.INSTANCE) || this.hasPermission((UserDetails)userDetails, (Permission)BambooPermission.RESTRICTEDADMINISTRATION, (Object)GlobalApplicationSecureObject.INSTANCE);
        }
        return false;
    }

    public boolean isSystemAdmin(String username) {
        BambooUser userDetails = this.bambooUserManager.loadUserByUsername(username);
        return userDetails != null && this.hasPermission((UserDetails)userDetails, (Permission)BambooPermission.ADMINISTRATION, (Object)GlobalApplicationSecureObject.INSTANCE);
    }

    public boolean isAllowedToSetGlobalPermission(@NotNull Permission permission) {
        boolean isSystemAdmin = this.hasGlobalPermission((Permission)BambooPermission.ADMINISTRATION);
        boolean isAdmin = this.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION);
        if (permission.equals(BambooPermission.ADMINISTRATION)) {
            return isSystemAdmin;
        }
        return isSystemAdmin || isAdmin;
    }

    public boolean canManageElasticBamboo() {
        return this.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION);
    }

    public boolean canManageAgents() {
        return this.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION);
    }

    public boolean canRunCustomBuild(@NotNull PlanKey planKey) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (this.administrationConfigurationAccessor.getAdministrationConfiguration().isSoxComplianceModeEnabled() && BambooAcegiSecurityUtils.hasAuthority(authentication, Authority.SOX_COMPLIANT_USER)) {
            return this.hasPermission((Permission)BambooPermission.ADMINISTRATION, GlobalApplicationSecureObject.INSTANCE, authentication) || this.hasPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION, GlobalApplicationSecureObject.INSTANCE, authentication) || this.hasPlanPermission((Permission)BambooPermission.ADMINISTRATION, planKey);
        }
        return this.hasPlanPermission((Permission)BambooPermission.BUILD, planKey);
    }

    protected boolean hasPermission(@NotNull Permission permission, @NotNull HibernateObjectIdentityImpl objectIdentity, @NotNull Authentication authentication) {
        boolean isGranted = this.hasPermission(permission, (ObjectIdentity)objectIdentity, authentication);
        HibernateObjectIdentityImpl ancestorIdentity = objectIdentity.getAncestorIdentity();
        if (ancestorIdentity != null) {
            switch (objectIdentity.getAncestorPermissionCheckPolicy(permission)) {
                case AND: {
                    isGranted = isGranted && this.hasPermission(permission, ancestorIdentity, authentication);
                    break;
                }
                case OR: {
                    isGranted = isGranted || this.hasPermission(permission, ancestorIdentity, authentication);
                }
            }
        }
        return isGranted;
    }

    protected boolean hasPermission(@NotNull Permission permission, @NotNull ObjectIdentity objectIdentity, @NotNull Authentication authentication) {
        try {
            Acl acl = this.readAclById(objectIdentity);
            Sid[] sids = this.sidRetrievalStrategy.getSids(authentication);
            return acl.isGranted(new Permission[]{permission}, sids, false);
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    protected ObjectIdentity createObjectIdentity(@NotNull Object object) {
        return this.objectIdentityRetrievalStrategy.getObjectIdentity(object);
    }

    private boolean isOverrideAuthority(@NotNull Authentication authentication) {
        for (GrantedAuthority grantedAuthority : authentication.getAuthorities()) {
            for (GrantedAuthority overrideAuthority : this.overrideAuthorities) {
                if (!overrideAuthority.getAuthority().equals(grantedAuthority.getAuthority())) continue;
                return true;
            }
        }
        return false;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public void setAclService(MutableAclService aclService) {
        this.aclService = aclService;
    }

    public void setSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
        this.sidRetrievalStrategy = sidRetrievalStrategy;
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public void setOverrideAuthorities(GrantedAuthority[] overrideAuthorities) {
        this.overrideAuthorities = overrideAuthorities;
    }

    void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }

    public void setObjectIdentityRetrievalStrategy(ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy) {
        this.objectIdentityRetrievalStrategy = objectIdentityRetrievalStrategy;
    }
}

