/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.AdministrationConfigurationPersister;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.GlobalPermissionsService;
import com.atlassian.bamboo.security.PermissionsServiceUtils;
import com.atlassian.bamboo.security.acegi.acls.BambooAclHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.user.Authority;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.Permission;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultGlobalPermissionsService
implements GlobalPermissionsService {
    private static final Multimap<BambooPermission, BambooPermission> PERMISSION_DEPENDENCIES = ImmutableMultimap.builder().put((Object)BambooPermission.SOX_COMPLIANCE, (Object)BambooPermission.READ).put((Object)BambooPermission.CREATE, (Object)BambooPermission.READ).put((Object)BambooPermission.CREATE_REPOSITORY, (Object)BambooPermission.READ).put((Object)BambooPermission.RESTRICTEDADMINISTRATION, (Object)BambooPermission.CREATE).put((Object)BambooPermission.RESTRICTEDADMINISTRATION, (Object)BambooPermission.CREATE_REPOSITORY).put((Object)BambooPermission.ADMINISTRATION, (Object)BambooPermission.RESTRICTEDADMINISTRATION).build();
    private final TransactionAndHibernateTemplate hibernateTemplate;
    private final HibernateMutableAclService aclService;
    private final BambooAclHelper aclHelper;
    private final BambooAclUpdateHelper aclUpdateHelper;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final AdministrationConfigurationPersister administrationConfigurationPersister;
    private final BambooUserManager bambooUserManager;
    private final BambooPermissionManager bambooPermissionManager;

    @Autowired
    public DefaultGlobalPermissionsService(TransactionAndHibernateTemplate hibernateTemplate, HibernateMutableAclService aclService, BambooAclHelper aclHelper, BambooAclUpdateHelper aclUpdateHelper, AdministrationConfigurationAccessor administrationConfigurationAccessor, AdministrationConfigurationPersister administrationConfigurationPersister, BambooUserManager bambooUserManager, BambooPermissionManager bambooPermissionManager) {
        this.hibernateTemplate = hibernateTemplate;
        this.aclService = aclService;
        this.aclHelper = aclHelper;
        this.aclUpdateHelper = aclUpdateHelper;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.administrationConfigurationPersister = administrationConfigurationPersister;
        this.bambooUserManager = bambooUserManager;
        this.bambooPermissionManager = bambooPermissionManager;
    }

    @NotNull
    private MutableAcl getAcl() {
        return this.aclService.getAclOfGlobalPermission();
    }

    @NotNull
    public Iterable<String> listUsersWithGlobalPermissions() {
        this.hasPermissions();
        return this.aclHelper.listUsersWithPermissions((Acl)this.getAcl(), this.supportedPermissions());
    }

    @NotNull
    public List<BambooPermission> getUserGlobalPermissions(@NotNull String username) {
        this.hasPermissions();
        return this.aclHelper.getUserPermissions((Acl)this.getAcl(), username, this.supportedPermissions());
    }

    public boolean addUserGlobalPermissions(@NotNull String username, @NotNull List<BambooPermission> permissionsToAdd) {
        return this.withExclusiveLock(() -> {
            this.validateGlobalPermissions(permissionsToAdd);
            User user = this.validateUser(username);
            this.hasPermissionsToChange(permissionsToAdd);
            this.validateDependenciesAfterGranting(this.getUserGlobalPermissions(user.getName()), permissionsToAdd);
            List<String> permissionKeysToAdd = permissionsToAdd.stream().map(permission -> BambooAclUpdateHelper.createUserPermissionKey(user.getName(), permission.getName())).collect(Collectors.toList());
            return this.addGlobalPermissionKeys(permissionKeysToAdd);
        });
    }

    public boolean removeUserGlobalPermissions(@NotNull String username, @NotNull List<BambooPermission> permissionsToRemove) {
        return this.withExclusiveLock(() -> {
            User user = this.validateUser(username);
            this.hasPermissionsToChange(permissionsToRemove);
            this.validateDependenciesAfterRevoking(this.getUserGlobalPermissions(user.getName()), permissionsToRemove);
            List<String> permissionKeysToAdd = permissionsToRemove.stream().map(permission -> BambooAclUpdateHelper.createUserPermissionKey(user.getName(), permission.getName())).collect(Collectors.toList());
            return this.removeGlobalPermissionKeys(permissionKeysToAdd);
        });
    }

    @NotNull
    public Iterable<String> listGroupsWithGlobalPermissions() {
        this.hasPermissions();
        return this.aclHelper.listGroupsWithPermissions((Acl)this.getAcl(), this.supportedPermissions());
    }

    @NotNull
    public List<BambooPermission> getGroupGlobalPermissions(@NotNull String groupName) {
        this.hasPermissions();
        return this.aclHelper.getGroupPermissions((Acl)this.getAcl(), groupName, this.supportedPermissions());
    }

    public boolean addGroupGlobalPermissions(@NotNull String groupName, @NotNull List<BambooPermission> permissionsToAdd) {
        return this.withExclusiveLock(() -> {
            this.validateGlobalPermissions(permissionsToAdd);
            Group group = this.validateGroup(groupName);
            this.hasPermissionsToChange(permissionsToAdd);
            this.validateDependenciesAfterGranting(this.getGroupGlobalPermissions(group.getName()), permissionsToAdd);
            List<String> permissionKeysToAdd = permissionsToAdd.stream().map(permission -> BambooAclUpdateHelper.createGroupPermissionKey(group.getName(), permission.getName())).collect(Collectors.toList());
            return this.addGlobalPermissionKeys(permissionKeysToAdd);
        });
    }

    public boolean removeGroupGlobalPermissions(@NotNull String groupName, @NotNull List<BambooPermission> permissionsToRemove) {
        return this.withExclusiveLock(() -> {
            Group group = this.validateGroup(groupName);
            this.hasPermissionsToChange(permissionsToRemove);
            this.validateDependenciesAfterRevoking(this.getGroupGlobalPermissions(group.getName()), permissionsToRemove);
            List<String> permissionKeysToRemove = permissionsToRemove.stream().map(permission -> BambooAclUpdateHelper.createGroupPermissionKey(group.getName(), permission.getName())).collect(Collectors.toList());
            return this.removeGlobalPermissionKeys(permissionKeysToRemove);
        });
    }

    @NotNull
    public List<BambooPermission> getLoggedInGlobalPermissions() {
        this.hasPermissions();
        return this.aclHelper.getLoggedInPermissions((Acl)this.getAcl(), this.supportedPermissions());
    }

    public boolean addLoggedInGlobalPermissions(@NotNull List<BambooPermission> permissionsToAdd) {
        return this.withExclusiveLock(() -> {
            this.validateGlobalPermissions(permissionsToAdd);
            this.hasPermissionsToChange(permissionsToAdd);
            this.validateDependenciesAfterGranting(this.getLoggedInGlobalPermissions(), permissionsToAdd);
            List<String> permissionKeysToAdd = permissionsToAdd.stream().map(permission -> BambooAclUpdateHelper.createRolePermissionKey(Authority.USER.getAuthority(), permission.getName())).collect(Collectors.toList());
            return this.addGlobalPermissionKeys(permissionKeysToAdd);
        });
    }

    public boolean removeLoggedInGlobalPermissions(@NotNull List<BambooPermission> permissionsToRemove) {
        return this.withExclusiveLock(() -> {
            this.hasPermissionsToChange(permissionsToRemove);
            this.validateDependenciesAfterRevoking(this.getLoggedInGlobalPermissions(), permissionsToRemove);
            List<String> permissionKeysToRemove = permissionsToRemove.stream().map(permission -> BambooAclUpdateHelper.createRolePermissionKey(Authority.USER.getAuthority(), permission.getName())).collect(Collectors.toList());
            return this.removeGlobalPermissionKeys(permissionKeysToRemove);
        });
    }

    @NotNull
    public List<BambooPermission> getAnonymousGlobalPermissions() {
        this.hasPermissions();
        return this.aclHelper.getAnonymousPermissions((Acl)this.getAcl(), this.supportedPermissions());
    }

    public boolean addAnonymousGlobalPermissions() {
        return this.withExclusiveLock(() -> {
            this.hasPermissionsToChange(Collections.singletonList(BambooPermission.READ));
            AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
            administrationConfiguration.setEnableAnonymousAccess(true);
            this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
            return this.addGlobalPermissionKeys(Collections.singletonList(BambooAclUpdateHelper.createRolePermissionKey(Authority.ANONYMOUS.getAuthority(), BambooPermission.READ.getName())));
        });
    }

    public boolean removeAnonymousGlobalPermissions() {
        return this.withExclusiveLock(() -> {
            this.hasPermissionsToChange(Collections.singletonList(BambooPermission.READ));
            AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
            administrationConfiguration.setEnableAnonymousAccess(false);
            this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
            return this.removeGlobalPermissionKeys(Collections.singletonList(BambooAclUpdateHelper.createRolePermissionKey(Authority.ANONYMOUS.getAuthority(), BambooPermission.READ.getName())));
        });
    }

    @NotNull
    public Collection<BambooPermission> supportedPermissions() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        result.add((Object[])new BambooPermission[]{BambooPermission.READ, BambooPermission.CREATE, BambooPermission.CREATE_REPOSITORY, BambooPermission.ADMINISTRATION});
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        if (administrationConfiguration.isSoxComplianceModeEnabled()) {
            result.add((Object)BambooPermission.SOX_COMPLIANCE);
        }
        if (administrationConfiguration.isEnableRestrictedAdmin()) {
            result.add((Object)BambooPermission.RESTRICTEDADMINISTRATION);
        }
        return PermissionsServiceUtils.PERMISSIONS_ORDERING.sortedCopy((Iterable)result.build());
    }

    @NotNull
    public Collection<BambooPermission> editablePermissions() {
        if (this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.ADMINISTRATION)) {
            return this.supportedPermissions();
        }
        return this.supportedPermissions().stream().filter(permission -> !BambooPermission.ADMINISTRATION.equals(permission)).collect(Collectors.toList());
    }

    @NotNull
    public Collection<BambooPermission> permissionDependencies(@NotNull BambooPermission permission) {
        Collection<BambooPermission> supportedPermissions = this.supportedPermissions();
        return ((Collection)PERMISSION_DEPENDENCIES.asMap().getOrDefault(permission, Collections.emptyList())).stream().flatMap(dependency -> Stream.concat(Stream.of(dependency), this.permissionDependencies((BambooPermission)dependency).stream())).filter(supportedPermissions::contains).collect(Collectors.toSet());
    }

    private boolean addGlobalPermissionKeys(List<String> permissionKeysToAdd) {
        MutableAcl acl = this.getAcl();
        return this.aclHelper.addPermissionKeys(acl, permissionKeysToAdd);
    }

    private boolean removeGlobalPermissionKeys(List<String> permissionKeysToRemove) {
        MutableAcl acl = this.getAcl();
        Optional<BambooPermission> anyAdminPermission = this.aclHelper.calculatePermissionKeysAfterRemoval(acl, permissionKeysToRemove).stream().map(this.aclUpdateHelper::getPermission).map(BambooPermission.class::cast).filter(permission -> permission.equals((Object)BambooPermission.ADMINISTRATION)).findAny();
        if (!anyAdminPermission.isPresent()) {
            throw new IllegalStateException("At least one administrator must be defined for the Bamboo instance");
        }
        return this.aclHelper.removePermissionKeys(acl, permissionKeysToRemove);
    }

    private void validateGlobalPermissions(List<BambooPermission> permissions) throws IllegalArgumentException {
        PermissionsServiceUtils.validatePermissions(permissions, this.supportedPermissions(), "global");
    }

    private User validateUser(String username) {
        return PermissionsServiceUtils.validateUser(username, this.bambooUserManager);
    }

    private Group validateGroup(String groupName) {
        return PermissionsServiceUtils.validateGroup(groupName, this.bambooUserManager);
    }

    private void validateDependenciesAfterGranting(List<BambooPermission> currentPermissions, List<BambooPermission> permissionsToAdd) {
        Sets.SetView effectivePermissions = Sets.union(new HashSet<BambooPermission>(currentPermissions), new HashSet<BambooPermission>(permissionsToAdd));
        PermissionsServiceUtils.validateDependenciesAfterGranting((Collection<BambooPermission>)effectivePermissions, this::permissionDependencies);
    }

    private void validateDependenciesAfterRevoking(List<BambooPermission> currentPermissions, List<BambooPermission> permissionsToRemove) {
        Sets.SetView effectivePermissions = Sets.difference(new HashSet<BambooPermission>(currentPermissions), new HashSet<BambooPermission>(permissionsToRemove));
        PermissionsServiceUtils.validateDependenciesAfterRevoking((Collection<BambooPermission>)effectivePermissions, this::permissionDependencies);
    }

    private void hasPermissions() {
        this.hasPermissionsToChange(Collections.emptyList());
    }

    private void hasPermissionsToChange(List<BambooPermission> permissionsBeingChanged) {
        if (!this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION)) {
            throw new AccessDeniedException("Not allowed to change global permissions");
        }
        if (!this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.ADMINISTRATION)) {
            Collection<BambooPermission> editablePermissions = this.editablePermissions();
            for (BambooPermission permission : permissionsBeingChanged) {
                if (editablePermissions.contains(permission)) continue;
                throw new AccessDeniedException(String.format("You have insufficient rights to grant or revoke the %s permission", permission.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    <T> T withExclusiveLock(Supplier<T> supplier) {
        DefaultGlobalPermissionsService defaultGlobalPermissionsService = this;
        synchronized (defaultGlobalPermissionsService) {
            return (T)this.hibernateTemplate.execute(transactionStatus -> supplier.get());
        }
    }
}

