/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.security.EncryptionException;
import com.atlassian.bamboo.security.EncryptionService;
import com.google.common.base.Throwables;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@ThreadSafe
public class EncryptionServiceImpl
implements EncryptionService {
    private static final Logger log = Logger.getLogger(EncryptionServiceImpl.class);
    private static final String DEFAULT_ENCRYPTION_KEY = "Beetlejuice version $version (c) Copyright 2003-2005 Pols Consulting Limited";
    private static final String DESEDE_ENCRYPTION_SCHEME = "DESede";
    private final SecretKeyFactory myKeyFactory;
    private final DESedeKeySpec myKeySpec;

    public EncryptionServiceImpl() throws EncryptionException {
        try {
            this.myKeySpec = new DESedeKeySpec(DEFAULT_ENCRYPTION_KEY.getBytes(StandardCharsets.UTF_8));
            this.myKeyFactory = SecretKeyFactory.getInstance(DESEDE_ENCRYPTION_SCHEME);
        }
        catch (Exception e) {
            log.fatal((Object)"This shouldn't really occur", (Throwable)e);
            throw new EncryptionException("Failed to initialise", (Throwable)e);
        }
    }

    @NotNull
    public String encrypt(@Nullable String stringToEncrypt) throws EncryptionException {
        if (StringUtils.isEmpty((CharSequence)stringToEncrypt)) {
            return "";
        }
        try {
            byte[] encrypted = this.getEncrypter().doFinal(stringToEncrypt.getBytes(StandardCharsets.UTF_8));
            return Base64.getMimeEncoder().encodeToString(encrypted);
        }
        catch (Exception e) {
            throw new EncryptionException("Failed to encrypt.", (Throwable)e);
        }
    }

    @NotNull
    public String decrypt(@Nullable String data) throws EncryptionException {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return "";
        }
        try {
            byte[] encrypted = Base64.getMimeDecoder().decode(data);
            return new String(this.getDecrypter().doFinal(encrypted), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new EncryptionException("Failed to decrypt.", (Throwable)e);
        }
    }

    private SecretKey generateSecret() throws InvalidKeySpecException {
        return this.myKeyFactory.generateSecret(this.myKeySpec);
    }

    private Cipher getDecrypter() throws InvalidKeySpecException, InvalidKeyException {
        SecretKey secretKey = this.generateSecret();
        Cipher decrypter = EncryptionServiceImpl.newCipher();
        decrypter.init(2, secretKey);
        return decrypter;
    }

    private Cipher getEncrypter() throws InvalidKeySpecException, InvalidKeyException {
        SecretKey secretKey = this.generateSecret();
        Cipher encrypter = EncryptionServiceImpl.newCipher();
        encrypter.init(1, secretKey);
        return encrypter;
    }

    private static Cipher newCipher() {
        try {
            return Cipher.getInstance(DESEDE_ENCRYPTION_SCHEME);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

