/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.security.EncryptionException;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.security.EncryptionServiceImpl;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigratingEncryptionService
implements EncryptionService {
    private SecretEncryptionService secretEncryptionService;
    private EncryptionService legacyEncryptionService = new EncryptionServiceImpl();

    @Inject
    public MigratingEncryptionService(SecretEncryptionService secretEncryptionService) {
        this.secretEncryptionService = secretEncryptionService;
    }

    @NotNull
    public String encrypt(@Nullable String data) throws EncryptionException {
        return this.secretEncryptionService.encrypt(StringUtils.defaultString((String)data));
    }

    @NotNull
    public String decrypt(@Nullable String data) throws EncryptionException {
        return data != null && this.secretEncryptionService.isEncrypted(data) ? this.secretEncryptionService.decrypt(data) : this.legacyEncryptionService.decrypt(data);
    }
}

