/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Permission;
import org.jetbrains.annotations.NotNull;

public class PermissionsServiceUtils {
    @VisibleForTesting
    static final List<BambooPermission> PERMISSIONS_LIST_IN_ORDER = ImmutableList.of((Object)BambooPermission.READ, (Object)BambooPermission.WRITE, (Object)BambooPermission.SOX_COMPLIANCE, (Object)BambooPermission.BUILD, (Object)BambooPermission.CLONE, (Object)BambooPermission.CREATE, (Object)BambooPermission.CREATE_REPOSITORY, (Object)BambooPermission.DELETE, (Object)BambooPermission.SIGN_UP, (Object)BambooPermission.RESTRICTEDADMINISTRATION, (Object)BambooPermission.ADMINISTRATION);
    public static final Ordering<BambooPermission> PERMISSIONS_ORDERING = Ordering.explicit(PERMISSIONS_LIST_IN_ORDER);

    public static User validateUser(String username, BambooUserManager bambooUserManager) {
        User user = bambooUserManager.getUser(username);
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)String.format("User: %s does not exist", username));
        return user;
    }

    public static Group validateGroup(String groupName, BambooUserManager bambooUserManager) {
        Group group = bambooUserManager.getGroup(groupName);
        Preconditions.checkArgument((group != null ? 1 : 0) != 0, (Object)String.format("Group: %s does not exist", groupName));
        return group;
    }

    public static void assertCanManagePermissionsForDeploymentProject(DeploymentProject deploymentProject, BambooPermissionManager bambooPermissionManager) throws AccessDeniedException {
        PermissionsServiceUtils.hasPermissionFor(deploymentProject, "deployment project", bambooPermissionManager, BambooPermission.WRITE);
    }

    public static void assertCanManagePermissionsForEnvironment(Environment environment, BambooPermissionManager bambooPermissionManager) throws AccessDeniedException {
        PermissionsServiceUtils.hasPermissionFor(environment, "environment", bambooPermissionManager, BambooPermission.WRITE);
    }

    public static void assertCanManagePermissionsForRepository(RepositoryDataEntity repository, BambooPermissionManager bambooPermissionManager) throws AccessDeniedException {
        PermissionsServiceUtils.hasPermissionFor(repository, "repository", bambooPermissionManager, BambooPermission.ADMINISTRATION);
    }

    private static void hasPermissionFor(Object entity, String entityName, BambooPermissionManager bambooPermissionManager, BambooPermission permission) throws AccessDeniedException {
        if (!bambooPermissionManager.hasPermission((Permission)permission, entity, null)) {
            throw new AccessDeniedException(String.format("Not allowed to access %s: %s permissions", entityName, entity.toString()));
        }
    }

    public static void validatePermissions(List<BambooPermission> permissions, Collection<BambooPermission> supportedPermissions, String entityName) throws IllegalArgumentException {
        List unsupportedPermissions = permissions.stream().filter(permission -> !supportedPermissions.contains(permission)).map(BambooPermission::getName).collect(Collectors.toList());
        if (!unsupportedPermissions.isEmpty()) {
            throw new IllegalArgumentException(String.format("Following permissions can not be a %s permission: %s", entityName, unsupportedPermissions));
        }
    }

    @NotNull
    public static Set<BambooPermission> extractDependencies(Multimap<BambooPermission, BambooPermission> permissionDependencies, Collection<BambooPermission> supportedPermissions, BambooPermission permission) {
        return ((Collection)permissionDependencies.asMap().getOrDefault(permission, Collections.emptyList())).stream().flatMap(dependency -> Stream.concat(Stream.of(dependency), PermissionsServiceUtils.extractDependencies(permissionDependencies, supportedPermissions, dependency).stream())).filter(supportedPermissions::contains).collect(Collectors.toSet());
    }

    public static void validateDependenciesAfterGranting(@NotNull Collection<BambooPermission> permissions, @NotNull Function<BambooPermission, Collection<BambooPermission>> permissionDependenciesSupplier) throws IllegalArgumentException {
        PermissionsServiceUtils.validateDependenciesAfterGranting(permissions, permissionDependenciesSupplier, BambooPermission::getName, IllegalArgumentException::new);
    }

    public static <E extends Exception> void validateDependenciesAfterGranting(@NotNull Collection<BambooPermission> permissions, @NotNull Function<BambooPermission, Collection<BambooPermission>> permissionDependenciesSupplier, @NotNull Function<BambooPermission, String> permissionNameFunction, @NotNull Function<String, E> exceptionConstructorFunction) throws E {
        ImmutableMultimap<BambooPermission, BambooPermission> missingDependencies = PermissionsServiceUtils.findMissingDependencies(permissions, permissionDependenciesSupplier);
        Optional<BambooPermission> brokenParentPermission = missingDependencies.keys().stream().max(PERMISSIONS_ORDERING);
        if (brokenParentPermission.isPresent()) {
            BambooPermission parentPermission = brokenParentPermission.get();
            List childPermissions = missingDependencies.get((Object)parentPermission).stream().sorted(PERMISSIONS_ORDERING).collect(Collectors.toList());
            String parentPermissionName = String.format("\"%s\"", permissionNameFunction.apply(parentPermission));
            String childPermissionNames = childPermissions.stream().map(permissionNameFunction).map(permissionName -> String.format("\"%s\"", permissionName)).collect(Collectors.joining(", "));
            String errorMessage = String.format("When granting %s permission the following permissions must also be granted: %s", parentPermissionName, childPermissionNames);
            throw (Exception)exceptionConstructorFunction.apply(errorMessage);
        }
    }

    public static void validateDependenciesAfterRevoking(@NotNull Collection<BambooPermission> permissions, @NotNull Function<BambooPermission, Collection<BambooPermission>> permissionDependenciesSupplier) {
        PermissionsServiceUtils.validateDependenciesAfterRevoking(permissions, permissionDependenciesSupplier, BambooPermission::getName, IllegalArgumentException::new);
    }

    public static <E extends Exception> void validateDependenciesAfterRevoking(@NotNull Collection<BambooPermission> permissions, @NotNull Function<BambooPermission, Collection<BambooPermission>> permissionDependenciesSupplier, @NotNull Function<BambooPermission, String> permissionNameFunction, @NotNull Function<String, E> exceptionConstructorFunction) throws E {
        ImmutableMultimap inversedMissingDependencies = PermissionsServiceUtils.findMissingDependencies(permissions, permissionDependenciesSupplier).inverse();
        Optional<BambooPermission> brokenChildPermission = inversedMissingDependencies.keys().stream().max(PERMISSIONS_ORDERING);
        if (brokenChildPermission.isPresent()) {
            BambooPermission childPermission = brokenChildPermission.get();
            List parentPermissions = inversedMissingDependencies.get((Object)childPermission).stream().sorted(PERMISSIONS_ORDERING).collect(Collectors.toList());
            String childPermissionName = String.format("\"%s\"", permissionNameFunction.apply(childPermission));
            String parentPermissionNames = parentPermissions.stream().map(permissionNameFunction).map(permissionName -> String.format("\"%s\"", permissionName)).collect(Collectors.joining(", "));
            String errorMessage = String.format("When revoking %s permission the following permissions must also be revoked: %s", childPermissionName, parentPermissionNames);
            throw (Exception)exceptionConstructorFunction.apply(errorMessage);
        }
    }

    @NotNull
    public static ImmutableMultimap<BambooPermission, BambooPermission> findMissingDependencies(@NotNull Collection<BambooPermission> permissions, @NotNull Function<BambooPermission, Collection<BambooPermission>> permissionDependenciesSupplier) {
        ImmutableSetMultimap.Builder missingDependencies = ImmutableSetMultimap.builder();
        for (BambooPermission permission : permissions) {
            Collection<BambooPermission> permissionDependencies = permissionDependenciesSupplier.apply(permission);
            for (BambooPermission permissionDependency : permissionDependencies) {
                if (permissions.contains(permissionDependency)) continue;
                missingDependencies.put((Object)permission, (Object)permissionDependency);
            }
        }
        return missingDependencies.build();
    }

    @NotNull
    public static Collection<BambooPermission> getPermissionsAndDependencies(@NotNull Collection<BambooPermission> permissions, @NotNull Function<BambooPermission, Collection<BambooPermission>> permissionDependenciesSupplier) {
        LinkedList<BambooPermission> queue = new LinkedList<BambooPermission>(permissions);
        HashSet<BambooPermission> result = new HashSet<BambooPermission>(permissions);
        while (!queue.isEmpty()) {
            BambooPermission permission = (BambooPermission)queue.poll();
            Collection<BambooPermission> dependentPermissions = permissionDependenciesSupplier.apply(permission);
            for (BambooPermission dependentPermission : dependentPermissions) {
                if (result.contains(dependentPermission)) continue;
                queue.add(dependentPermission);
                result.add(dependentPermission);
            }
        }
        return Collections.unmodifiableSet(result);
    }
}

