/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.schedule.BambooScheduler;
import com.atlassian.bamboo.security.RememberMeTokenExpiryJob;
import org.apache.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class RememberMeTokenExpiryScheduler
implements BambooScheduler {
    private static final Logger log = Logger.getLogger(RememberMeTokenExpiryScheduler.class);
    static final String JOB_GROUP = "RememberMeTokenExpirySchedule";
    static final String JOB_NAME = "RememberMeTokenExpiryJob";
    private final Scheduler scheduler;

    public RememberMeTokenExpiryScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void initialiseSchedule() {
        try {
            Trigger trigger = this.scheduler.getTrigger(new TriggerKey(JOB_NAME, JOB_GROUP));
            if (trigger != null && trigger.mayFireAgain()) {
                return;
            }
            JobKey jobKey = new JobKey(JOB_NAME, JOB_GROUP);
            JobDetail jobDetail = JobBuilder.newJob(RememberMeTokenExpiryJob.class).withIdentity(jobKey).build();
            trigger = TriggerBuilder.newTrigger().withIdentity("rememberMeExpiryTrigger").withSchedule((ScheduleBuilder)CronScheduleBuilder.dailyAtHourAndMinute((int)0, (int)0)).build();
            this.scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            log.error((Object)"Unable to schedule RememberMeTokenExpiryJob", (Throwable)e);
        }
    }
}

