/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.persister.XStreamObjectPersister;
import com.atlassian.bamboo.persister.xstream.XStreamFactory;
import com.atlassian.bamboo.security.SecureToken;
import com.atlassian.bamboo.security.SecureTokenService;
import com.atlassian.bamboo.security.XStreamSecureTokenPersister;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SecureTokenServiceImpl
implements SecureTokenService {
    private final LoadingCache<Key, SecureToken> tokens = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Key, SecureToken>(){

        public SecureToken load(@NotNull Key from) {
            SecureToken secureToken = SecureToken.create();
            if (SystemProperty.PERSIST_RUNTIME_STATE.getTypedValue()) {
                SecureTokenServiceImpl.this.tokenPersister.save((Object)new XStreamSecureTokenPersister.PersistedSecureToken(from, secureToken), true);
            }
            return secureToken;
        }
    });
    private final XStreamObjectPersister<Key, XStreamSecureTokenPersister.PersistedSecureToken> tokenPersister;

    @VisibleForTesting
    protected SecureTokenServiceImpl() {
        this.tokenPersister = null;
    }

    public SecureTokenServiceImpl(XStreamFactory xStreamFactory) {
        File buildInProgressStateDirectory = new File(SystemDirectory.getServerStateDirectory(), "secureTokens");
        this.tokenPersister = new XStreamSecureTokenPersister(xStreamFactory.createCompactXStream(), BambooFileUtils.createDirectorySupplier(buildInProgressStateDirectory));
    }

    @NotNull
    public SecureToken generate(@NotNull Key key) {
        return (SecureToken)this.tokens.getUnchecked((Object)key);
    }

    public boolean isValid(@NotNull SecureToken tokenToValidate) {
        return this.tokens.asMap().containsValue(tokenToValidate);
    }

    public boolean isValid(@NotNull SecureToken tokenToValidate, @NotNull Key key) {
        return Objects.equals(this.tokens.getIfPresent((Object)key), tokenToValidate);
    }

    public void invalidate(@NotNull Key key) {
        if (SystemProperty.PERSIST_RUNTIME_STATE.getTypedValue()) {
            this.tokenPersister.remove(key);
        }
        this.tokens.invalidate((Object)key);
    }

    public void restoreState() {
        for (Pair tokenPair : this.tokenPersister.loadAndRemoveAll()) {
            this.tokens.put(tokenPair.getFirst(), (Object)((XStreamSecureTokenPersister.PersistedSecureToken)tokenPair.getSecond()).getSecureToken());
        }
    }
}

