/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.google.common.annotations.VisibleForTesting;
import io.atlassian.util.concurrent.Lazy;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemSerializableClassWhitelistProvider {
    private static final String WHITELIST_RESOURCE = "/serialization-whitelist.list";
    private final Supplier<Iterable<String>> whitelistedClassesSupplier = Lazy.supplier(() -> {
        try (InputStream whitelistResource = this.getWhitelistResource();){
            if (whitelistResource != null) {
                List list = IOUtils.readLines((InputStream)whitelistResource);
                return list;
            }
            throw new RuntimeException("Unable to find list of whitelisted serializable classes");
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't load core whitelisted serializable classes", e);
        }
    });

    @NotNull
    public Iterable<String> getWhitelistedClasses() {
        return this.whitelistedClassesSupplier.get();
    }

    @Nullable
    @VisibleForTesting
    InputStream getWhitelistResource() {
        return this.getClass().getResourceAsStream(WHITELIST_RESOURCE);
    }
}

