/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.security.TrustedKey;
import com.atlassian.bamboo.security.TrustedKeyImpl;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class TrustedKeyDTO
implements TrustedKey {
    public static Function<TrustedKey, TrustedKeyDTO> CONVERTER = TrustedKeyDTO::new;
    private final long id;
    private final String host;
    private final String key;
    private final boolean approved;

    public TrustedKeyDTO(TrustedKey trustedKey) {
        this.id = trustedKey.getId();
        this.host = trustedKey.getHost();
        this.key = trustedKey.getKey();
        this.approved = trustedKey.isApproved();
    }

    public TrustedKeyDTO(String host, String key) {
        this.id = -1L;
        this.host = host;
        this.key = key;
        this.approved = false;
    }

    public TrustedKeyDTO() {
        this("", "");
    }

    @NotNull
    public static TrustedKey from(@Nullable String string) {
        TrustedKeyImpl result = new TrustedKeyImpl();
        if (string == null) {
            return result;
        }
        int firstSpace = string.indexOf(" ");
        if (firstSpace != -1) {
            result.setHost(string.substring(0, firstSpace).trim());
            result.setKey(string.substring(firstSpace).trim());
        } else {
            result.setKey(string);
        }
        return result;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
    }

    public String getKey() {
        return this.key;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public String getHost() {
        return this.host;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrustedKeyDTO that = (TrustedKeyDTO)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append(this.isApproved(), that.isApproved()).append((Object)this.getHost(), (Object)that.getHost()).append((Object)this.getKey(), (Object)that.getKey()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.getHost()).append((Object)this.getKey()).append(this.isApproved()).toHashCode();
    }
}

