/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.event.TrustedKeyRemovedEvent;
import com.atlassian.bamboo.event.TrustedKeySavedEvent;
import com.atlassian.bamboo.security.TrustedKey;
import com.atlassian.bamboo.security.TrustedKeyDTO;
import com.atlassian.bamboo.security.TrustedKeyDao;
import com.atlassian.bamboo.security.TrustedKeyService;
import com.atlassian.event.api.EventPublisher;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class TrustedKeyServiceImpl
implements TrustedKeyService {
    @Inject
    private TrustedKeyDao trustedKeyDao;
    @Inject
    private EventPublisher eventPublisher;

    @NotNull
    public List<TrustedKey> findAll() {
        return this.trustedKeyDao.findAll();
    }

    @NotNull
    public List<TrustedKey> findApproved() {
        return this.findAll().stream().filter(TrustedKey::isApproved).collect(Collectors.toList());
    }

    public void delete(long trustedKeyId) {
        if (this.trustedKeyDao.delete(trustedKeyId)) {
            this.eventPublisher.publish((Object)new TrustedKeyRemovedEvent(this, trustedKeyId));
        }
    }

    public boolean save(@NotNull TrustedKey trustedKey) {
        TrustedKey existingTrustedKey = this.trustedKeyDao.findByHostAndKey(trustedKey.getHost(), trustedKey.getKey());
        if (existingTrustedKey == null || existingTrustedKey.getId() == trustedKey.getId()) {
            this.trustedKeyDao.save((BambooObject)trustedKey);
            this.eventPublisher.publish((Object)new TrustedKeySavedEvent(this, new TrustedKeyDTO(trustedKey)));
            return true;
        }
        return false;
    }
}

