/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi;

import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import java.util.Arrays;
import java.util.Comparator;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.userdetails.UserDetails;
import org.jetbrains.annotations.NotNull;

public class BambooAcegiSecurityUtils {
    private static final Comparator<Sid> SID_COMPARATOR = Comparator.comparing(BambooAclUpdateHelper::extractSidTypeFromSid).thenComparing(BambooAclUpdateHelper::extractPrincipalFromSid);

    private BambooAcegiSecurityUtils() {
    }

    public static boolean hasAuthority(@NotNull Authentication authentication, @NotNull GrantedAuthority checkedAuthority) {
        return BambooAcegiSecurityUtils.hasAuthority(authentication.getAuthorities(), checkedAuthority);
    }

    public static boolean hasAuthority(UserDetails userDetails, @NotNull GrantedAuthority checkedAuthority) {
        return BambooAcegiSecurityUtils.hasAuthority(userDetails.getAuthorities(), checkedAuthority);
    }

    public static boolean hasAuthority(GrantedAuthority[] authorities, @NotNull GrantedAuthority checkedAuthority) {
        return Arrays.asList(authorities).contains(checkedAuthority);
    }

    public static boolean isGranted(@NotNull Acl acl, @NotNull BambooPermission permission, @NotNull Sid sid) {
        try {
            return acl.isGranted(new Permission[]{permission}, new Sid[]{sid}, false);
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public static Comparator<Sid> sidComparator() {
        return SID_COMPARATOR;
    }
}

