/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import org.acegisecurity.event.authorization.AuthenticationCredentialsNotFoundEvent;
import org.acegisecurity.event.authorization.AuthorizationFailureEvent;
import org.acegisecurity.event.authorization.AuthorizedEvent;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class AuthorizationLoggerListener
implements ApplicationListener {
    private static final Logger logger = Logger.getLogger(AuthorizationLoggerListener.class);

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof AuthenticationCredentialsNotFoundEvent) {
            this.warnCredentialsNotFound((AuthenticationCredentialsNotFoundEvent)event);
        }
        if (event instanceof AuthorizationFailureEvent) {
            this.warnAccessDenied((AuthorizationFailureEvent)event);
        }
        if (event instanceof AuthorizedEvent) {
            AuthorizedEvent authEvent = (AuthorizedEvent)event;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Authorization succeeded: " + authEvent.getAuthentication() + "; secure object: " + authEvent.getSource() + "; configuration attributes: " + authEvent.getConfigAttributeDefinition()));
            }
        }
    }

    private void warnAccessDenied(AuthorizationFailureEvent authEvent) {
        String message = "Authorization failed: " + authEvent.getAccessDeniedException() + "; authenticated principal: " + authEvent.getAuthentication() + "; secure object: " + authEvent.getSource() + "; configuration attributes: " + authEvent.getConfigAttributeDefinition();
        this.warnAndAddStacktraceOnDebug(message, (Exception)authEvent.getAccessDeniedException());
    }

    private void warnCredentialsNotFound(AuthenticationCredentialsNotFoundEvent authEvent) {
        String message = "Credentials not found: " + authEvent.getCredentialsNotFoundException() + "; secure object: " + authEvent.getSource() + "; configuration attributes: " + authEvent.getConfigAttributeDefinition();
        this.warnAndAddStacktraceOnDebug(message, (Exception)authEvent.getCredentialsNotFoundException());
    }

    private void warnAndAddStacktraceOnDebug(String message, Exception exception) {
        if (logger.isDebugEnabled()) {
            logger.warn((Object)message, (Throwable)exception);
        } else {
            logger.warn((Object)message);
        }
    }
}

