/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.GroupPrincipalSid;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.user.Authority;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class BambooAclHelper {
    private final HibernateMutableAclService aclService;

    @Autowired
    public BambooAclHelper(HibernateMutableAclService aclService) {
        this.aclService = aclService;
    }

    public Iterable<String> listUsersWithPermissions(@NotNull Acl acl, @NotNull Collection<BambooPermission> supportedPermissions) {
        return Arrays.stream(acl.getEntries()).filter(BambooAclHelper::isAnyUserAccessControlEntry).filter(entry -> BambooAclHelper.isAceOfSupportedPermission(entry, supportedPermissions)).map(AccessControlEntry::getSid).map(PrincipalSid.class::cast).map(PrincipalSid::getPrincipal).sorted().distinct().collect(Collectors.toList());
    }

    public List<BambooPermission> getUserPermissions(@NotNull Acl acl, @NotNull String username, @NotNull Collection<BambooPermission> supportedPermissions) {
        return Arrays.stream(acl.getEntries()).filter(accessControlEntry -> BambooAclHelper.isAUserAccessControlEntry(accessControlEntry, username)).filter(entry -> BambooAclHelper.isAceOfSupportedPermission(entry, supportedPermissions)).map(AccessControlEntry::getPermission).map(BambooPermission.class::cast).collect(Collectors.toList());
    }

    public Iterable<String> listGroupsWithPermissions(@NotNull Acl acl, @NotNull Collection<BambooPermission> supportedPermissions) {
        return Arrays.stream(acl.getEntries()).filter(BambooAclHelper::isAnyGroupAccessControlEntry).filter(entry -> BambooAclHelper.isAceOfSupportedPermission(entry, supportedPermissions)).map(AccessControlEntry::getSid).map(GroupPrincipalSid.class::cast).map(GroupPrincipalSid::getPrincipal).sorted().distinct().collect(Collectors.toList());
    }

    public List<BambooPermission> getGroupPermissions(@NotNull Acl acl, @NotNull String group, @NotNull Collection<BambooPermission> supportedPermissions) {
        return Arrays.stream(acl.getEntries()).filter(accessControlEntry -> BambooAclHelper.isAGroupAccessControlEntry(accessControlEntry, group)).filter(entry -> BambooAclHelper.isAceOfSupportedPermission(entry, supportedPermissions)).map(AccessControlEntry::getPermission).map(BambooPermission.class::cast).collect(Collectors.toList());
    }

    public List<BambooPermission> getLoggedInPermissions(@NotNull Acl acl, @NotNull Collection<BambooPermission> supportedPermissions) {
        return Arrays.stream(acl.getEntries()).filter(accessControlEntry -> BambooAclHelper.isARoleAccessControlEntry(accessControlEntry, Authority.USER.getAuthority())).filter(entry -> BambooAclHelper.isAceOfSupportedPermission(entry, supportedPermissions)).map(AccessControlEntry::getPermission).map(BambooPermission.class::cast).collect(Collectors.toList());
    }

    public List<BambooPermission> getAnonymousPermissions(@NotNull Acl acl, @NotNull Collection<BambooPermission> supportedPermissions) {
        return Arrays.stream(acl.getEntries()).filter(accessControlEntry -> BambooAclHelper.isARoleAccessControlEntry(accessControlEntry, Authority.ANONYMOUS.getAuthority())).filter(entry -> BambooAclHelper.isAceOfSupportedPermission(entry, supportedPermissions)).map(AccessControlEntry::getPermission).map(BambooPermission.class::cast).collect(Collectors.toList());
    }

    public boolean addPermissionKeys(@NotNull MutableAcl acl, @NotNull List<String> permissionKeysToAdd) {
        Set newPermissionKeys = Arrays.stream(acl.getEntries()).map(BambooAclUpdateHelper::getPermissionKeyFromAce).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        if (newPermissionKeys.addAll(permissionKeysToAdd)) {
            this.aclService.updateAclAces(acl, new ArrayList(newPermissionKeys));
            return true;
        }
        return false;
    }

    @NotNull
    public Set<String> calculatePermissionKeysAfterRemoval(@NotNull MutableAcl acl, @NotNull List<String> permissionKeysToRemove) {
        Set<String> newPermissionKeys = Arrays.stream(acl.getEntries()).map(BambooAclUpdateHelper::getPermissionKeyFromAce).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        newPermissionKeys.removeAll(permissionKeysToRemove);
        return newPermissionKeys;
    }

    public boolean removePermissionKeys(@NotNull MutableAcl acl, @NotNull List<String> permissionKeysToRemove) {
        Set newPermissionKeys = Arrays.stream(acl.getEntries()).map(BambooAclUpdateHelper::getPermissionKeyFromAce).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        if (newPermissionKeys.removeAll(permissionKeysToRemove)) {
            this.aclService.updateAclAces(acl, new ArrayList(newPermissionKeys));
            return true;
        }
        return false;
    }

    private static boolean isAnyUserAccessControlEntry(AccessControlEntry accessControlEntry) {
        return PrincipalSid.class.isInstance(accessControlEntry.getSid());
    }

    private static boolean isAUserAccessControlEntry(AccessControlEntry accessControlEntry, String username) {
        return PrincipalSid.class.isInstance(accessControlEntry.getSid()) && ((PrincipalSid)accessControlEntry.getSid()).getPrincipal().equals(username);
    }

    private static boolean isAnyGroupAccessControlEntry(AccessControlEntry accessControlEntry) {
        return GroupPrincipalSid.class.isInstance(accessControlEntry.getSid());
    }

    private static boolean isAGroupAccessControlEntry(AccessControlEntry accessControlEntry, String group) {
        return GroupPrincipalSid.class.isInstance(accessControlEntry.getSid()) && ((GroupPrincipalSid)accessControlEntry.getSid()).getPrincipal().equals(group);
    }

    private static boolean isAnyRoleAccessControlEntry(AccessControlEntry accessControlEntry) {
        return GrantedAuthoritySid.class.isInstance(accessControlEntry.getSid());
    }

    private static boolean isARoleAccessControlEntry(AccessControlEntry accessControlEntry, String role) {
        return GrantedAuthoritySid.class.isInstance(accessControlEntry.getSid()) && ((GrantedAuthoritySid)accessControlEntry.getSid()).getGrantedAuthority().equals(role);
    }

    private static boolean isAceOfSupportedPermission(AccessControlEntry accessControlEntry, Collection<? extends Permission> supportedPermissions) {
        return supportedPermissions.contains(accessControlEntry.getPermission());
    }
}

