/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.AdministrationConfigurationPersister;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.exception.NotFoundException;
import com.atlassian.bamboo.exception.UnauthorisedException;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.GroupPrincipalSid;
import com.atlassian.bamboo.security.acegi.acls.HibernateAclImpl;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.user.Authority;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.utils.BambooOptionals;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.struts.TextProvider;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.acegisecurity.Authentication;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooAclUpdateHelper {
    private static final Logger log = Logger.getLogger(BambooAclUpdateHelper.class);
    private static final String BAMBOO_PERMISSION_FORM_USER = "user";
    private static final String BAMBOO_PERMISSION_FORM_GROUP = "group";
    private static final String BAMBOO_PERMISSION_FORM_ROLE = "role";
    public static final String BAMBOO_PERMISSION_PREFIX = "bambooPermission";
    private static final String BAMBOO_PERMISSION_FORM_SEPARATOR = "_";
    private static final String BAMBOO_PERMISSION_FORM_USER_PREFIX = "bambooPermission_user_";
    public static final String BAMBOO_PERMISSION_FORM_GROUP_PREFIX = "bambooPermission_group_";
    private static final String BAMBOO_PERMISSION_FORM_ROLE_PREFIX = "bambooPermission_role_";
    public static Joiner PERMISSION_KEY_JOINER = Joiner.on((String)"_");

    public static String createUserPermissionKey(String sid, String permissionName) {
        return BambooAclUpdateHelper.createPermissionKey(BAMBOO_PERMISSION_FORM_USER, sid, permissionName);
    }

    public static String createGroupPermissionKey(String sid, String permissionName) {
        return BambooAclUpdateHelper.createPermissionKey(BAMBOO_PERMISSION_FORM_GROUP, sid, permissionName);
    }

    public static String createRolePermissionKey(String sid, String permissionName) {
        return BambooAclUpdateHelper.createPermissionKey(BAMBOO_PERMISSION_FORM_ROLE, sid, permissionName);
    }

    public static String createPermissionKey(@NotNull Sid sid, @NotNull String permissionName) {
        return BambooAclUpdateHelper.createPermissionKey(BambooAclUpdateHelper.extractSidTypeFromSid(sid), BambooAclUpdateHelper.extractPrincipalFromSid(sid), permissionName);
    }

    public static String createPermissionKey(@NotNull String sidType, @NotNull String authority, @NotNull String permissionName) {
        return PERMISSION_KEY_JOINER.join((Object)BAMBOO_PERMISSION_PREFIX, (Object)sidType, new Object[]{authority, permissionName});
    }

    public static Optional<String> getPermissionKeyFromAce(@NotNull AccessControlEntry ace) {
        String permissionName = BambooPermission.determineNameFromPermission((Permission)ace.getPermission());
        if (permissionName != null) {
            Sid sid = ace.getSid();
            if (sid instanceof PrincipalSid) {
                PrincipalSid principalSid = (PrincipalSid)sid;
                return Optional.of(BambooAclUpdateHelper.createUserPermissionKey(principalSid.getPrincipal(), permissionName));
            }
            if (sid instanceof GroupPrincipalSid) {
                GroupPrincipalSid groupPrincipalSid = (GroupPrincipalSid)sid;
                return Optional.of(BambooAclUpdateHelper.createGroupPermissionKey(groupPrincipalSid.getPrincipal(), permissionName));
            }
            if (sid instanceof GrantedAuthoritySid) {
                GrantedAuthoritySid grantedAuthoritySid = (GrantedAuthoritySid)sid;
                return Optional.of(BambooAclUpdateHelper.createRolePermissionKey(grantedAuthoritySid.getGrantedAuthority(), permissionName));
            }
        }
        return Optional.empty();
    }

    public void buildUserGroupListsFromPermissions(List<String> grantedPermissions, List<String> grantedUsers, List<String> grantedGroups) {
        for (String key : grantedPermissions) {
            String groupName;
            String[] parts = this.permissionKeyToParts(key);
            String permissionType = this.getPermissionType(parts);
            if (BAMBOO_PERMISSION_FORM_USER.equals(permissionType)) {
                String userName = this.getPermissionPrincipal(parts);
                if (grantedUsers.contains(userName)) continue;
                grantedUsers.add(userName);
                continue;
            }
            if (!BAMBOO_PERMISSION_FORM_GROUP.equals(permissionType) || grantedGroups.contains(groupName = this.getPermissionPrincipal(parts))) continue;
            grantedGroups.add(groupName);
        }
    }

    @NotNull
    public List<String> addViewPermissionsForEditPermissions(@NotNull List<String> permissionKeys) {
        HashSet<String> result = new HashSet<String>();
        for (String permissionKey : permissionKeys) {
            String[] parts = this.permissionKeyToParts(permissionKey);
            String permissionName = this.getPermissionName(parts);
            if (BambooPermission.WRITE.getName().equals(permissionName)) {
                String readPermissionKey = PERMISSION_KEY_JOINER.join((Object)BAMBOO_PERMISSION_PREFIX, (Object)this.getPermissionType(parts), new Object[]{this.getPermissionPrincipal(parts), BambooPermission.READ.getName()});
                result.add(readPermissionKey);
            }
            result.add(permissionKey);
        }
        return new ArrayList<String>(result);
    }

    public Iterable<Permission> getUserPermissions(@NotNull String userName, @NotNull Acl acl, @NotNull BambooPermissionManager bambooPermissionManager, boolean showAdminPermissions) {
        if (!bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION)) {
            throw new UnauthorisedException("Restricted admin permission required");
        }
        List<String> grantedPermissions = this.getGrantedPermissions(acl, bambooPermissionManager, showAdminPermissions);
        String prefix = BAMBOO_PERMISSION_FORM_USER_PREFIX + userName + BAMBOO_PERMISSION_FORM_SEPARATOR;
        return grantedPermissions.stream().filter(p -> p.startsWith(prefix)).map(p -> p.substring(prefix.length())).map(BambooPermission::buildFromName).collect(Collectors.toList());
    }

    public Iterable<Permission> getGroupPermissions(@NotNull String groupName, @NotNull Acl acl, @NotNull BambooPermissionManager bambooPermissionManager, boolean showAdminPermission) {
        if (!bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION)) {
            throw new UnauthorisedException("Restricted admin permission required");
        }
        List<String> grantedPermissions = this.getGrantedPermissions(acl, bambooPermissionManager, showAdminPermission);
        String prefix = BAMBOO_PERMISSION_FORM_GROUP_PREFIX + groupName + BAMBOO_PERMISSION_FORM_SEPARATOR;
        return grantedPermissions.stream().filter(p -> p.startsWith(prefix)).map(p -> p.substring(prefix.length())).map(BambooPermission::buildFromName).collect(Collectors.toList());
    }

    public Map<String, List<Permission>> getRolePermissions(@NotNull Acl acl, @NotNull BambooPermissionManager bambooPermissionManager, boolean showAdminPermission) {
        if (!bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION)) {
            throw new UnauthorisedException("Restricted admin permission required");
        }
        ImmutableMap result = ImmutableMap.of((Object)Authority.USER.getAuthority(), new ArrayList(), (Object)Authority.ANONYMOUS.getAuthority(), new ArrayList());
        List<String> grantedPermissions = this.getGrantedPermissions(acl, bambooPermissionManager, showAdminPermission);
        String prefix = BAMBOO_PERMISSION_FORM_ROLE_PREFIX;
        for (String grantedPermission : grantedPermissions) {
            if (!grantedPermission.startsWith(BAMBOO_PERMISSION_FORM_ROLE_PREFIX)) continue;
            int lastIndexOfSeparator = grantedPermission.lastIndexOf(BAMBOO_PERMISSION_FORM_SEPARATOR);
            String roleName = grantedPermission.substring(BAMBOO_PERMISSION_FORM_ROLE_PREFIX.length(), lastIndexOfSeparator);
            Permission permission = BambooPermission.buildFromName((String)grantedPermission.substring(lastIndexOfSeparator + 1));
            if (result.containsKey(roleName)) {
                ((List)result.get(roleName)).add(permission);
                continue;
            }
            log.info((Object)("Unknown role:" + roleName));
        }
        return result;
    }

    private List<String> getGrantedPermissions(@NotNull Acl acl, @NotNull BambooPermissionManager bambooPermissionManager, boolean showAdminPermission) {
        ArrayList<String> grantedPermissions = new ArrayList<String>();
        ArrayList<String> grantedUsers = new ArrayList<String>();
        ArrayList<String> grantedGroups = new ArrayList<String>();
        ArrayList<String> nonProcessedGrantedPerms = new ArrayList<String>();
        this.buildPermissionAndUserGroupListsFromAcl(grantedPermissions, grantedUsers, grantedGroups, nonProcessedGrantedPerms, acl, showAdminPermission, bambooPermissionManager);
        return grantedPermissions;
    }

    public void updateRolePermissions(@Nullable String roleName, @NotNull List<Permission> permissions, @NotNull BambooPermissionManager permissionManager, @NotNull HibernateMutableAclService aclService, @NotNull AdministrationConfigurationAccessor administrationConfigurationAccessor, @NotNull AdministrationConfigurationPersister administrationConfigurationPersister) throws WebValidationException {
        if (!permissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION)) {
            throw new UnauthorisedException("Restricted admin permission required");
        }
        BambooValidationUtils.checkErrors(this.validateRolePermissionUpdateRequest(roleName, permissions));
        String permissionPrefix = BAMBOO_PERMISSION_FORM_ROLE_PREFIX + roleName + BAMBOO_PERMISSION_FORM_SEPARATOR;
        this.updatePermissions(permissionPrefix, permissions, aclService);
        if (Authority.ANONYMOUS.getAuthority().equals(roleName)) {
            boolean canRead = permissions.contains(BambooPermission.READ);
            AdministrationConfiguration administrationConfiguration = administrationConfigurationAccessor.getAdministrationConfiguration();
            administrationConfiguration.setEnableAnonymousAccess(canRead);
            administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
        }
    }

    @VisibleForTesting
    protected ErrorCollection validateRolePermissionUpdateRequest(@NotNull String roleName, @NotNull List<Permission> permissions) {
        boolean canModify;
        SimpleErrorCollection result = new SimpleErrorCollection();
        if (!Authority.USER.getAuthority().equals(roleName) && !Authority.ANONYMOUS.getAuthority().equals(roleName)) {
            result.addErrorMessage(String.format("Invalid role name: %s. Must be %s or %s", roleName, Authority.USER.getAuthority(), Authority.ANONYMOUS.getAuthority()));
            return result;
        }
        if (!Authority.USER.getAuthority().equals(roleName) && (canModify = permissions.stream().anyMatch(p -> !BambooPermission.READ.equals(p)))) {
            result.addErrorMessage("Anonymous cannot have any update permission");
        }
        return result;
    }

    public void updateUserPermissions(@Nullable String userName, @NotNull List<Permission> permissions, @NotNull BambooUserManager bambooUserManager, @NotNull BambooPermissionManager bambooPermissionManager, @NotNull HibernateMutableAclService aclService, @NotNull I18nResolver i18nResolver) throws WebValidationException {
        BambooValidationUtils.validateField("name", StringUtils.isNotBlank((CharSequence)userName), () -> i18nResolver.getText("user.username.error.required"));
        if (!bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION)) {
            throw new UnauthorisedException("Restricted admin permission required");
        }
        User user = bambooUserManager.getUser(userName);
        if (user == null) {
            throw new NotFoundException(i18nResolver.getText("user.not.exists"));
        }
        BambooValidationUtils.checkErrors(this.validateUserPermissionsUpdateRequest(user, permissions, bambooUserManager, bambooPermissionManager));
        String permissionPrefix = BAMBOO_PERMISSION_FORM_USER_PREFIX + user.getName() + BAMBOO_PERMISSION_FORM_SEPARATOR;
        this.updatePermissions(permissionPrefix, permissions, aclService);
    }

    public void updateGroupPermissions(@Nullable String groupName, @NotNull List<Permission> permissions, @NotNull BambooPermissionManager bambooPermissionManager, @NotNull HibernateMutableAclService aclService, @NotNull BambooUserManager userManager, @NotNull I18nResolver i18nResolver) throws WebValidationException {
        BambooValidationUtils.validateField("name", StringUtils.isNotBlank((CharSequence)groupName), () -> i18nResolver.getText("group.groupName.error.required"));
        Group group = userManager.getGroup(groupName);
        if (group == null) {
            throw new NotFoundException(i18nResolver.getText("group.not.exists"));
        }
        this.updateGroupPermissions(group, permissions, bambooPermissionManager, aclService);
    }

    public void updateGroupPermissions(@Nullable String groupName, @NotNull List<Permission> permissions, @NotNull BambooPermissionManager bambooPermissionManager, @NotNull HibernateMutableAclService aclService, @NotNull BambooUserManager userManager, @NotNull TextProvider textProvider) throws WebValidationException {
        BambooValidationUtils.validateField("name", StringUtils.isNotBlank((CharSequence)groupName), () -> textProvider.getText("group.groupName.error.required"));
        Group group = userManager.getGroup(groupName);
        if (group == null) {
            throw new NotFoundException(textProvider.getText("group.not.exists"));
        }
        this.updateGroupPermissions(group, permissions, bambooPermissionManager, aclService);
    }

    public void updateGroupPermissions(@NotNull Group group, @NotNull List<Permission> permissions, @NotNull BambooPermissionManager bambooPermissionManager, @NotNull HibernateMutableAclService aclService) throws WebValidationException {
        if (!bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION)) {
            throw new UnauthorisedException("Restricted admin permission required");
        }
        BambooValidationUtils.checkErrors(this.validateUpdateRequest(group, permissions, bambooPermissionManager));
        String permissionPrefix = BAMBOO_PERMISSION_FORM_GROUP_PREFIX + group.getName() + BAMBOO_PERMISSION_FORM_SEPARATOR;
        this.updatePermissions(permissionPrefix, permissions, aclService);
    }

    private void updatePermissions(String permissionPrefix, List<Permission> permissions, HibernateMutableAclService aclService) {
        Stream<String> newPermissions = permissions.stream().map(BambooPermission::determineNameFromPermission).map(name -> permissionPrefix + name);
        Stream<String> filterOutOldGroupPermissions = Arrays.stream(aclService.getAclOfGlobalPermission().getEntries()).map(BambooAclUpdateHelper::getPermissionKeyFromAce).flatMap(BambooOptionals::stream).filter(p -> !p.startsWith(permissionPrefix));
        List updatedPermissions = Stream.concat(filterOutOldGroupPermissions, newPermissions).collect(Collectors.toList());
        aclService.updateAclAces(aclService.getAclOfGlobalPermission(), updatedPermissions);
    }

    @Deprecated
    public static String retrievePermissionFromACE(@NotNull AccessControlEntry ace) {
        return BambooAclUpdateHelper.getPermissionKeyFromAce(ace).orElse(null);
    }

    @VisibleForTesting
    @NotNull
    protected ErrorCollection validateUpdateRequest(@Nullable Group group, @NotNull List<Permission> permissions, @NotNull BambooPermissionManager bambooPermissionManager) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Collection currentAdminGroups = bambooPermissionManager.getAdminGroups();
        if (!this.isSystemAdministrator(bambooPermissionManager) && (currentAdminGroups.contains(group.getName()) || permissions.contains(BambooPermission.ADMINISTRATION))) {
            throw new UnauthorisedException("Current user cannot modify System Admin permissions");
        }
        Collection currentAdminUsers = bambooPermissionManager.getAdminUsers();
        String groupName = group.getName();
        boolean hasAdminPerm = permissions.contains(BambooPermission.ADMINISTRATION);
        if (!hasAdminPerm && currentAdminGroups.size() == 1 && currentAdminGroups.contains(groupName) && currentAdminUsers.isEmpty()) {
            errorCollection.addError("permissions", "You must have at least one administrator");
        }
        return errorCollection;
    }

    @NotNull
    @VisibleForTesting
    ErrorCollection validateUserPermissionsUpdateRequest(@NotNull User user, @NotNull List<Permission> permissions, @NotNull BambooUserManager bambooUserManager, @NotNull BambooPermissionManager bambooPermissionManager) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Collection currentAdminUsers = bambooPermissionManager.getAdminUsers();
        if (!this.isSystemAdministrator(bambooPermissionManager) && (currentAdminUsers.contains(user.getName()) || permissions.contains(BambooPermission.ADMINISTRATION))) {
            throw new UnauthorisedException("Current user cannot modify System Admin permissions");
        }
        boolean hasAdminPerm = permissions.contains(BambooPermission.ADMINISTRATION);
        if (!hasAdminPerm && currentAdminUsers.size() == 1 && currentAdminUsers.contains(user.getName())) {
            boolean hasAdminByGroup = bambooPermissionManager.getAdminGroups().stream().map(arg_0 -> ((BambooUserManager)bambooUserManager).getGroup(arg_0)).map(arg_0 -> ((BambooUserManager)bambooUserManager).getMemberNamesAsList(arg_0)).anyMatch(CollectionUtils::isNotEmpty);
            if (!hasAdminByGroup) {
                errorCollection.addError("permissions", "You must have at least one administrator");
            }
        }
        return errorCollection;
    }

    private boolean isSystemAdministrator(@NotNull BambooPermissionManager bambooPermissionManager) {
        return bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.ADMINISTRATION);
    }

    public void buildPermissionAndUserGroupListsFromAcl(@NotNull List<String> grantedPermissions, @NotNull List<String> grantedUsers, @NotNull List<String> grantedGroups, @NotNull List<String> nonProcessedGrantedPermissions, @NotNull Acl acl, boolean showAdminPermissions, @NotNull BambooPermissionManager bambooPermissionManager) {
        AccessControlEntry[] accessControlEntries;
        for (AccessControlEntry accessControlEntry : accessControlEntries = acl.getEntries()) {
            String principal;
            Sid sid = accessControlEntry.getSid();
            Permission permission = accessControlEntry.getPermission();
            String name = BambooPermission.determineNameFromPermission((Permission)permission);
            if (sid instanceof GroupPrincipalSid) {
                GroupPrincipalSid groupPrincipalSid = (GroupPrincipalSid)sid;
                principal = groupPrincipalSid.getPrincipal();
                if (bambooPermissionManager.getAdminGroups().contains(principal) && !showAdminPermissions) {
                    nonProcessedGrantedPermissions.add(BambooAclUpdateHelper.createGroupPermissionKey(principal, name));
                    continue;
                }
                if (!grantedGroups.contains(principal)) {
                    grantedGroups.add(principal);
                }
                if (name == null) continue;
                grantedPermissions.add(BambooAclUpdateHelper.createGroupPermissionKey(principal, name));
                continue;
            }
            if (sid instanceof PrincipalSid) {
                PrincipalSid principalSid = (PrincipalSid)sid;
                principal = principalSid.getPrincipal();
                boolean isAdmin = bambooPermissionManager.hasPermission(principal, (Permission)BambooPermission.ADMINISTRATION, (Object)GlobalApplicationSecureObject.INSTANCE);
                if (isAdmin && !showAdminPermissions) {
                    nonProcessedGrantedPermissions.add(BambooAclUpdateHelper.createUserPermissionKey(principal, name));
                    continue;
                }
                if (!grantedUsers.contains(principal)) {
                    grantedUsers.add(principal);
                }
                if (name == null) continue;
                grantedPermissions.add(BambooAclUpdateHelper.createUserPermissionKey(principal, name));
                continue;
            }
            if (!(sid instanceof GrantedAuthoritySid)) continue;
            GrantedAuthoritySid grantedAuthoritySid = (GrantedAuthoritySid)sid;
            String authority = grantedAuthoritySid.getGrantedAuthority();
            if (Authority.ADMIN.getAuthority().equals(authority) && !showAdminPermissions) {
                nonProcessedGrantedPermissions.add(BambooAclUpdateHelper.createRolePermissionKey(authority, name));
                continue;
            }
            if (name == null) continue;
            grantedPermissions.add(BambooAclUpdateHelper.createRolePermissionKey(authority, name));
        }
    }

    public void modifyAclAces(MutableAcl acl, List<String> newPermissionKeys) {
        ArrayList<String> clonedPermissionKeys = new ArrayList<String>(newPermissionKeys);
        for (AccessControlEntry oldAce : acl.getEntries()) {
            String permissionKey = BambooAclUpdateHelper.getPermissionKeyFromAce(oldAce).orElse("");
            if (!clonedPermissionKeys.contains(permissionKey)) {
                acl.deleteAce(oldAce.getId());
                continue;
            }
            clonedPermissionKeys.remove(permissionKey);
        }
        for (String key : clonedPermissionKeys) {
            String[] parts = this.permissionKeyToParts(key);
            String permissionName = this.getPermissionName(parts);
            Sid sid = null;
            try {
                sid = this.getSidFromPermissionKey(key);
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)("Ignoring permission key " + key + " as it is invalid"));
            }
            if (sid == null) continue;
            acl.insertAce(null, BambooPermission.buildFromName((String)permissionName), sid, true);
        }
    }

    public void addPermissionsToAclForCurrentUser(@NotNull MutableAcl acl, @NotNull List<BambooPermission> permissions) {
        ContainerManager.autowireComponent((Object)acl);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        PrincipalSid sid = new PrincipalSid(auth);
        permissions.forEach(permission -> acl.insertAce(null, (Permission)permission, (Sid)sid, true));
    }

    private PrincipalSid getCreatorSid(@Nullable User user) {
        if (user != null) {
            return new PrincipalSid(user.getName());
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return new PrincipalSid(auth);
    }

    @NotNull
    public MutableAcl createNewDefaultAcl(@Nullable User user, Class<? extends Plan> planType, boolean accessForAllUsers) {
        PrincipalSid creator = this.getCreatorSid(user);
        HibernateAclImpl acl = new HibernateAclImpl(new HibernateObjectIdentityImpl(planType, (Serializable)Long.valueOf(-1L)), null, true, (Sid)creator);
        ContainerManager.autowireComponent((Object)acl);
        if (accessForAllUsers) {
            this.addBasicAclsForUsers(acl);
        }
        if (user != null) {
            this.addBasicAclsForCreator(creator, acl);
            acl.insertAce(null, (Permission)BambooPermission.ADMINISTRATION, (Sid)creator, true);
            acl.insertAce(null, (Permission)BambooPermission.CLONE, (Sid)creator, true);
            acl.insertAce(null, (Permission)BambooPermission.BUILD, (Sid)creator, true);
        }
        return acl;
    }

    @NotNull
    public MutableAcl createNewObjectAcl(@Nullable User user, Class<? extends BambooIdProvider> permissionObject, long id, boolean accessForAllUsers) {
        PrincipalSid creator = this.getCreatorSid(user);
        HibernateAclImpl acl = new HibernateAclImpl(new HibernateObjectIdentityImpl(permissionObject, (Serializable)Long.valueOf(-1L)), null, true, (Sid)creator);
        ContainerManager.autowireComponent((Object)acl);
        if (accessForAllUsers) {
            this.addBasicAclsForUsers(acl);
        }
        if (user != null) {
            this.addBasicAclsForCreator(creator, acl);
        }
        acl.setObjectIdentity(new HibernateObjectIdentityImpl(permissionObject, (Serializable)Long.valueOf(id)));
        return acl;
    }

    @NotNull
    public MutableAcl copyProjectPermissionsToEnvironment(@Nullable User user, Class<? extends BambooIdProvider> permissionObject, long id, Acl parentAcl) {
        PrincipalSid creator = this.getCreatorSid(user);
        MutableAcl acl = this.clonePermissions(user, permissionObject, id, parentAcl);
        if (user != null) {
            acl.insertAce(null, (Permission)BambooPermission.BUILD, (Sid)creator, true);
        }
        return acl;
    }

    @NotNull
    public MutableAcl clonePermissions(@Nullable User user, Class<? extends BambooIdProvider> permissionObject, long id, Acl parentAcl) {
        PrincipalSid creator = this.getCreatorSid(user);
        HibernateAclImpl acl = new HibernateAclImpl(new HibernateObjectIdentityImpl(permissionObject, (Serializable)Long.valueOf(-1L)), null, true, (Sid)creator);
        ContainerManager.autowireComponent((Object)acl);
        if (user != null) {
            Arrays.stream(parentAcl.getEntries()).forEach(ace -> acl.insertAce(null, ace.getPermission(), ace.getSid(), ace.isGranting()));
        }
        acl.setObjectIdentity(new HibernateObjectIdentityImpl(permissionObject, (Serializable)Long.valueOf(id)));
        return acl;
    }

    @NotNull
    public static String extractPrincipalFromSid(@NotNull Sid sid) {
        if (sid instanceof GrantedAuthoritySid) {
            return ((GrantedAuthoritySid)sid).getGrantedAuthority();
        }
        if (sid instanceof PrincipalSid) {
            return ((PrincipalSid)sid).getPrincipal();
        }
        if (sid instanceof GroupPrincipalSid) {
            return ((GroupPrincipalSid)sid).getPrincipal();
        }
        throw new IllegalStateException("Unknown SID type: " + sid.getClass().getName());
    }

    public static String extractSidTypeFromSid(@NotNull Sid sid) {
        if (sid instanceof GrantedAuthoritySid) {
            return BAMBOO_PERMISSION_FORM_ROLE;
        }
        if (sid instanceof PrincipalSid) {
            return BAMBOO_PERMISSION_FORM_USER;
        }
        if (sid instanceof GroupPrincipalSid) {
            return BAMBOO_PERMISSION_FORM_GROUP;
        }
        throw new IllegalStateException("Unknown SID type: " + sid.getClass().getName());
    }

    @NotNull
    public Sid getSidFromPermissionKey(@NotNull String permissionKey) {
        String[] parts = this.permissionKeyToParts(permissionKey);
        String principalName = this.getPermissionPrincipal(parts);
        String permissionType = this.getPermissionType(parts);
        if (BAMBOO_PERMISSION_FORM_USER.equals(permissionType)) {
            return new PrincipalSid(principalName);
        }
        if (BAMBOO_PERMISSION_FORM_GROUP.equals(permissionType)) {
            return new GroupPrincipalSid(principalName);
        }
        if (BAMBOO_PERMISSION_FORM_ROLE.equals(permissionType)) {
            return new GrantedAuthoritySid(principalName);
        }
        throw new IllegalArgumentException("Unknown permission type: " + permissionType);
    }

    public void addReadPermissionForAnonymousAndLoggedinUsers(@NotNull MutableAcl acl) {
        acl.insertAce(null, (Permission)BambooPermission.READ, (Sid)new GrantedAuthoritySid(Authority.USER), true);
        acl.insertAce(null, (Permission)BambooPermission.READ, (Sid)new GrantedAuthoritySid(Authority.ANONYMOUS), true);
    }

    @NotNull
    public Sid getSidFromIdAndType(@NotNull String id, @NotNull String type) {
        switch (type) {
            case "PRINCIPAL": {
                return new PrincipalSid(id);
            }
            case "GROUP_PRINCIPAL": {
                return new GroupPrincipalSid(id);
            }
            case "GRANTED_AUTHORITY": {
                return new GrantedAuthoritySid(id);
            }
        }
        throw new IllegalArgumentException("Unknown sid type: " + type);
    }

    private void addBasicAclsForUsers(@NotNull MutableAcl acl) {
        this.addReadPermissionForAnonymousAndLoggedinUsers(acl);
        BambooPermissionManager bambooPermissionManager = (BambooPermissionManager)ComponentAccessor.BAMBOO_PERMISSION_MANAGER.get();
        AdministrationConfigurationAccessor administrationConfigurationAccessor = (AdministrationConfigurationAccessor)ComponentAccessor.ADMINISTRATION_CONFIGURATION_ACCESSOR.get();
        boolean hasLoggedUserSoxCompliance = bambooPermissionManager.hasPermissionForAuthority((Permission)BambooPermission.SOX_COMPLIANCE, (Object)GlobalApplicationSecureObject.INSTANCE, Authority.USER);
        boolean soxComplianceModeEnabled = administrationConfigurationAccessor.getAdministrationConfiguration().isSoxComplianceModeEnabled();
        if (soxComplianceModeEnabled && hasLoggedUserSoxCompliance) {
            acl.insertAce(null, (Permission)BambooPermission.BUILD, (Sid)new GrantedAuthoritySid(Authority.USER), true);
        }
    }

    private void addBasicAclsForCreator(@NotNull PrincipalSid creator, @NotNull MutableAcl acl) {
        acl.insertAce(null, (Permission)BambooPermission.WRITE, (Sid)creator, true);
        acl.insertAce(null, (Permission)BambooPermission.READ, (Sid)creator, true);
    }

    String[] permissionKeyToParts(@NotNull String permissionKey) {
        return permissionKey.split(BAMBOO_PERMISSION_FORM_SEPARATOR);
    }

    String getPermissionName(String[] permissionKeyParts) {
        assert (permissionKeyParts.length >= 4);
        return permissionKeyParts[permissionKeyParts.length - 1];
    }

    public Permission getPermission(String permissionKey) {
        String[] parts = this.permissionKeyToParts(permissionKey);
        String permissionName = this.getPermissionName(parts);
        return BambooPermission.buildFromName((String)permissionName);
    }

    String getPermissionPrincipal(String[] permissionKeyParts) {
        assert (permissionKeyParts.length >= 4);
        return Joiner.on((String)BAMBOO_PERMISSION_FORM_SEPARATOR).join((Object[])Arrays.copyOfRange(permissionKeyParts, 2, permissionKeyParts.length - 1));
    }

    String getPermissionType(String[] permissionKeyParts) {
        assert (permissionKeyParts.length >= 4);
        return permissionKeyParts[1];
    }
}

