/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.acegisecurity.Authentication;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.acls.sid.SidRetrievalStrategy;
import org.jetbrains.annotations.NotNull;

public class CachingSidRetrievalStrategy
implements SidRetrievalStrategy {
    private final SidRetrievalStrategy sidRetrievalStrategy;
    private final LoadingCache<Authentication, Sid[]> sidCache = CacheBuilder.newBuilder().build(CacheLoader.from((Function)new Function<Authentication, Sid[]>(){

        public Sid[] apply(Authentication authentication) {
            return CachingSidRetrievalStrategy.this.sidRetrievalStrategy.getSids(authentication);
        }
    }));

    public CachingSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
        this.sidRetrievalStrategy = sidRetrievalStrategy;
    }

    public Sid[] getSids(@NotNull Authentication authentication) {
        return (Sid[])this.sidCache.getUnchecked((Object)authentication);
    }
}

