/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import com.atlassian.bamboo.security.acegi.acls.GroupPrincipalSid;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.user.DefaultBambooUser;
import com.atlassian.bamboo.utils.BambooLogger;
import com.atlassian.bamboo.utils.scopedcaches.ThreadScopedCaches;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.acls.sid.SidRetrievalStrategy;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Lazy;

public class GroupAwareSidRetrievalStrategyImpl
implements SidRetrievalStrategy {
    private static final BambooLogger log = BambooLogger.getLogger(GroupAwareSidRetrievalStrategyImpl.class);
    private static final ThreadScopedCaches.Key<Authentication, Sid[]> CACHE_KEY = ThreadScopedCaches.makeKey(GroupAwareSidRetrievalStrategyImpl.class);
    @Lazy
    @Inject
    private BambooUserManager bambooUserManager;

    public Sid[] getSids(@NotNull Authentication authentication) {
        return (Sid[])ThreadScopedCaches.getValue(CACHE_KEY, (Object)authentication, () -> {
            List<Sid> list = this.getSidList(authentication);
            return list.toArray(new Sid[0]);
        });
    }

    private List<Sid> getSidList(@NotNull Authentication authentication) {
        Object principal = authentication.getPrincipal();
        String userName = authentication.getName();
        Class<?> principalClass = principal.getClass();
        log.debug("Calculating list of sids for user '%s' (principal type: %s)", new Object[]{userName, principalClass.getName()});
        ArrayList<Sid> list = new ArrayList<Sid>();
        PrincipalSid principalSid = new PrincipalSid(authentication);
        list.add((Sid)principalSid);
        if (principal instanceof DefaultBambooUser) {
            List groups = this.bambooUserManager.getGroupNamesAsList(((BambooUser)principal).getUser());
            log.debug("Found %d groups for user '%s'", new Object[]{groups.size(), userName});
            for (String group : groups) {
                GroupPrincipalSid groupPrincipalSid = new GroupPrincipalSid(group);
                list.add((Sid)groupPrincipalSid);
            }
        } else {
            log.debug("Could not obtain groups for user '%s'", new Object[]{userName});
        }
        GrantedAuthority[] authorities = authentication.getAuthorities();
        log.debug("Found %d authorities for user '%s'", new Object[]{authorities.length, userName});
        for (GrantedAuthority authority : authorities) {
            GrantedAuthoritySid grantedAuthoritySid = new GrantedAuthoritySid(authority);
            list.add((Sid)grantedAuthoritySid);
        }
        log.debug("Calculated %d sids in total for user '%s'", new Object[]{list.size(), userName});
        log.trace("%s", new Object[]{list});
        return list;
    }
}

