/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import java.io.Serializable;
import java.util.Objects;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.AuditableAccessControlEntry;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.sid.Sid;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public class HibernateAccessControlEntryImpl
implements AccessControlEntry,
AuditableAccessControlEntry {
    private static final Logger log = Logger.getLogger(HibernateAccessControlEntryImpl.class);
    private Acl acl;
    private Permission permission;
    private Serializable id;
    private Sid sid;
    private boolean auditFailure = false;
    private boolean auditSuccess = false;
    private boolean granting;
    private int order;

    public HibernateAccessControlEntryImpl() {
    }

    public HibernateAccessControlEntryImpl(Serializable id, Acl acl, Sid sid, Permission permission, boolean granting, boolean auditSuccess, boolean auditFailure) {
        Assert.notNull((Object)acl, (String)"Acl required");
        Assert.notNull((Object)sid, (String)"Sid required");
        Assert.notNull((Object)permission, (String)"Permission required");
        this.id = id;
        this.acl = acl;
        this.sid = sid;
        this.permission = permission;
        this.granting = granting;
        this.auditSuccess = auditSuccess;
        this.auditFailure = auditFailure;
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof HibernateAccessControlEntryImpl)) {
            return false;
        }
        HibernateAccessControlEntryImpl rhs = (HibernateAccessControlEntryImpl)arg0;
        return this.auditFailure == rhs.isAuditFailure() && this.auditSuccess == rhs.isAuditSuccess() && this.granting == rhs.isGranting() && this.acl.equals(rhs.getAcl()) && this.id.equals(rhs.getId()) && this.permission.equals(rhs.getPermission()) && this.sid.equals((Object)rhs.getSid());
    }

    public int hashCode() {
        return Objects.hash(this.isAuditFailure(), this.isAuditSuccess(), this.isGranting(), this.getAcl(), this.getId(), this.getPermission(), this.getSid());
    }

    public Acl getAcl() {
        return this.acl;
    }

    public Serializable getId() {
        return this.id;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public Sid getSid() {
        return this.sid;
    }

    public boolean isAuditFailure() {
        return this.auditFailure;
    }

    public boolean isAuditSuccess() {
        return this.auditSuccess;
    }

    public boolean isGranting() {
        return this.granting;
    }

    public void setAuditFailure(boolean auditFailure) {
        this.auditFailure = auditFailure;
    }

    public void setAuditSuccess(boolean auditSuccess) {
        this.auditSuccess = auditSuccess;
    }

    public void setPermission(Permission permission) {
        Assert.notNull((Object)permission, (String)"Permission required");
        this.permission = permission;
    }

    public void setAcl(Acl acl) {
        this.acl = acl;
    }

    public void setId(Serializable id) {
        this.id = id;
    }

    public void setSid(Sid sid) {
        this.sid = sid;
    }

    public void setGranting(boolean granting) {
        this.granting = granting;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AccessControlEntryImpl[");
        sb.append("id: ").append(this.id).append("; ");
        sb.append("granting: ").append(this.granting).append("; ");
        sb.append("sid: ").append(this.sid).append("; ");
        sb.append("permission: ").append(this.permission).append("; ");
        sb.append("auditSuccess: ").append(this.auditSuccess).append("; ");
        sb.append("auditFailure: ").append(this.auditFailure);
        sb.append("]");
        return sb.toString();
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

