/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import com.atlassian.bamboo.security.acegi.acls.HibernateAccessControlEntryImpl;
import com.atlassian.bamboo.security.acegi.acls.HibernateAcl;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.AuditableAcl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.OwnershipAcl;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.UnloadedSidException;
import org.acegisecurity.acls.domain.AclAuthorizationStrategy;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.sid.Sid;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.Nullable;
import org.springframework.util.Assert;

@Entity
@Table(name="ACL_OBJECT_IDENTITY")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class HibernateAclImpl
implements Acl,
MutableAcl,
AuditableAcl,
OwnershipAcl,
HibernateAcl {
    private static final Logger log = Logger.getLogger(HibernateAclImpl.class);
    @Nullable
    private Acl parentAcl;
    private AclAuthorizationStrategy aclAuthorizationStrategy;
    private List<AccessControlEntry> aces = new Vector<AccessControlEntry>();
    private ObjectIdentity objectIdentity;
    private Serializable id = Long.valueOf(-1L);
    private Sid owner;
    private Sid[] loadedSids = null;
    private boolean entriesInheriting = true;

    public HibernateAclImpl(ObjectIdentity objectIdentity, Serializable id, AclAuthorizationStrategy aclAuthorizationStrategy) {
        Assert.notNull((Object)objectIdentity, (String)"Object Identity required");
        Assert.notNull((Object)id, (String)"Id required");
        Assert.notNull((Object)aclAuthorizationStrategy, (String)"AclAuthorizationStrategy required");
        this.objectIdentity = objectIdentity;
        this.id = id;
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
    }

    public HibernateAclImpl(ObjectIdentity objectIdentity, Serializable id, AclAuthorizationStrategy aclAuthorizationStrategy, @Nullable Acl parentAcl, @Nullable Sid[] loadedSids, boolean entriesInheriting, Sid owner) {
        Assert.notNull((Object)objectIdentity, (String)"Object Identity required");
        Assert.notNull((Object)id, (String)"Id required");
        Assert.notNull((Object)aclAuthorizationStrategy, (String)"AclAuthorizationStrategy required");
        Assert.notNull((Object)owner, (String)"Owner required");
        this.objectIdentity = objectIdentity;
        this.id = id;
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
        this.parentAcl = parentAcl;
        this.loadedSids = loadedSids;
        this.entriesInheriting = entriesInheriting;
        this.owner = owner;
    }

    public HibernateAclImpl() {
    }

    public HibernateAclImpl(ObjectIdentity objectIdentity, @Nullable Acl parentAcl, boolean entriesInheriting, Sid owner) {
        this.parentAcl = parentAcl;
        this.objectIdentity = objectIdentity;
        this.owner = owner;
        this.entriesInheriting = entriesInheriting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAce(Serializable aceId) throws NotFoundException {
        this.checkSecurityForAclUpdate(2);
        List<AccessControlEntry> list = this.aces;
        synchronized (list) {
            int offset = this.findAceOffset(aceId);
            if (offset == -1) {
                throw new NotFoundException("Requested ACE ID not found");
            }
            this.aces.remove(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findAceOffset(Serializable aceId) {
        Assert.notNull((Object)aceId, (String)"ACE ID is required");
        List<AccessControlEntry> list = this.aces;
        synchronized (list) {
            for (int i = 0; i < this.aces.size(); ++i) {
                AccessControlEntry ace = this.aces.get(i);
                if (!ace.getId().equals(aceId)) continue;
                return i;
            }
        }
        return -1;
    }

    public AccessControlEntry[] getEntries() {
        return (AccessControlEntry[])Iterables.toArray(this.aces, AccessControlEntry.class);
    }

    public Serializable getId() {
        return this.id;
    }

    public ObjectIdentity getObjectIdentity() {
        return this.objectIdentity;
    }

    public Sid getOwner() {
        return this.owner;
    }

    @Nullable
    public Acl getParentAcl() {
        return this.parentAcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAce(@Nullable Serializable afterAceId, Permission permission, Sid sid, boolean granting) throws NotFoundException {
        this.checkSecurityForAclUpdate(2);
        Assert.notNull((Object)permission, (String)"Permission required");
        Assert.notNull((Object)sid, (String)"Sid required");
        HibernateAccessControlEntryImpl ace = new HibernateAccessControlEntryImpl(Long.valueOf(-1L), this, sid, permission, granting, false, false);
        List<AccessControlEntry> list = this.aces;
        synchronized (list) {
            if (afterAceId != null) {
                int offset = this.findAceOffset(afterAceId);
                if (offset == -1) {
                    throw new NotFoundException("Requested ACE ID not found");
                }
                this.aces.add(offset + 1, ace);
            } else {
                this.aces.add(ace);
            }
        }
    }

    public boolean isEntriesInheriting() {
        return this.entriesInheriting;
    }

    public boolean isGranted(Permission[] permission, Sid[] sids, boolean administrativeMode) throws NotFoundException, UnloadedSidException {
        Assert.notEmpty((Object[])permission, (String)"Permissions required");
        Assert.notEmpty((Object[])sids, (String)"SIDs required");
        if (!this.isSidLoaded(sids)) {
            throw new UnloadedSidException("ACL was not loaded for one or more SID");
        }
        AccessControlEntry firstRejection = null;
        block0: for (int i = 0; i < permission.length; ++i) {
            for (int x = 0; x < sids.length; ++x) {
                Iterator<AccessControlEntry> acesIterator = this.aces.iterator();
                boolean scanNextSid = true;
                while (acesIterator.hasNext()) {
                    AccessControlEntry ace = acesIterator.next();
                    if (ace.getPermission().getMask() != permission[i].getMask() || !ace.getSid().equals((Object)sids[x])) continue;
                    if (ace.isGranting()) {
                        if (!administrativeMode) {
                            // empty if block
                        }
                        return true;
                    }
                    if (firstRejection == null) {
                        firstRejection = ace;
                    }
                    scanNextSid = false;
                    break;
                }
                if (!scanNextSid) continue block0;
            }
        }
        if (firstRejection != null) {
            if (!administrativeMode) {
                // empty if block
            }
            return false;
        }
        if (this.isEntriesInheriting() && this.parentAcl != null) {
            return this.parentAcl.isGranted(permission, sids, false);
        }
        throw new NotFoundException("Unable to locate a matching ACE for passed permissions and SIDs");
    }

    public boolean isSidLoaded(Sid[] sids) {
        if (this.loadedSids == null || sids == null || sids.length == 0) {
            return true;
        }
        for (int i = 0; i < sids.length; ++i) {
            boolean found = false;
            for (int y = 0; y < this.loadedSids.length; ++y) {
                if (!sids[i].equals((Object)this.loadedSids[y])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void setEntriesInheriting(boolean entriesInheriting) {
        this.entriesInheriting = entriesInheriting;
    }

    public void setOwner(Sid newOwner) {
        this.owner = newOwner;
    }

    public void setParent(MutableAcl newParent) {
        this.parentAcl = newParent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AclImpl[");
        sb.append("id: ").append(this.id).append("; ");
        sb.append("objectIdentity: ").append(this.objectIdentity).append("; ");
        sb.append("owner: ").append(this.owner).append("; ");
        Iterator<AccessControlEntry> iterator = this.aces.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            if (++count == 1) {
                sb.append("\r\n");
            }
            sb.append(iterator.next().toString()).append("\r\n");
        }
        if (count == 0) {
            sb.append("no ACEs; ");
        }
        sb.append("inheriting: ").append(this.entriesInheriting).append("; ");
        sb.append("parent: ").append(this.parentAcl == null ? "Null" : this.parentAcl.getObjectIdentity().toString());
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAce(Serializable aceId, Permission permission) throws NotFoundException {
        this.checkSecurityForAclUpdate(2);
        List<AccessControlEntry> list = this.aces;
        synchronized (list) {
            int offset = this.findAceOffset(aceId);
            if (offset == 1) {
                throw new NotFoundException("Requested ACE ID not found");
            }
            HibernateAccessControlEntryImpl ace = (HibernateAccessControlEntryImpl)this.aces.get(offset);
            ace.setPermission(permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAuditing(Serializable aceId, boolean auditSuccess, boolean auditFailure) {
        this.checkSecurityForAclUpdate(1);
        List<AccessControlEntry> list = this.aces;
        synchronized (list) {
            int offset = this.findAceOffset(aceId);
            if (offset == 1) {
                throw new NotFoundException("Requested ACE ID not found");
            }
            HibernateAccessControlEntryImpl ace = (HibernateAccessControlEntryImpl)this.aces.get(offset);
            ace.setAuditSuccess(auditSuccess);
            ace.setAuditFailure(auditFailure);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(671, 13).append((Object)this.getObjectIdentity()).append((Object)this.getOwner()).append((Object)this.getParentAcl()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof HibernateAclImpl)) {
            return false;
        }
        HibernateAclImpl rhs = (HibernateAclImpl)o;
        return new EqualsBuilder().append((Object)this.getObjectIdentity(), (Object)rhs.getObjectIdentity()).append((Object)this.getOwner(), (Object)rhs.getOwner()).append((Object)this.getParentAcl(), (Object)rhs.getParentAcl()).isEquals();
    }

    private void checkSecurityForAclUpdate(int changeType) {
        try {
            this.aclAuthorizationStrategy.securityCheck((Acl)this, changeType);
        }
        catch (NotFoundException e) {
            throw new AccessDeniedException("Principal does not have required ACL permissions to perform requested operation");
        }
    }

    public void setParentAcl(Acl parentAcl) {
        this.parentAcl = parentAcl;
    }

    public void setParent(Acl newParent) {
        this.setParentAcl(newParent);
    }

    public void setAclAuthorizationStrategy(AclAuthorizationStrategy aclAuthorizationStrategy) {
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
    }

    private void setAces(List<AccessControlEntry> aces) {
        this.aces = aces;
    }

    public List<AccessControlEntry> getAces() {
        return this.aces;
    }

    public void setObjectIdentity(ObjectIdentity objectIdentity) {
        this.objectIdentity = objectIdentity;
    }

    public void setId(Serializable id) {
        this.id = id;
    }

    @Nullable
    Sid[] getLoadedSids() {
        return this.loadedSids;
    }

    @Nullable
    AclAuthorizationStrategy getAclAuthorizationStrategy() {
        return this.aclAuthorizationStrategy;
    }
}

