/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import com.atlassian.bamboo.plan.cache.BambooCacheStats;
import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.security.acegi.acls.AclDao;
import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.HibernateAclImpl;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.security.acegi.acls.ImmutableAcl;
import com.atlassian.bamboo.utils.BambooOptionals;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.acegisecurity.Authentication;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.AlreadyExistsException;
import org.acegisecurity.acls.ChildrenExistException;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.OwnershipAcl;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.springframework.util.Assert;

public class HibernateMutableAclServiceImpl
implements HibernateMutableAclService {
    private static final Logger log = Logger.getLogger(HibernateMutableAclServiceImpl.class);
    public static final String BAMBOO_PERMISSION_FORM_SEPARATOR = "_";
    public static final String BAMBOO_PERMISSION_FORM_USER = "user";
    public static final String BAMBOO_PERMISSION_FORM_GROUP = "group";
    public static final String BAMBOO_PERMISSION_FORM_ROLE = "role";
    private static final String BAMBOO_PERMISSION_PREFIX = "bambooPermission";
    public static final String BAMBOO_PERMISSION_FORM_USER_PREFIX = "bambooPermission_user_";
    public static final String BAMBOO_PERMISSION_FORM_GROUP_PREFIX = "bambooPermission_group_";
    public static final String BAMBOO_PERMISSION_FORM_ROLE_PREFIX = "bambooPermission_role_";
    private final LoadingCache<ObjectIdentity, Optional<ImmutableAcl>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<ObjectIdentity, Optional<ImmutableAcl>>(){

        public Optional<ImmutableAcl> load(ObjectIdentity from) {
            Acl acl = (Acl)HibernateMutableAclServiceImpl.this.aclDao.findAcls(from).get(from);
            return Optional.ofNullable(ImmutableAcl.copyOf(acl));
        }
    });
    private AclDao aclDao;
    private BambooAclUpdateHelper aclUpdateHelper;

    public ObjectIdentity[] findChildren(ObjectIdentity parentIdentity) {
        List list = this.aclDao.findAclObjectWithParent(parentIdentity);
        ObjectIdentity[] children = list.toArray(new ObjectIdentity[0]);
        return children;
    }

    public Acl readAclById(ObjectIdentity object) throws NotFoundException {
        return this.readAclById(object, null);
    }

    public Acl readAclById(ObjectIdentity object, @Nullable Sid[] sids) throws NotFoundException {
        Map<ObjectIdentity, Acl> map = this.readAclsById(new ObjectIdentity[]{object}, sids);
        Acl acl = map.get(object);
        if (acl == null || acl == ImmutableAcl.NULL_ACL) {
            throw new NotFoundException("Could not find ACL for " + object);
        }
        return acl;
    }

    public Map<ObjectIdentity, Acl> readAclsById(ObjectIdentity[] objects) throws NotFoundException {
        return this.readAclsById(objects, null);
    }

    public Map<ObjectIdentity, Acl> readAclsById(ObjectIdentity[] objects, @Nullable Sid[] sids) throws NotFoundException {
        return Arrays.stream(objects).distinct().map(oid -> ((Optional)this.cache.getUnchecked(oid)).map(acl -> Pair.of((Object)oid, (Object)acl))).flatMap(BambooOptionals::stream).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public MutableAcl createAcl(ObjectIdentity objectIdentity) throws AlreadyExistsException {
        Assert.notNull((Object)objectIdentity, (String)"Object Identity required");
        if (!this.readAclsById(new ObjectIdentity[]{objectIdentity}).isEmpty()) {
            throw new AlreadyExistsException("Object identity '" + objectIdentity + "' already exists");
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        PrincipalSid sid = new PrincipalSid(auth);
        HibernateAclImpl acl = new HibernateAclImpl(objectIdentity, null, true, (Sid)sid);
        this.aclDao.save((Acl)acl);
        this.removeFromCache(acl);
        return acl;
    }

    public void deleteAcl(ObjectIdentity objectIdentity, boolean deleteChildren) throws ChildrenExistException {
        ObjectIdentity[] children = this.findChildren(objectIdentity);
        if (deleteChildren) {
            for (int i = 0; i < children.length; ++i) {
                this.deleteAcl(children[i], true);
            }
        } else if (children.length > 0) {
            throw new ChildrenExistException("Cannot delete '" + objectIdentity + "' (has " + children.length + " children)");
        }
        try {
            MutableAcl acl = this.readMutableAclById(objectIdentity);
            this.aclDao.remove((Acl)acl);
            this.removeFromCache((Acl)acl);
        }
        catch (NotFoundException e) {
            log.warn((Object)"No ACLs were found to remove... Ignoring.");
        }
    }

    public MutableAcl updateAcl(MutableAcl acl) throws NotFoundException {
        this.aclDao.save((Acl)acl);
        this.removeFromCache((Acl)acl);
        return acl;
    }

    public void updateAclAces(MutableAcl acl, List<String> newPermissionKeys) {
        this.aclUpdateHelper.modifyAclAces(acl, newPermissionKeys);
        this.updateAcl(acl);
    }

    public void deleteAllAcls() {
        this.cache.invalidateAll();
        List allAcls = this.aclDao.findAll();
        if (allAcls != null && !allAcls.isEmpty()) {
            for (Acl object : allAcls) {
                this.aclDao.remove(object);
            }
        }
    }

    public MutableAcl readMutableAclById(ObjectIdentity objectId) {
        Map map = this.aclDao.findAcls(objectId);
        if (map.isEmpty()) {
            throw new NotFoundException("Could not find ACL");
        }
        return (MutableAcl)map.get(objectId);
    }

    public MutableAcl readMutableAclById(long objectId) {
        MutableAcl acl = this.aclDao.findAcl(objectId);
        if (acl == null) {
            throw new NotFoundException("Could not find ACL");
        }
        return acl;
    }

    private void removeFromCache(Acl obj) {
        this.cache.invalidate((Object)obj.getObjectIdentity());
    }

    public BambooCacheStats getCacheStats() {
        return new BambooCacheStats(this.cache);
    }

    public void invalidateCache() {
        this.cache.invalidateAll();
    }

    public void setAclDao(AclDao aclDao) {
        this.aclDao = aclDao;
    }

    public void setAclUpdateHelper(BambooAclUpdateHelper aclUpdateHelper) {
        this.aclUpdateHelper = aclUpdateHelper;
    }

    public void deleteAcesForSid(Sid sid) {
        List list = this.aclDao.findAcesForSid(sid);
        for (AccessControlEntry ace : list) {
            MutableAcl acl = (MutableAcl)ace.getAcl();
            acl.deleteAce(ace.getId());
            this.removeFromCache((Acl)acl);
            this.aclDao.save((Acl)acl);
        }
    }

    public boolean hasAcesForSid(Sid sid) {
        return this.aclDao.hasAcesForSid(sid);
    }

    public void changeAlcOwnerForSid(Sid oldOwner, Sid newOwner) {
        List aclsOwnedBySid = this.aclDao.findAclsOwnedBySid(oldOwner);
        for (OwnershipAcl acl : aclsOwnedBySid) {
            acl.setOwner(newOwner);
            this.removeFromCache((Acl)acl);
            this.aclDao.save((Acl)acl);
        }
    }

    public MutableAcl getAclOfGlobalPermission() {
        HibernateObjectIdentityImpl globalPermissionObjectId = new HibernateObjectIdentityImpl(GlobalApplicationSecureObject.INSTANCE);
        return this.readMutableAclById(globalPermissionObjectId);
    }
}

