/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import com.atlassian.bamboo.security.acegi.acls.objectidentity.ObjectIdentityUtils;
import com.atlassian.bamboo.utils.BambooFunctions;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Functions;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.acegisecurity.acls.IdentityUnavailableException;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.hibernate.Hibernate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class HibernateObjectIdentityImpl
implements ObjectIdentity {
    @NotNull
    private Class javaType;
    @NotNull
    private Serializable identifier;
    @Nullable
    private HibernateObjectIdentityImpl ancestorIdentity;
    private Map<Permission, AncestorPermissionCheckPolicy> ancestorPermissionCheckPolicyMap = new HashMap<Permission, AncestorPermissionCheckPolicy>();

    public HibernateObjectIdentityImpl(String javaType, @NotNull Serializable identifier) {
        Class<?> javaClass;
        Assert.hasText((String)javaType, (String)"Java Type required");
        Assert.notNull((Object)identifier, (String)"identifier required");
        try {
            javaClass = Class.forName(javaType);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException((Exception)ex);
            throw new IllegalStateException("unreachable");
        }
        Optional<Class<?>> overriddenType = ObjectIdentityUtils.getAclClassForEntityClass(javaClass);
        this.javaType = overriddenType.orElse(javaClass);
        this.identifier = identifier;
    }

    public HibernateObjectIdentityImpl(@NotNull Class javaType, @NotNull Serializable identifier) {
        this(javaType, identifier, null);
    }

    public HibernateObjectIdentityImpl(@NotNull Class javaType, @NotNull Serializable identifier, @Nullable HibernateObjectIdentityImpl ancestorIdentity) {
        Assert.notNull((Object)javaType, (String)"Java Type required");
        Assert.notNull((Object)identifier, (String)"identifier required");
        Optional<Class<?>> overriddenType = ObjectIdentityUtils.getAclClassForEntityClass(javaType);
        this.javaType = overriddenType.orElse(javaType);
        this.identifier = identifier;
        this.ancestorIdentity = ancestorIdentity;
    }

    public HibernateObjectIdentityImpl(@NotNull Object object) throws IdentityUnavailableException {
        Object result;
        Assert.notNull((Object)object, (String)"object cannot be null");
        Class objectType = Hibernate.getClass((Object)object);
        Optional<Class<?>> overriddenType = ObjectIdentityUtils.getAclClassForEntityClass(objectType);
        this.javaType = overriddenType.orElse(objectType);
        try {
            Method method = objectType.getMethod("getId", new Class[0]);
            result = method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new IdentityUnavailableException("Could not extract identity from object " + object, (Throwable)e);
        }
        Assert.isInstanceOf(Serializable.class, (Object)result, (String)"Getter must provide a return value of type Serializable");
        this.identifier = (Serializable)result;
        this.ancestorIdentity = null;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (!(arg0 instanceof HibernateObjectIdentityImpl)) {
            return false;
        }
        HibernateObjectIdentityImpl other = (HibernateObjectIdentityImpl)arg0;
        return this.identifier.equals(other.identifier) && this.javaType.equals(other.javaType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.javaType, this.identifier});
    }

    public Serializable getIdentifier() {
        return this.identifier;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    void setJavaType(Class javaType) {
        this.javaType = javaType;
    }

    void setIdentifier(Serializable identifier) {
        this.identifier = identifier;
    }

    @Nullable
    public HibernateObjectIdentityImpl getAncestorIdentity() {
        return this.ancestorIdentity;
    }

    void setAncestorPermissionCheckPolicy(@NotNull Permission permission, @NotNull AncestorPermissionCheckPolicy policy) {
        this.ancestorPermissionCheckPolicyMap.put(permission, policy);
    }

    public AncestorPermissionCheckPolicy getAncestorPermissionCheckPolicy(@NotNull Permission permission) {
        return this.getHighestRankPermissionCheckPolicy((Iterable<Permission>)ImmutableList.of((Object)permission));
    }

    public AncestorPermissionCheckPolicy getHighestRankPermissionCheckPolicy(@Nullable Permission[] permissions) {
        if (permissions != null) {
            return this.getHighestRankPermissionCheckPolicy(Arrays.asList(permissions));
        }
        return this.getHighestRankPermissionCheckPolicy((Iterable<Permission>)ImmutableList.of());
    }

    public AncestorPermissionCheckPolicy getHighestRankPermissionCheckPolicy(@NotNull Iterable<Permission> permissions) {
        Iterable permissionCheckPolicies = Iterables.transform(permissions, (Function)new Function<Permission, AncestorPermissionCheckPolicy>(){

            public AncestorPermissionCheckPolicy apply(@Nullable Permission key) {
                key = (Permission)Preconditions.checkNotNull((Object)key);
                return HibernateObjectIdentityImpl.this.ancestorPermissionCheckPolicyMap.getOrDefault(key, AncestorPermissionCheckPolicy.OR);
            }
        });
        return (AncestorPermissionCheckPolicy)((Object)Functions.fold(BambooFunctions.lesserOf(), (Object)((Object)AncestorPermissionCheckPolicy.OR), (Iterable)permissionCheckPolicies));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Java Type", (Object)this.javaType).add("Identifier", (Object)this.identifier).toString();
    }

    public static enum AncestorPermissionCheckPolicy {
        AND,
        OR;

    }
}

