/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import com.atlassian.bamboo.chains.DefaultChain;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.deployments.cache.LinkedDeploymentProject;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.InternalEnvironment;
import com.atlassian.bamboo.deployments.environments.index.IndexedEnvironment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.DeploymentProjectStatusForResultSummary;
import com.atlassian.bamboo.deployments.projects.DeploymentProjectWithEnvironmentStatuses;
import com.atlassian.bamboo.deployments.projects.InternalDeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.deployments.results.InternalDeploymentResult;
import com.atlassian.bamboo.deployments.versions.InternalDeploymentVersion;
import com.atlassian.bamboo.deployments.versions.index.IndexedVersion;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.project.ProjectPlanPermissions;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDataEntityImpl;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.Serializable;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.objectidentity.ObjectIdentityRetrievalStrategy;
import org.jetbrains.annotations.NotNull;

public class HibernateObjectIdentityRetrievalStrategyImpl
implements ObjectIdentityRetrievalStrategy {
    private final Supplier<CachedPlanManager> planManager = ComponentAccessor.CACHED_PLAN_MANAGER;
    private final Supplier<EnvironmentService> environmentService = ComponentAccessor.ENVIRONMENT_SERVICE;
    private final Supplier<DeploymentProjectService> deploymentProjectService = ComponentAccessor.DEPLOYMENT_PROJECT_SERVICE;

    public ObjectIdentity getObjectIdentity(@NotNull Object domainObject) {
        if (domainObject instanceof HibernateObjectIdentityImpl) {
            return (ObjectIdentity)domainObject;
        }
        if (domainObject instanceof ProjectPlanPermissions) {
            return new HibernateObjectIdentityImpl(domainObject);
        }
        if (domainObject instanceof Project) {
            return new HibernateObjectIdentityImpl(domainObject);
        }
        if (domainObject instanceof ProjectIdentifier) {
            return new HibernateObjectIdentityImpl(domainObject);
        }
        ImmutablePlan objectAsPlan = (ImmutablePlan)Narrow.downTo((Object)domainObject, ImmutablePlan.class);
        if (objectAsPlan != null) {
            return new HibernateObjectIdentityImpl(DefaultChain.class, (Serializable)Long.valueOf(PlanHelper.getPermissionPlanId(objectAsPlan)));
        }
        if (domainObject instanceof PlanIdentifier) {
            PlanIdentifier planIdentifier = (PlanIdentifier)domainObject;
            if (PlanType.CHAIN == planIdentifier.getPlanType()) {
                return new HibernateObjectIdentityImpl(DefaultChain.class, (Serializable)Long.valueOf(planIdentifier.getId()));
            }
            if (PlanType.CHAIN_BRANCH == planIdentifier.getPlanType()) {
                return new HibernateObjectIdentityImpl(DefaultChain.class, (Serializable)Long.valueOf(planIdentifier.getMasterId()));
            }
            ImmutablePlan plan = ((CachedPlanManager)this.planManager.get()).getPlanByKey(planIdentifier.getPlanKey());
            return this.getObjectIdentity(Preconditions.checkNotNull((Object)plan));
        }
        if (domainObject instanceof ImmutableChainStage) {
            return this.getObjectIdentity(((ImmutableChainStage)domainObject).getChain());
        }
        if (domainObject instanceof ResultsSummary) {
            ResultsSummary brs = (ResultsSummary)domainObject;
            ImmutablePlan plan = ((CachedPlanManager)this.planManager.get()).getPlanByKey(brs.getPlanKey());
            return this.getObjectIdentity(Preconditions.checkNotNull((Object)plan));
        }
        if (domainObject instanceof RepositoryData || domainObject instanceof RepositoryDataEntity || domainObject instanceof VcsRepositoryData || domainObject instanceof PartialVcsRepositoryData) {
            return new HibernateObjectIdentityImpl(RepositoryDataEntityImpl.class, (Serializable)Long.valueOf(((BambooIdProvider)domainObject).getId()));
        }
        if (domainObject instanceof InternalDeploymentProject) {
            return this.forDeploymentProject((InternalDeploymentProject)domainObject);
        }
        if (domainObject instanceof InternalEnvironment) {
            return this.forEnvironment((InternalEnvironment)domainObject);
        }
        if (domainObject instanceof IndexedEnvironment) {
            return this.forEnvironment(((IndexedEnvironment)domainObject).getEnvironmentId(), ((IndexedEnvironment)domainObject).getProjectId());
        }
        if (domainObject instanceof DeploymentProjectWithEnvironmentStatuses) {
            return this.getObjectIdentity(((DeploymentProjectWithEnvironmentStatuses)domainObject).getDeploymentProject());
        }
        if (domainObject instanceof DeploymentProjectStatusForResultSummary) {
            return this.getObjectIdentity(((DeploymentProjectStatusForResultSummary)domainObject).getDeploymentProject());
        }
        if (domainObject instanceof InternalDeploymentResult) {
            long environmentId = ((InternalDeploymentResult)domainObject).getEnvironmentId();
            Environment environment = ((EnvironmentService)this.environmentService.get()).getEnvironment(environmentId);
            Preconditions.checkNotNull((Object)environment);
            return new HibernateObjectIdentityImpl(InternalEnvironment.class, Long.valueOf(environmentId), this.forDeploymentProject(environment.getDeploymentProjectId()));
        }
        if (domainObject instanceof LinkedDeploymentProject) {
            return this.forDeploymentProject(((LinkedDeploymentProject)domainObject).getId());
        }
        if (domainObject instanceof InternalDeploymentVersion) {
            return this.forDeploymentVersion(((InternalDeploymentVersion)domainObject).getId());
        }
        if (domainObject instanceof IndexedVersion) {
            return this.forDeploymentProject(((IndexedVersion)domainObject).getProjectId());
        }
        return new HibernateObjectIdentityImpl(domainObject);
    }

    private HibernateObjectIdentityImpl forEnvironment(InternalEnvironment environment) {
        return this.forEnvironment(environment.getId(), environment.getDeploymentProjectId());
    }

    private HibernateObjectIdentityImpl forEnvironment(long environmentId, long deploymentProjectId) {
        HibernateObjectIdentityImpl identity = new HibernateObjectIdentityImpl(InternalEnvironment.class, Long.valueOf(environmentId), this.forDeploymentProject(deploymentProjectId));
        identity.setAncestorPermissionCheckPolicy((Permission)BambooPermission.READ, HibernateObjectIdentityImpl.AncestorPermissionCheckPolicy.AND);
        return identity;
    }

    private HibernateObjectIdentityImpl forDeploymentVersion(long deploymentVersionId) {
        DeploymentProject deploymentProject = ((DeploymentProjectService)this.deploymentProjectService.get()).getDeploymentProjectForVersion(deploymentVersionId);
        Preconditions.checkArgument((deploymentProject != null ? 1 : 0) != 0, (String)"Expected that DeploymentProject exists for DeploymentVersion %s", (Object[])new Object[]{deploymentVersionId});
        assert (deploymentProject != null);
        return this.forDeploymentProject((InternalDeploymentProject)deploymentProject);
    }

    private HibernateObjectIdentityImpl forDeploymentProject(InternalDeploymentProject deploymentProject) {
        return this.forDeploymentProject(deploymentProject.getId());
    }

    private HibernateObjectIdentityImpl forDeploymentProject(long deploymentProjectId) {
        return new HibernateObjectIdentityImpl(InternalDeploymentProject.class, (Serializable)Long.valueOf(deploymentProjectId));
    }
}

