/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;

public class HibernateObjectIdentityUserType
implements CompositeUserType,
Serializable {
    private static final Logger log = Logger.getLogger(HibernateObjectIdentityUserType.class);

    public String[] getPropertyNames() {
        return new String[]{"javaType", "identifier"};
    }

    public Type[] getPropertyTypes() {
        return new Type[]{StandardBasicTypes.STRING, StandardBasicTypes.LONG};
    }

    public Object getPropertyValue(Object object, int i) throws HibernateException {
        HibernateObjectIdentityImpl objectIdentity = (HibernateObjectIdentityImpl)object;
        if (i == 0) {
            return objectIdentity.getJavaType().getName();
        }
        return objectIdentity.getIdentifier();
    }

    public void setPropertyValue(Object object, int i, Object object1) throws HibernateException {
        HibernateObjectIdentityImpl objectIdentity = (HibernateObjectIdentityImpl)object;
        if (i == 0) {
            String className = (String)object1;
            try {
                objectIdentity.setJavaType(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                log.error((Object)e, (Throwable)e);
                throw new HibernateException("No such class: " + className, (Throwable)e);
            }
        } else {
            Long identifier = (Long)object1;
            objectIdentity.setIdentifier(identifier);
        }
    }

    public Class returnedClass() {
        return HibernateObjectIdentityImpl.class;
    }

    public boolean equals(Object object, Object object1) throws HibernateException {
        if (object == object1) {
            return true;
        }
        if (object == null || object1 == null) {
            return false;
        }
        return object.equals(object1);
    }

    public Object nullSafeGet(ResultSet resultSet, String[] strings, SharedSessionContractImplementor session, Object object) throws HibernateException, SQLException {
        String className = resultSet.getString(strings[0]);
        if (className != null && !resultSet.wasNull()) {
            Long identifier = resultSet.getLong(strings[1]);
            HibernateObjectIdentityImpl objectIdentifier = new HibernateObjectIdentityImpl(className, (Serializable)identifier);
            return objectIdentifier;
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int i, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (object == null) {
            preparedStatement.setNull(i, 12);
            preparedStatement.setNull(i + 1, 2);
        } else {
            HibernateObjectIdentityImpl objectIdentityImpl = (HibernateObjectIdentityImpl)object;
            String className = objectIdentityImpl.getJavaType().getName();
            Long identifier = (Long)objectIdentityImpl.getIdentifier();
            preparedStatement.setString(i, className);
            preparedStatement.setLong(i + 1, identifier);
        }
    }

    public Object deepCopy(Object object) throws HibernateException {
        return object;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object object, SharedSessionContractImplementor session) throws HibernateException {
        return (Serializable)object;
    }

    public Object assemble(Serializable serializable, SharedSessionContractImplementor session, Object object) throws HibernateException {
        return serializable;
    }

    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        return original;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }
}

