/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import com.atlassian.bamboo.security.acegi.acls.GroupPrincipalSid;
import com.atlassian.bamboo.util.Narrow;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;

public class HibernateSidUserType
implements CompositeUserType,
Serializable {
    private static final Logger log = Logger.getLogger(HibernateSidUserType.class);
    public static final String SID_TYPE_PRINCIPAL = "PRINCIPAL";
    public static final String SID_TYPE_GROUP_PRINCIPAL = "GROUP_PRINCIPAL";
    public static final String SID_TYPE_GRANTED_AUTHORITY = "GRANTED_AUTHORITY";

    public String[] getPropertyNames() {
        return new String[]{"type", "sid"};
    }

    public Type[] getPropertyTypes() {
        return new Type[]{StandardBasicTypes.STRING, StandardBasicTypes.STRING};
    }

    public Object getPropertyValue(Object object, int i) throws HibernateException {
        Sid sid = (Sid)object;
        if (i == 0) {
            if (sid instanceof GroupPrincipalSid) {
                return SID_TYPE_GROUP_PRINCIPAL;
            }
            if (sid instanceof PrincipalSid) {
                return SID_TYPE_PRINCIPAL;
            }
            return SID_TYPE_GRANTED_AUTHORITY;
        }
        if (sid instanceof GroupPrincipalSid) {
            return ((GroupPrincipalSid)sid).getPrincipal();
        }
        if (sid instanceof PrincipalSid) {
            return ((PrincipalSid)sid).getPrincipal();
        }
        return ((GrantedAuthoritySid)sid).getGrantedAuthority();
    }

    public void setPropertyValue(Object object, int i, Object object1) throws HibernateException {
    }

    public Class returnedClass() {
        return Sid.class;
    }

    public boolean equals(Object object, Object object1) throws HibernateException {
        if (object == object1) {
            return true;
        }
        if (object == null || object1 == null) {
            return false;
        }
        return object.equals(object1);
    }

    public Object nullSafeGet(ResultSet resultSet, String[] strings, SharedSessionContractImplementor session, Object object) throws HibernateException, SQLException {
        if (resultSet.wasNull()) {
            return null;
        }
        String type = resultSet.getString(strings[0]);
        String sid = resultSet.getString(strings[1]);
        if (SID_TYPE_PRINCIPAL.equals(type)) {
            return new PrincipalSid(sid);
        }
        if (SID_TYPE_GROUP_PRINCIPAL.equals(type)) {
            return new GroupPrincipalSid(sid);
        }
        return new GrantedAuthoritySid(sid);
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int i, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (object == null) {
            preparedStatement.setNull(i, 12);
            preparedStatement.setNull(i + 1, 12);
        } else if (object instanceof GroupPrincipalSid) {
            GroupPrincipalSid principalSid = (GroupPrincipalSid)object;
            preparedStatement.setString(i, SID_TYPE_GROUP_PRINCIPAL);
            preparedStatement.setString(i + 1, principalSid.getPrincipal());
        } else if (object instanceof PrincipalSid) {
            PrincipalSid principalSid = (PrincipalSid)object;
            preparedStatement.setString(i, SID_TYPE_PRINCIPAL);
            preparedStatement.setString(i + 1, principalSid.getPrincipal());
        } else {
            GrantedAuthoritySid grantedAuthSid = (GrantedAuthoritySid)object;
            preparedStatement.setString(i, SID_TYPE_GRANTED_AUTHORITY);
            preparedStatement.setString(i + 1, grantedAuthSid.getGrantedAuthority());
        }
    }

    public Object deepCopy(Object object) throws HibernateException {
        return object;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object object, SharedSessionContractImplementor session) throws HibernateException {
        PrincipalSid principalSid = (PrincipalSid)Narrow.downTo((Object)object, PrincipalSid.class);
        if (principalSid != null) {
            return new SerializablePrincipalSid(principalSid);
        }
        GroupPrincipalSid groupPrincipalSid = (GroupPrincipalSid)Narrow.downTo((Object)object, GroupPrincipalSid.class);
        if (groupPrincipalSid != null) {
            return new SerializableGroupPrincipalSid(groupPrincipalSid);
        }
        GrantedAuthoritySid grantedAuthoritySid = (GrantedAuthoritySid)Narrow.downTo((Object)object, GrantedAuthoritySid.class);
        if (grantedAuthoritySid != null) {
            return new SerializableGrantedAuthoritySid(grantedAuthoritySid);
        }
        throw new UnsupportedOperationException("Cannot disassemble: " + object.getClass());
    }

    public Object assemble(Serializable serializable, SharedSessionContractImplementor session, Object object) throws HibernateException {
        return serializable;
    }

    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        return original;
    }

    public int hashCode(Object x) throws HibernateException {
        PrincipalSid principalSid = (PrincipalSid)Narrow.downTo((Object)x, PrincipalSid.class);
        if (principalSid != null) {
            return principalSid.getPrincipal().hashCode();
        }
        GroupPrincipalSid groupPrincipalSid = (GroupPrincipalSid)Narrow.downTo((Object)x, GroupPrincipalSid.class);
        if (groupPrincipalSid != null) {
            return groupPrincipalSid.getPrincipal().hashCode();
        }
        GrantedAuthoritySid grantedAuthoritySid = (GrantedAuthoritySid)Narrow.downTo((Object)x, GrantedAuthoritySid.class);
        if (grantedAuthoritySid != null) {
            return grantedAuthoritySid.getGrantedAuthority().hashCode();
        }
        throw new UnsupportedOperationException("Cannot generate a hascode for: " + x.getClass().getName());
    }

    public class SerializableGrantedAuthoritySid
    extends GrantedAuthoritySid
    implements Serializable {
        public SerializableGrantedAuthoritySid(GrantedAuthoritySid grantedAuthoritySid) {
            super(grantedAuthoritySid.getGrantedAuthority());
        }
    }

    public class SerializableGroupPrincipalSid
    extends GroupPrincipalSid
    implements Serializable {
        public SerializableGroupPrincipalSid(GroupPrincipalSid groupPrincipalSid) {
            super(groupPrincipalSid.getPrincipal());
        }
    }

    public class SerializablePrincipalSid
    extends PrincipalSid
    implements Serializable {
        public SerializablePrincipalSid(PrincipalSid principalSid) {
            super(principalSid.getPrincipal());
        }
    }
}

