/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateAclImpl;
import com.atlassian.bamboo.user.Authority;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.UnloadedSidException;
import org.acegisecurity.acls.domain.AclAuthorizationStrategy;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.acegisecurity.acls.sid.Sid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.util.Assert;

public final class ImmutableAcl
implements Acl {
    @Deprecated
    static final ImmutableAcl NULL_ACL = new ImmutableAcl(null, null, null, null, false, Collections.emptyList(), null, null);
    private final ObjectIdentity oid;
    private final Serializable id;
    private final Sid owner;
    private final Acl parent;
    private final boolean entriesInheriting;
    private final Collection<AccessControlEntry> entries;
    private final LoadedSidValidator loadedSids;
    private final AclAuthorizationStrategy aclAuthorizationStrategy;

    @Nullable
    public static ImmutableAcl copyOf(Acl from) {
        AclAuthorizationStrategy aclAuthorizationStrategy;
        Sid[] sids;
        if (from == null) {
            return null;
        }
        if (from instanceof ImmutableAcl) {
            return (ImmutableAcl)from;
        }
        ObjectIdentity oid = from.getObjectIdentity();
        Sid owner = from.getOwner();
        Acl parent = from.getParentAcl();
        boolean entriesInheriting = from.isEntriesInheriting();
        ImmutableList entries = ImmutableList.copyOf((Object[])from.getEntries());
        Serializable id = from instanceof MutableAcl ? ((MutableAcl)from).getId() : null;
        if (from instanceof HibernateAclImpl) {
            HibernateAclImpl hibernateAcl = (HibernateAclImpl)from;
            sids = hibernateAcl.getLoadedSids();
            aclAuthorizationStrategy = hibernateAcl.getAclAuthorizationStrategy();
        } else {
            sids = null;
            aclAuthorizationStrategy = null;
        }
        return new ImmutableAcl(oid, id, owner, parent, entriesInheriting, (Collection<AccessControlEntry>)entries, sids, aclAuthorizationStrategy);
    }

    @Deprecated
    @NotNull
    public static ImmutableAcl notNullcopyOf(@Nullable Acl acl) {
        if (acl == null) {
            return NULL_ACL;
        }
        return ImmutableAcl.copyOf(acl);
    }

    ImmutableAcl(ObjectIdentity oid, Serializable id, Sid owner, Acl parent, boolean entriesInheriting, Collection<AccessControlEntry> entries, Sid[] loadedSids, AclAuthorizationStrategy aclAuthorizationStrategy) {
        this.oid = oid;
        this.id = id;
        this.owner = owner;
        this.parent = ImmutableAcl.copyOf(parent);
        this.entriesInheriting = entriesInheriting;
        this.entries = ImmutableList.copyOf(entries);
        this.loadedSids = LoadedSidValidator.get(loadedSids);
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
    }

    public ObjectIdentity getObjectIdentity() {
        return this.oid;
    }

    public Sid getOwner() {
        return this.owner;
    }

    public Acl getParentAcl() {
        return this.parent;
    }

    public boolean isEntriesInheriting() {
        return this.entriesInheriting;
    }

    public AccessControlEntry[] getEntries() {
        return this.entries.toArray(new AccessControlEntry[0]);
    }

    public boolean isGranted(Permission[] permission, Sid[] sids, boolean administrativeMode) throws NotFoundException, UnloadedSidException {
        Assert.notEmpty((Object[])permission, (String)"Permissions required");
        Assert.notEmpty((Object[])sids, (String)"SIDs required");
        if (!this.isSidLoaded(sids)) {
            throw new UnloadedSidException("ACL was not loaded for one or more SID");
        }
        AccessControlEntry firstRejection = null;
        block0: for (Permission element : permission) {
            for (Sid sid : sids) {
                if (element.equals(BambooPermission.CLONE) && sid instanceof GrantedAuthoritySid && ((GrantedAuthoritySid)sid).getGrantedAuthority().equals(Authority.RESTRICTED_ADMIN.getAuthority())) {
                    return true;
                }
                Iterator<AccessControlEntry> acesIterator = this.entries.iterator();
                boolean scanNextSid = true;
                while (acesIterator.hasNext()) {
                    AccessControlEntry ace = acesIterator.next();
                    if (ace.getPermission().getMask() != element.getMask() || !ace.getSid().equals((Object)sid)) continue;
                    if (ace.isGranting()) {
                        return true;
                    }
                    if (firstRejection == null) {
                        firstRejection = ace;
                    }
                    scanNextSid = false;
                    break;
                }
                if (!scanNextSid) continue block0;
            }
        }
        if (firstRejection != null) {
            return false;
        }
        if (this.isEntriesInheriting() && this.parent != null) {
            return this.parent.isGranted(permission, sids, false);
        }
        throw new NotFoundException("Unable to locate a matching ACE for passed permissions and SIDs");
    }

    public boolean isSidLoaded(Sid[] sids) {
        return this.loadedSids.isSidLoaded(sids);
    }

    static abstract class LoadedSidValidator {
        static final LoadedSidValidator NOT_LOADED = new LoadedSidValidator(){

            @Override
            boolean isSidLoaded(Sid[] sids) {
                return true;
            }

            @Override
            @Nullable
            public Sid[] entries() {
                return null;
            }
        };

        LoadedSidValidator() {
        }

        static LoadedSidValidator get(final Sid[] sids) {
            return sids == null ? NOT_LOADED : new LoadedSidValidator(){
                private final Collection<Sid> loadedSids;
                {
                    this.loadedSids = Arrays.asList(sids);
                }

                @Override
                boolean isSidLoaded(Sid[] sids2) {
                    return this.loadedSids.containsAll(Arrays.asList(sids2));
                }

                @Override
                Sid[] entries() {
                    return sids;
                }
            };
        }

        @Nullable
        abstract Sid[] entries();

        abstract boolean isSidLoaded(Sid[] var1);
    }
}

